/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.BaseTransaction;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class RemoteTransaction
extends BaseTransaction {
    TransactionAcknowledgement[] txnAcks;
    DestinationUID[] destIds;
    BrokerAddress txnHomeBroker;

    public RemoteTransaction() {
        super(2);
    }

    public RemoteTransaction(TransactionUID id, TransactionState ts, TransactionAcknowledgement[] txnAcks, DestinationUID[] destIds, BrokerAddress txnHomeBroker) {
        this();
        this.transactionDetails.setTid(id);
        this.transactionDetails.setState(ts.getState());
        this.transactionDetails.setXid(ts.getXid());
        this.transactionState = ts;
        this.setTxnAcks(txnAcks);
        this.setDestIds(destIds);
        this.setTxnHomeBroker(txnHomeBroker);
    }

    @Override
    public void readData(DataInputStream dis) throws IOException, BrokerException {
        this.transactionDetails.readContent(dis);
    }

    @Override
    public void readObjects(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.transactionState = (TransactionState)ois.readObject();
        this.txnAcks = (TransactionAcknowledgement[])ois.readObject();
        this.destIds = (DestinationUID[])ois.readObject();
        this.txnHomeBroker = (BrokerAddress)ois.readObject();
    }

    @Override
    public void writeData(DataOutputStream dos) throws IOException {
        this.transactionDetails.writeContent(dos);
    }

    @Override
    public void writeObjects(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.transactionState);
        oos.writeObject(this.txnAcks);
        oos.writeObject(this.destIds);
        oos.writeObject(this.txnHomeBroker);
    }

    @Override
    String getPrefix() {
        return "RemoteTransaction: " + Thread.currentThread().getName() + " " + String.valueOf(this.getTid());
    }

    public TransactionAcknowledgement[] getTxnAcks() {
        return this.txnAcks;
    }

    public void setTxnAcks(TransactionAcknowledgement[] txnAcks) {
        this.txnAcks = txnAcks;
    }

    public BrokerAddress getTxnHomeBroker() {
        return this.txnHomeBroker;
    }

    public void setTxnHomeBroker(BrokerAddress txnHomeBroker) {
        this.txnHomeBroker = txnHomeBroker;
    }

    public DestinationUID[] getDestIds() {
        return this.destIds;
    }

    public void setDestIds(DestinationUID[] destIds) {
        this.destIds = destIds;
    }
}

