/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.epicyro.config.factory.singlemodule;

import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.config.AuthConfigFactory;
import jakarta.security.auth.message.config.AuthConfigProvider;
import jakarta.security.auth.message.config.ClientAuthConfig;
import jakarta.security.auth.message.config.ServerAuthConfig;
import jakarta.security.auth.message.module.ServerAuthModule;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.glassfish.epicyro.config.factory.singlemodule.DefaultServerAuthConfig;

public class DefaultAuthConfigProvider
implements AuthConfigProvider {
    private static final String CALLBACK_HANDLER_PROPERTY_NAME = "authconfigprovider.client.callbackhandler";
    private Map<String, String> providerProperties;
    private ServerAuthModule serverAuthModule;

    public DefaultAuthConfigProvider(ServerAuthModule serverAuthModule) {
        this.serverAuthModule = serverAuthModule;
    }

    public DefaultAuthConfigProvider(Map<String, String> properties, AuthConfigFactory factory) {
        this.providerProperties = properties;
        if (factory != null) {
            factory.registerConfigProvider((AuthConfigProvider)this, null, null, "Auto registration");
        }
    }

    public ServerAuthConfig getServerAuthConfig(String layer, String appContext, CallbackHandler handler) throws AuthException, SecurityException {
        return new DefaultServerAuthConfig(layer, appContext, handler == null ? this.createDefaultCallbackHandler() : handler, this.providerProperties, this.serverAuthModule);
    }

    public ClientAuthConfig getClientAuthConfig(String layer, String appContext, CallbackHandler handler) throws AuthException, SecurityException {
        return null;
    }

    public void refresh() {
    }

    private CallbackHandler createDefaultCallbackHandler() throws AuthException {
        String callBackClassName = System.getProperty(CALLBACK_HANDLER_PROPERTY_NAME);
        if (callBackClassName == null) {
            throw new AuthException("No default handler set via system property: authconfigprovider.client.callbackhandler");
        }
        try {
            return (CallbackHandler)Thread.currentThread().getContextClassLoader().loadClass(callBackClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new AuthException(e.getMessage());
        }
    }
}

