/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.ComponentContext;
import com.sun.ejb.EjbInvocation;
import com.sun.ejb.InvocationInfo;
import com.sun.ejb.containers.AbstractSessionContextImpl;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EJBLocalObjectImpl;
import com.sun.ejb.containers.EJBLocalRemoteObject;
import com.sun.ejb.containers.EJBObjectImpl;
import com.sun.ejb.containers.RemoteBusinessIntfInfo;
import com.sun.ejb.containers.SimpleEjbResourceHandlerImpl;
import com.sun.ejb.containers.SingletonContextImpl;
import com.sun.ejb.containers.util.pool.ObjectFactory;
import com.sun.ejb.monitoring.stats.EjbMonitoringStatsProvider;
import com.sun.ejb.monitoring.stats.SingletonBeanStatsProvider;
import com.sun.enterprise.admin.monitor.callflow.ComponentType;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.security.SecurityManager;
import com.sun.enterprise.util.Utility;
import jakarta.ejb.CreateException;
import jakarta.ejb.EJBException;
import jakarta.ejb.NoSuchEJBException;
import jakarta.ejb.RemoveException;
import jakarta.transaction.TransactionManager;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.startup.SingletonLifeCycleManager;

public abstract class AbstractSingletonContainer
extends BaseContainer {
    private static final byte[] singletonInstanceKey = new byte[]{0, 0, 0, 1};
    private EJBLocalObjectImpl theEJBLocalBusinessObjectImpl = null;
    private EJBLocalObjectImpl theOptionalEJBLocalBusinessObjectImpl = null;
    private EJBObjectImpl theRemoteBusinessObjectImpl = null;
    protected ObjectFactory singletonCtxFactory;
    private SingletonLifeCycleManager lcm;
    protected AtomicBoolean singletonInitialized = new AtomicBoolean(false);
    private boolean initializationInProgress = false;
    protected boolean singletonInitializationFailed = false;
    protected volatile ComponentContext singletonCtx;
    private InvocationInfo postConstructInvInfo;
    private InvocationInfo preDestroyInvInfo;

    protected AbstractSingletonContainer(EjbDescriptor desc, ClassLoader loader, SecurityManager sm) throws Exception {
        super(BaseContainer.ContainerType.SINGLETON, desc, loader, sm);
        super.createCallFlowAgent(ComponentType.SLSB);
        this.postConstructInvInfo = new InvocationInfo();
        this.postConstructInvInfo.ejbName = this.ejbDescriptor.getName();
        this.postConstructInvInfo.methodIntf = "LifecycleCallback";
        this.postConstructInvInfo.txAttr = this.getTxAttrForLifecycleCallback(this.ejbDescriptor.getPostConstructDescriptors());
        this.preDestroyInvInfo = new InvocationInfo();
        this.preDestroyInvInfo.ejbName = this.ejbDescriptor.getName();
        this.preDestroyInvInfo.methodIntf = "LifecycleCallback";
        this.preDestroyInvInfo.txAttr = this.getTxAttrForLifecycleCallback(this.ejbDescriptor.getPreDestroyDescriptors());
    }

    public String getMonitorAttributeValues() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("SINGLETON ").append(this.ejbDescriptor.getName());
        sbuf.append("]");
        return sbuf.toString();
    }

    @Override
    protected EjbInvocation createEjbInvocation(Object ejb, ComponentContext ctx) {
        EjbInvocation inv = super.createEjbInvocation(ejb, ctx);
        this.setResourceHandler(inv);
        return inv;
    }

    @Override
    protected EjbInvocation createEjbInvocation() {
        EjbInvocation inv = super.createEjbInvocation();
        this.setResourceHandler(inv);
        return inv;
    }

    private void setResourceHandler(EjbInvocation inv) {
        inv.setResourceHandler(SimpleEjbResourceHandlerImpl.getResourceHandler((TransactionManager)this.transactionManager));
    }

    @Override
    protected void initializeHome() throws Exception {
        super.initializeHome();
        if (this.isRemote && this.hasRemoteBusinessView) {
            this.theRemoteBusinessObjectImpl = this.instantiateRemoteBusinessObjectImpl();
            for (RemoteBusinessIntfInfo next : this.remoteBusinessIntfInfo.values()) {
                Remote stub = next.referenceFactory.createRemoteReference(singletonInstanceKey);
                this.theRemoteBusinessObjectImpl.setStub(next.generatedRemoteIntf.getName(), stub);
            }
        }
        if (this.isLocal) {
            if (this.hasLocalBusinessView) {
                this.theEJBLocalBusinessObjectImpl = this.instantiateEJBLocalBusinessObjectImpl();
            }
            if (this.hasOptionalLocalBusinessView) {
                this.theOptionalEJBLocalBusinessObjectImpl = this.instantiateOptionalEJBLocalBusinessObjectImpl();
            }
        }
        this.createBeanPool();
        this.registerMonitorableComponents();
    }

    private void createBeanPool() {
        this.singletonCtxFactory = new SingletonContextFactory();
    }

    private int getTxAttrForLifecycleCallback(Set<LifecycleCallbackDescriptor> lifecycleCallbackDescriptors) throws Exception {
        return this.getTxAttrForLifecycleCallback(lifecycleCallbackDescriptors, 5, 1);
    }

    @Override
    protected void registerMonitorableComponents() {
        super.registerMonitorableComponents();
        _logger.log(Level.FINE, "[Singleton Container] registered monitorable");
    }

    @Override
    protected EjbMonitoringStatsProvider getMonitoringStatsProvider(String appName, String modName, String ejbName) {
        return new SingletonBeanStatsProvider(this.getContainerId(), appName, modName, ejbName);
    }

    @Override
    public void onReady() {
    }

    @Override
    public EJBObjectImpl createRemoteBusinessObjectImpl() throws CreateException, RemoteException {
        this.ejbProbeNotifier.ejbBeanCreatedEvent(this.getContainerId(), this.containerInfo.appName, this.containerInfo.modName, this.containerInfo.ejbName);
        return this.theRemoteBusinessObjectImpl;
    }

    @Override
    public EJBObjectImpl createEJBObjectImpl() throws CreateException, RemoteException {
        throw new CreateException("EJB 2.x Remote view not supported on Singletons");
    }

    @Override
    public EJBLocalObjectImpl createEJBLocalObjectImpl() throws CreateException {
        throw new CreateException("EJB 2.x Local view not supported on Singletons");
    }

    @Override
    public EJBLocalObjectImpl createEJBLocalBusinessObjectImpl(boolean localBeanView) throws CreateException {
        return localBeanView ? this.theOptionalEJBLocalBusinessObjectImpl : this.theEJBLocalBusinessObjectImpl;
    }

    @Override
    protected void removeBean(EJBLocalRemoteObject ejbo, Method removeMethod, boolean local) throws RemoveException, EJBException, RemoteException {
        throw new EJBException("Not applicable to Singletons");
    }

    @Override
    protected void forceDestroyBean(EJBContextImpl sc) {
    }

    @Override
    protected EJBObjectImpl getEJBObjectImpl(byte[] instanceKey) {
        return null;
    }

    @Override
    EJBObjectImpl getEJBRemoteBusinessObjectImpl(byte[] instanceKey) {
        return this.theRemoteBusinessObjectImpl;
    }

    @Override
    protected EJBLocalObjectImpl getEJBLocalObjectImpl(Object key) {
        return null;
    }

    @Override
    EJBLocalObjectImpl getEJBLocalBusinessObjectImpl(Object key) {
        return this.theEJBLocalBusinessObjectImpl;
    }

    @Override
    EJBLocalObjectImpl getOptionalEJBLocalBusinessObjectImpl(Object key) {
        return this.theOptionalEJBLocalBusinessObjectImpl;
    }

    public void setSingletonLifeCycleManager(SingletonLifeCycleManager lcm) {
        this.lcm = lcm;
    }

    protected void checkInit() {
        if (this.singletonInitializationFailed) {
            throw new NoSuchEJBException("Singleton " + this.ejbDescriptor.getName() + " is unavailable because its original initialization failed.");
        }
        if (!this.singletonInitialized.get()) {
            this.lcm.initializeSingleton(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentContext instantiateSingletonInstance() {
        if (!this.singletonInitialized.get()) {
            AbstractSingletonContainer abstractSingletonContainer = this;
            synchronized (abstractSingletonContainer) {
                if (!this.singletonInitialized.get()) {
                    if (this.initializationInProgress) {
                        throw new EJBException("Illegal synchronous loopback call during Singleton " + this.ejbDescriptor.getName() + " initialization would have resulted in deadlock");
                    }
                    this.initializationInProgress = true;
                    ClassLoader originalCCL = null;
                    try {
                        originalCCL = Utility.setContextClassLoader((ClassLoader)this.loader);
                        this.singletonCtx = (ComponentContext)this.singletonCtxFactory.create(null);
                        this.singletonInitialized.set(true);
                    }
                    finally {
                        if (originalCCL != null) {
                            Utility.setContextClassLoader((ClassLoader)originalCCL);
                        }
                    }
                }
            }
        }
        return this.singletonCtx;
    }

    @Override
    protected EJBContextImpl _constructEJBContextImpl(Object instance) {
        return new SingletonContextImpl(instance, this);
    }

    private SingletonContextImpl createSingletonEJB() throws CreateException {
        SingletonContextImpl context;
        EjbInvocation ejbInv = null;
        boolean initGotToPreInvokeTx = false;
        try {
            context = (SingletonContextImpl)this.createEjbInstanceAndContext();
            Object ejb = context.getEJB();
            ejbInv = this.createEjbInvocation(ejb, context);
            this.invocationManager.preInvoke((ComponentInvocation)ejbInv);
            this.injectEjbInstance(context);
            if (this.isRemote && this.hasRemoteBusinessView) {
                context.setEJBRemoteBusinessObjectImpl(this.theRemoteBusinessObjectImpl);
            }
            if (this.isLocal) {
                if (this.hasLocalBusinessView) {
                    context.setEJBLocalBusinessObjectImpl(this.theEJBLocalBusinessObjectImpl);
                }
                if (this.hasOptionalLocalBusinessView) {
                    context.setOptionalEJBLocalBusinessObjectImpl(this.theOptionalEJBLocalBusinessObjectImpl);
                }
            }
            ejbInv.transactionAttribute = this.postConstructInvInfo.txAttr;
            ejbInv.invocationInfo = this.postConstructInvInfo;
            initGotToPreInvokeTx = true;
            this.preInvokeTx(ejbInv);
            context.setInstanceKey(singletonInstanceKey);
            this.intercept(LifecycleCallbackDescriptor.CallbackType.POST_CONSTRUCT, context);
        }
        catch (Throwable th) {
            if (ejbInv != null) {
                ejbInv.exception = th;
            }
            this.singletonInitializationFailed = true;
            CreateException creEx = new CreateException("Initialization failed for Singleton " + this.ejbDescriptor.getName());
            creEx.initCause(th);
            throw creEx;
        }
        finally {
            this.initializationInProgress = false;
            if (ejbInv != null) {
                try {
                    this.invocationManager.postInvoke((ComponentInvocation)ejbInv);
                    if (initGotToPreInvokeTx) {
                        this.postInvokeTx(ejbInv);
                    }
                }
                catch (Exception pie) {
                    if (ejbInv.exception != null) {
                        _logger.log(Level.WARNING, "Exception during Singleton startup postInvoke ", pie);
                    }
                    ejbInv.exception = pie;
                    this.singletonInitializationFailed = true;
                    CreateException creEx = new CreateException("Initialization failed for Singleton " + this.ejbDescriptor.getName());
                    creEx.initCause((Throwable)pie);
                    throw creEx;
                }
            }
        }
        context.setState(EJBContextImpl.BeanState.POOLED);
        context.touch();
        return context;
    }

    @Override
    protected void doTimerInvocationInit(EjbInvocation inv, Object primaryKey) throws Exception {
        inv.isLocal = !this.isRemote;
    }

    @Override
    public boolean userTransactionMethodsAllowed(ComponentInvocation inv) {
        boolean utMethodsAllowed = false;
        if (this.isBeanManagedTran && inv instanceof EjbInvocation) {
            EjbInvocation ejbInv = (EjbInvocation)inv;
            AbstractSessionContextImpl sc = (AbstractSessionContextImpl)ejbInv.context;
            utMethodsAllowed = sc.getInstanceKey() != null;
        }
        return utMethodsAllowed;
    }

    @Override
    protected void checkExists(EJBLocalRemoteObject ejbObj) {
    }

    @Override
    protected void afterBegin(EJBContextImpl context) {
    }

    @Override
    protected void beforeCompletion(EJBContextImpl context) {
    }

    @Override
    protected void afterCompletion(EJBContextImpl ctx, int status) {
    }

    @Override
    public boolean passivateEJB(ComponentContext context) {
        return false;
    }

    public void activateEJB(Object ctx, Object instanceKey) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doConcreteContainerShutdown(boolean appBeingUndeployed) {
        ClassLoader originalCCL = null;
        try {
            originalCCL = Utility.setContextClassLoader((ClassLoader)this.loader);
            if (this.singletonCtxFactory != null) {
                this.singletonCtxFactory.destroy(this.singletonCtx);
            }
            if (this.hasRemoteBusinessView) {
                for (RemoteBusinessIntfInfo next : this.remoteBusinessIntfInfo.values()) {
                    next.referenceFactory.destroyReference(this.theRemoteBusinessObjectImpl.getStub(next.generatedRemoteIntf.getName()), this.theRemoteBusinessObjectImpl.getEJBObject(next.generatedRemoteIntf.getName()));
                }
            }
        }
        catch (Throwable t) {
            _logger.log(Level.FINE, "Exception during Singleton shutdown", t);
        }
        finally {
            this.singletonCtxFactory = null;
            Utility.setContextClassLoader((ClassLoader)originalCCL);
        }
    }

    public long getMethodReadyCount() {
        return 0L;
    }

    public int getMaxPoolSize() {
        return 1;
    }

    public int getSteadyPoolSize() {
        return 1;
    }

    protected class SingletonContextFactory
    implements ObjectFactory {
        protected SingletonContextFactory() {
        }

        @Override
        public Object create(Object param) {
            try {
                return AbstractSingletonContainer.this.createSingletonEJB();
            }
            catch (CreateException ex) {
                throw new EJBException((Exception)((Object)ex));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void destroy(Object obj) {
            SingletonContextImpl singletonCtx = (SingletonContextImpl)obj;
            if (singletonCtx != null) {
                Object sb = singletonCtx.getEJB();
                singletonCtx.setState(EJBContextImpl.BeanState.DESTROYED);
                EjbInvocation ejbInv = null;
                try {
                    ejbInv = AbstractSingletonContainer.this.createEjbInvocation(sb, singletonCtx);
                    AbstractSingletonContainer.this.invocationManager.preInvoke((ComponentInvocation)ejbInv);
                    singletonCtx.setInEjbRemove(true);
                    ejbInv.transactionAttribute = AbstractSingletonContainer.this.preDestroyInvInfo.txAttr;
                    ejbInv.invocationInfo = AbstractSingletonContainer.this.preDestroyInvInfo;
                    AbstractSingletonContainer.this.preInvokeTx(ejbInv);
                    AbstractSingletonContainer.this.intercept(LifecycleCallbackDescriptor.CallbackType.PRE_DESTROY, singletonCtx);
                }
                catch (Throwable t) {
                    if (ejbInv != null) {
                        ejbInv.exception = t;
                    }
                    BaseContainer._logger.log(Level.FINE, "ejbRemove exception", t);
                }
                finally {
                    singletonCtx.setInEjbRemove(false);
                    if (ejbInv != null) {
                        AbstractSingletonContainer.this.invocationManager.postInvoke((ComponentInvocation)ejbInv);
                        try {
                            AbstractSingletonContainer.this.postInvokeTx(ejbInv);
                        }
                        catch (Exception pie) {
                            BaseContainer._logger.log(Level.FINE, "singleton postInvokeTx exception", pie);
                        }
                    }
                }
                AbstractSingletonContainer.this.cleanupInstance(singletonCtx);
                singletonCtx.deleteAllReferences();
            }
        }
    }
}

