/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.dynamic.codegen.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import org.glassfish.pfl.basic.contain.Pair;
import org.glassfish.pfl.basic.func.NullaryFunction;
import org.glassfish.pfl.dynamic.codegen.impl.ASMByteCodeVisitor;
import org.glassfish.pfl.dynamic.codegen.impl.ASMSetupVisitor;
import org.glassfish.pfl.dynamic.codegen.impl.Attribute;
import org.glassfish.pfl.dynamic.codegen.impl.BlockStatement;
import org.glassfish.pfl.dynamic.codegen.impl.ClassGeneratorImpl;
import org.glassfish.pfl.dynamic.codegen.impl.CodegenPrinter;
import org.glassfish.pfl.dynamic.codegen.impl.CurrentClassLoader;
import org.glassfish.pfl.dynamic.codegen.impl.EmitterFactory;
import org.glassfish.pfl.dynamic.codegen.impl.MyLabel;
import org.glassfish.pfl.dynamic.codegen.impl.Node;
import org.glassfish.pfl.dynamic.codegen.impl.SourceStatementVisitor;
import org.glassfish.pfl.dynamic.codegen.impl.Statement;
import org.glassfish.pfl.dynamic.codegen.impl.TreeWalkerContext;
import org.glassfish.pfl.dynamic.codegen.impl.Util;
import org.glassfish.pfl.dynamic.codegen.spi.ImportList;
import org.glassfish.pfl.dynamic.codegen.spi.Type;
import org.glassfish.pfl.dynamic.codegen.spi.Variable;
import org.glassfish.pfl.dynamic.codegen.spi.Wrapper;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.util.CheckClassAdapter;

public class ASMUtil {
    private static NullaryFunction<MyLabel> makeLabel = new NullaryFunction<MyLabel>(){

        public MyLabel evaluate() {
            return new MyLabel();
        }
    };
    static Attribute<MyLabel> returnLabel = new Attribute<MyLabel>(MyLabel.class, "returnLabel", makeLabel);
    static Attribute<MyLabel> statementStartLabel = new Attribute<MyLabel>(MyLabel.class, "statementStartLabel", makeLabel);
    static Attribute<MyLabel> statementEndLabel = new Attribute<MyLabel>(MyLabel.class, "statementEndLabel", makeLabel);
    static Attribute<MyLabel> throwEndLabel = new Attribute<MyLabel>(MyLabel.class, "throwEndLabel", makeLabel);
    static Attribute<Node> next = new Attribute<Node>(Node.class, "next", (Node)null);
    static Attribute<Variable> returnVariable = new Attribute<Variable>(Variable.class, "returnVariable", (Variable)null);
    static Attribute<Integer> stackFrameSlot = new Attribute<Integer>(Integer.class, "stackFrameSlot", 0);
    static Attribute<EmitterFactory.Emitter> getEmitter = new Attribute<EmitterFactory.Emitter>(EmitterFactory.Emitter.class, "getEmitter", (EmitterFactory.Emitter)null);
    static Attribute<EmitterFactory.Emitter> setEmitter = new Attribute<EmitterFactory.Emitter>(EmitterFactory.Emitter.class, "setEmitter", (EmitterFactory.Emitter)null);
    static Attribute<EmitterFactory.Emitter> emitter = new Attribute<EmitterFactory.Emitter>(EmitterFactory.Emitter.class, "emitter", (EmitterFactory.Emitter)null);
    static Attribute<RequiredEmitterType> requiredEmitterType = new Attribute<RequiredEmitterType>(RequiredEmitterType.class, "requiredEmitterType", RequiredEmitterType.GETTER);
    static Attribute<Statement> lastStatement = new Attribute<Statement>(Statement.class, "lastStatement", (Statement)null);
    static Attribute<Variable> uncaughtException = new Attribute<Variable>(Variable.class, "uncaughtException", (Variable)null);
    static Attribute<Variable> returnAddress = new Attribute<Variable>(Variable.class, "returnAddress", (Variable)null);
    static Attribute<BlockStatement> lastBlock = new Attribute<BlockStatement>(BlockStatement.class, "lastBlock", (BlockStatement)null);
    static Attribute<MyLabel> uncaughtExceptionHandler = new Attribute<MyLabel>(MyLabel.class, "uncaughtExceptionHandler", makeLabel);
    static Attribute<Integer> ctr = new Attribute<Integer>(Integer.class, "ctr", 0);
    private static NullaryFunction<LineNumberTable> tableMaker = new NullaryFunction<LineNumberTable>(){

        public LineNumberTable evaluate() {
            return new LineNumberTable();
        }
    };
    static Attribute<LineNumberTable> lineNumberTable = new Attribute<LineNumberTable>(LineNumberTable.class, "lineNumberTable", tableMaker);
    private static NullaryFunction<VariablesInMethod> vmMaker = new NullaryFunction<VariablesInMethod>(){

        public VariablesInMethod evaluate() {
            return new VariablesInMethod();
        }
    };
    static Attribute<VariablesInMethod> variablesInMethod = new Attribute<VariablesInMethod>(VariablesInMethod.class, "variablesInMethod", vmMaker);

    public static String bcName(Type type) {
        return type.name().replace('.', '/');
    }

    private static void displayNode(PrintStream ps, String msg, Node node) {
        ps.println();
        ps.println("=======================================================");
        ps.println(msg);
        Util.display(node, ps);
        ps.println();
        Util.checkTree(node, ps);
        ps.println();
        ps.println("=======================================================");
    }

    public static void generateSourceCode(PrintStream ps, ClassGeneratorImpl cg, ImportList imports, Properties options) throws IOException {
        TreeWalkerContext context = new TreeWalkerContext();
        SourceStatementVisitor visitor = new SourceStatementVisitor(context, imports, new CodegenPrinter(ps));
        cg.accept(visitor);
    }

    public static File getFile(String genDir, String className, String suffix) {
        Pair<String, String> names = Wrapper.splitClassName(className);
        String pkgName = ((String)names.first()).replace('.', File.separatorChar);
        File sdir = new File(genDir, pkgName);
        sdir.mkdirs();
        String sfname = (String)names.second() + suffix;
        File sfile = new File(sdir, sfname);
        return sfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateSourceCode(String sourceGenDir, ClassGeneratorImpl cg, ImportList imports, Properties options) throws IOException {
        try (PrintStream ps = null;){
            File sfile = ASMUtil.getFile(sourceGenDir, cg.name(), ".java");
            ps = new PrintStream(sfile);
            ASMUtil.generateSourceCode(ps, cg, imports, options);
        }
    }

    private static byte[] fixStackSize(byte[] code) {
        ClassReader cr = new ClassReader(code);
        ClassWriter cw = new ClassWriter(1);
        FixStackSizeClassVisitor visitor = new FixStackSizeClassVisitor((ClassVisitor)cw);
        cr.accept((ClassVisitor)visitor, 0);
        return cw.toByteArray();
    }

    public static byte[] generate(ClassLoader cl, ClassGeneratorImpl cg, ImportList imports, Properties options, PrintStream debugOutput) {
        CurrentClassLoader.set(cl);
        boolean dumpConstantPool = false;
        boolean dumpAfterSetupVisitor = false;
        boolean traceByteCodeGeneration = false;
        boolean useAsmVerifier = false;
        String classGenDir = null;
        String sourceGenDir = null;
        if (options != null) {
            dumpConstantPool = Boolean.parseBoolean(options.getProperty("org.glassfish.dynamic.codegen.debug.dumpConstantPool"));
            dumpAfterSetupVisitor = Boolean.parseBoolean(options.getProperty("org.glassfish.dynamic.codegen.debug.dumpAfterSetupVisitor"));
            traceByteCodeGeneration = Boolean.parseBoolean(options.getProperty("org.glassfish.dynamic.codegen.debug.traceByteCodeGeneration"));
            useAsmVerifier = Boolean.parseBoolean(options.getProperty("org.glassfish.dynamic.codegen.debug.useAsmVerifier"));
            classGenDir = options.getProperty("org.glassfish.dynamic.codegen.classGenerationDirectory");
            sourceGenDir = options.getProperty("org.glassfish.dynamic.codegen.sourceGenerationDirectory");
        }
        if (sourceGenDir != null) {
            try {
                ASMUtil.generateSourceCode(sourceGenDir, cg, imports, options);
            }
            catch (IOException exc) {
                throw new IllegalArgumentException("Could not generate source code for class " + cg.name(), exc);
            }
        }
        ClassWriter cw = new ClassWriter(1);
        TreeWalkerContext twc = new TreeWalkerContext();
        ASMSetupVisitor v1 = new ASMSetupVisitor(twc);
        cg.accept(v1);
        if (dumpAfterSetupVisitor) {
            ASMUtil.displayNode(debugOutput, "Contents of AST after SetupVisitor", cg);
        }
        twc = new TreeWalkerContext();
        ASMByteCodeVisitor v2 = new ASMByteCodeVisitor(twc, cw, traceByteCodeGeneration, debugOutput);
        cg.accept(v2);
        byte[] result = ASMUtil.fixStackSize(cw.toByteArray());
        if (dumpConstantPool) {
            // empty if block
        }
        if (classGenDir != null) {
            File cfile = ASMUtil.getFile(classGenDir, cg.name(), ".class");
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(cfile);
                fos.write(result, 0, result.length);
            }
            catch (IOException exc) {
                throw new IllegalArgumentException("Could not dump generated bytecode to file " + cfile);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (useAsmVerifier) {
            debugOutput.println("*** Using ASM verifier ***");
            ASMUtil.verify(debugOutput, result);
        }
        return result;
    }

    private static void verify(PrintStream ps, byte[] classData) {
        ClassReader cr = new ClassReader(classData);
        PrintWriter pw = new PrintWriter(ps);
        CheckClassAdapter.verify((ClassReader)cr, (boolean)true, (PrintWriter)pw);
    }

    private static class FixStackSizeClassVisitor
    extends ClassVisitor {
        public FixStackSizeClassVisitor(ClassVisitor cv) {
            super(458752, cv);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
            return mv == null ? null : new FixStackSizeMethodVisitor(mv);
        }
    }

    public static enum RequiredEmitterType {
        GETTER,
        SETTER,
        NONE;

    }

    public static class LineNumberTable
    extends HashMap<MyLabel, Integer> {
    }

    public static class VariablesInMethod
    extends HashSet<Variable> {
    }

    private static class FixStackSizeMethodVisitor
    extends MethodVisitor {
        public FixStackSizeMethodVisitor(MethodVisitor mv) {
            super(458752, mv);
        }

        public void visitMaxs(int maxStack, int maxLocals) {
            this.mv.visitMaxs(0, 0);
        }
    }
}

