/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.composite;

enum Primitive {
    DOUBLE("D", 175, 24),
    FLOAT("F", 174, 23),
    LONG("J", 173, 22),
    SHORT("S", 172, 21),
    INT("I", 172, 21),
    BYTE("B", 172, 21),
    BOOLEAN("Z", 172, 21);

    private final int returnOpcode;
    private final int setOpcode;
    private final String internalType;

    private Primitive(String type, int returnOpcode, int setOpcode) {
        this.internalType = type;
        this.returnOpcode = returnOpcode;
        this.setOpcode = setOpcode;
    }

    public int getReturnOpcode() {
        return this.returnOpcode;
    }

    public int getSetOpCode() {
        return this.setOpcode;
    }

    public String getInternalType() {
        return this.internalType;
    }

    static Primitive getPrimitive(String type) {
        if ("S".equals(type) || "short".equals(type)) {
            return SHORT;
        }
        if ("J".equals(type) || "long".equals(type)) {
            return LONG;
        }
        if ("I".equals(type) || "int".equals(type)) {
            return INT;
        }
        if ("F".equals(type) || "float".equals(type)) {
            return FLOAT;
        }
        if ("D".equals(type) || "double".equals(type)) {
            return DOUBLE;
        }
        if ("B".equals(type) || "byte".equals(type)) {
            return BYTE;
        }
        if ("Z".equals(type) || "boolean".equals(type)) {
            return BOOLEAN;
        }
        throw new RuntimeException("Unknown primitive type: " + type);
    }
}

