/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

abstract class BaseContextMap<V>
extends AbstractMap<String, V> {
    private Set<Map.Entry<String, V>> entrySet;
    private Set<String> keySet;
    private Collection<V> values;

    BaseContextMap() {
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public Set<String> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new ValueCollection();
        }
        return this.values;
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    protected boolean removeKey(Object key) {
        return this.remove(key) != null;
    }

    protected boolean removeValue(Object value) {
        boolean valueRemoved = false;
        if (value == null) {
            return false;
        }
        if (this.containsValue(value)) {
            for (Map.Entry<String, V> e : this.entrySet()) {
                if (!value.equals(e.getValue())) continue;
                valueRemoved = this.remove(e.getKey()) != null;
            }
        }
        return valueRemoved;
    }

    protected abstract Iterator<Map.Entry<String, V>> getEntryIterator();

    protected abstract Iterator<String> getKeyIterator();

    protected abstract Iterator<V> getValueIterator();

    class EntrySet
    extends BaseSet<Map.Entry<String, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<String, V>> iterator() {
            return BaseContextMap.this.getEntryIterator();
        }

        @Override
        public boolean remove(Object o) {
            return o instanceof Map.Entry && BaseContextMap.this.removeKey(((Map.Entry)o).getKey());
        }
    }

    class KeySet
    extends BaseSet<String> {
        KeySet() {
        }

        @Override
        public Iterator<String> iterator() {
            return BaseContextMap.this.getKeyIterator();
        }

        @Override
        public boolean contains(Object o) {
            return BaseContextMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return o instanceof String && BaseContextMap.this.removeKey(o);
        }
    }

    class ValueCollection
    extends AbstractCollection<V> {
        ValueCollection() {
        }

        @Override
        public int size() {
            int size = 0;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                i.next();
                ++size;
            }
            return size;
        }

        @Override
        public Iterator<V> iterator() {
            return BaseContextMap.this.getValueIterator();
        }

        @Override
        public boolean remove(Object o) {
            return BaseContextMap.this.removeValue(o);
        }
    }

    static class Entry<V>
    implements Map.Entry<String, V> {
        private final String key;
        private final V value;

        Entry(String key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry input = (Map.Entry)obj;
            Object key = input.getKey();
            Object value = input.getValue();
            return Objects.equals(key, this.key) && Objects.equals(value, this.value);
        }
    }

    class ValueIterator
    extends BaseIterator<V> {
        ValueIterator(Enumeration e) {
            super(e);
        }

        @Override
        public void remove() {
            if (this.currentKey == null || this.removeCalled) {
                throw new IllegalStateException();
            }
            this.removeCalled = true;
            BaseContextMap.this.removeValue(BaseContextMap.this.get(this.currentKey));
        }

        @Override
        public V next() {
            this.nextKey();
            return BaseContextMap.this.get(this.currentKey);
        }
    }

    class KeyIterator
    extends BaseIterator<String> {
        KeyIterator(Enumeration e) {
            super(e);
        }

        @Override
        public void remove() {
            if (this.currentKey == null || this.removeCalled) {
                throw new IllegalStateException();
            }
            this.removeCalled = true;
            BaseContextMap.this.removeKey(this.currentKey);
        }

        @Override
        public String next() {
            return this.nextKey();
        }
    }

    class EntryIterator
    extends BaseIterator<Map.Entry<String, V>> {
        EntryIterator(Enumeration e) {
            super(e);
        }

        @Override
        public void remove() {
            if (this.currentKey == null || this.removeCalled) {
                throw new IllegalStateException();
            }
            this.removeCalled = true;
            BaseContextMap.this.removeKey(this.currentKey);
        }

        @Override
        public Map.Entry<String, V> next() {
            this.nextKey();
            return new Entry(this.currentKey, BaseContextMap.this.get(this.currentKey));
        }
    }

    static abstract class BaseIterator<E>
    implements Iterator<E> {
        protected Enumeration e;
        protected String currentKey;
        protected boolean removeCalled = false;

        BaseIterator(Enumeration e) {
            this.e = e;
        }

        @Override
        public boolean hasNext() {
            return this.e.hasMoreElements();
        }

        public String nextKey() {
            this.removeCalled = false;
            this.currentKey = (String)this.e.nextElement();
            return this.currentKey;
        }
    }

    static abstract class BaseSet<E>
    extends AbstractSet<E> {
        BaseSet() {
        }

        @Override
        public int size() {
            int size = 0;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                i.next();
                ++size;
            }
            return size;
        }
    }
}

