/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.epicyro.config.helper;

import jakarta.security.auth.message.MessagePolicy;
import java.util.ArrayList;
import javax.security.auth.callback.CallbackHandler;
import org.glassfish.epicyro.config.helper.ServerCallbackHandler;

public class AuthMessagePolicy {
    private static final String SENDER = "sender";
    private static final String CONTENT = "content";
    private static final String BEFORE_CONTENT = "before-content";
    private static final String HANDLER_CLASS_PROPERTY = "security.jaspic.config.ConfigHelper.CallbackHandler";
    private static final String DEFAULT_HANDLER_CLASS = ServerCallbackHandler.class.getName();
    private static final MessagePolicy MANDATORY_POLICY = AuthMessagePolicy.getMessagePolicy("sender", null, true);
    private static final MessagePolicy OPTIONAL_POLICY = AuthMessagePolicy.getMessagePolicy("sender", null, false);
    private static String handlerClassName;

    private AuthMessagePolicy() {
    }

    public static MessagePolicy getMessagePolicy(String authSource, String authRecipient) {
        boolean sourceSender = SENDER.equals(authSource);
        boolean sourceContent = CONTENT.equals(authSource);
        boolean recipientAuth = authRecipient != null;
        boolean mandatory = sourceSender || sourceContent || recipientAuth;
        return AuthMessagePolicy.getMessagePolicy(authSource, authRecipient, mandatory);
    }

    public static MessagePolicy getMessagePolicy(String authSource, String authRecipient, boolean mandatory) {
        boolean sourceSender = SENDER.equals(authSource);
        boolean sourceContent = CONTENT.equals(authSource);
        boolean recipientAuth = authRecipient != null;
        boolean beforeContent = BEFORE_CONTENT.equals(authRecipient);
        ArrayList<MessagePolicy.TargetPolicy> targetPolicies = new ArrayList<MessagePolicy.TargetPolicy>();
        if (recipientAuth && beforeContent) {
            targetPolicies.add(new MessagePolicy.TargetPolicy(null, () -> "#authenticateRecipient"));
            if (sourceSender) {
                targetPolicies.add(new MessagePolicy.TargetPolicy(null, () -> "#authenticateSender"));
            } else if (sourceContent) {
                targetPolicies.add(new MessagePolicy.TargetPolicy(null, () -> "#authenticateContent"));
            }
        } else {
            if (sourceSender) {
                targetPolicies.add(new MessagePolicy.TargetPolicy(null, () -> "#authenticateSender"));
            } else if (sourceContent) {
                targetPolicies.add(new MessagePolicy.TargetPolicy(null, () -> "#authenticateContent"));
            }
            if (recipientAuth) {
                targetPolicies.add(new MessagePolicy.TargetPolicy(null, () -> "#authenticateRecipient"));
            }
        }
        return new MessagePolicy(targetPolicies.toArray(new MessagePolicy.TargetPolicy[targetPolicies.size()]), mandatory);
    }

    public static MessagePolicy[] getHttpServletPolicies(String authContextID) {
        if (Boolean.valueOf(authContextID).booleanValue()) {
            return new MessagePolicy[]{MANDATORY_POLICY, null};
        }
        return new MessagePolicy[]{OPTIONAL_POLICY, null};
    }

    public static CallbackHandler getDefaultCallbackHandler() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (handlerClassName == null) {
            handlerClassName = System.getProperty(HANDLER_CLASS_PROPERTY, DEFAULT_HANDLER_CLASS);
        }
        try {
            return (CallbackHandler)Class.forName(handlerClassName, true, loader).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

