/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.connector;

import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.node.AbstractBundleNode;
import com.sun.enterprise.deployment.node.DescriptorFactory;
import com.sun.enterprise.deployment.node.SaxParserHandler;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.XMLNode;
import com.sun.enterprise.deployment.node.connector.LicenseNode;
import com.sun.enterprise.deployment.node.connector.OutBoundRANode;
import com.sun.enterprise.deployment.node.connector.RANode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jvnet.hk2.annotations.Service;
import org.w3c.dom.Node;

@Service
public class ConnectorNode
extends AbstractBundleNode<ConnectorDescriptor> {
    private ConnectorDescriptor descriptor;
    private static final String VERSION_10 = "1.0";
    private static final String VERSION_17 = "1.7";
    private static final String VERSION_20 = "2.0";
    private String specVersion;
    private static final String PUBLIC_DTD_ID_10 = "-//Sun Microsystems, Inc.//DTD Connector 1.0//EN";
    private static final String SYSTEM_ID_10 = "http://java.sun.com/dtd/connector_1_0.dtd";
    private static final String PUBLIC_DTD_ID = "-//Sun Microsystems, Inc.//DTD Connector 1.6//EN";
    private static final String SYSTEM_ID = "http://java.sun.com/dtd/connector_1_6.dtd";
    private static final String SCHEMA_ID = "connector_2_0.xsd";
    public static final String SPEC_VERSION = "2.0";
    private static final List<String> systemIDs = List.of("connector_2_0.xsd");
    private static final XMLElement TAG = new XMLElement("connector");

    public ConnectorNode() {
        this.registerElementHandler(new XMLElement("license"), LicenseNode.class, "setLicenseDescriptor");
        SaxParserHandler.registerBundleNode(this, "connector");
    }

    @Override
    public String registerBundle(Map<String, String> publicIDToDTD) {
        publicIDToDTD.put(PUBLIC_DTD_ID, SYSTEM_ID);
        publicIDToDTD.put(PUBLIC_DTD_ID_10, SYSTEM_ID_10);
        return TAG.getQName();
    }

    @Override
    public Map<String, Class<?>> registerRuntimeBundle(Map<String, String> publicIDToDTD, Map<String, List<Class<?>>> versionUpgrades) {
        HashMap result = new HashMap();
        result.put(com.sun.enterprise.deployment.node.runtime.connector.ConnectorNode.registerBundle(publicIDToDTD), com.sun.enterprise.deployment.node.runtime.connector.ConnectorNode.class);
        return result;
    }

    @Override
    public ConnectorDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = (ConnectorDescriptor)DescriptorFactory.getDescriptor(this.getXMLPath());
        }
        return this.descriptor;
    }

    @Override
    public final void addDescriptor(Object newDescriptor) {
    }

    @Override
    protected XMLElement getXMLRootTag() {
        return TAG;
    }

    @Override
    public String getDocType() {
        return null;
    }

    @Override
    public String getSystemID() {
        return SCHEMA_ID;
    }

    @Override
    public List<String> getSystemIDs() {
        return systemIDs;
    }

    @Override
    public String getSpecVersion() {
        return "2.0";
    }

    @Override
    protected String getSchemaURL() {
        return "https://jakarta.ee/xml/ns/jakartaee/" + this.getSystemID();
    }

    @Override
    protected Map<String, String> getDispatchTable() {
        Map<String, String> table = super.getDispatchTable();
        table.put("vendor-name", "setVendorName");
        table.put("eis-type", "setEisType");
        table.put("resourceadapter-version", "setResourceAdapterVersion");
        table.put("required-work-context", "addRequiredWorkContext");
        return table;
    }

    @Override
    protected boolean setAttributeValue(XMLElement elementName, XMLElement attributeName, String value) {
        if (this.getDescriptor() == null) {
            throw new RuntimeException("Trying to set values on a null descriptor");
        }
        if (attributeName.getQName().equals("version")) {
            this.descriptor.setSpecVersion(value);
            this.specVersion = value;
            return true;
        }
        return attributeName.getQName().equals("id");
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        if (this.getDescriptor() == null) {
            throw new RuntimeException("Trying to set values on a null descriptor");
        }
        if ("spec-version".equals(element.getQName())) {
            this.descriptor.setSpecVersion(value);
            this.specVersion = value;
        } else if ("version".equals(element.getQName())) {
            this.descriptor.setResourceAdapterVersion(value);
        } else if ("module-name".equals(element.getQName())) {
            ConnectorDescriptor bundleDesc = this.getDescriptor();
            bundleDesc.getModuleDescriptor().setModuleName(value);
        } else {
            super.setElementValue(element, value);
        }
    }

    @Override
    public boolean handlesElement(XMLElement element) {
        if ("resourceadapter".equals(element.getQName())) {
            return false;
        }
        return super.handlesElement(element);
    }

    @Override
    public XMLNode<?> getHandlerFor(XMLElement element) {
        if ("resourceadapter".equals(element.getQName())) {
            if (VERSION_10.equals(this.specVersion)) {
                OutBoundRANode outboundRANode = new OutBoundRANode(element);
                outboundRANode.setParentNode(this);
                outboundRANode.createConDefDescriptorFor10();
                return outboundRANode;
            }
            RANode raNode = new RANode(element);
            raNode.setParentNode(this);
            return raNode;
        }
        return super.getHandlerFor(element);
    }

    @Override
    public Node writeDescriptor(Node parent, ConnectorDescriptor conDesc) {
        conDesc.setSpecVersion(VERSION_17);
        Node connectorNode = super.writeDescriptor(parent, conDesc);
        ConnectorNode.appendTextChild(connectorNode, "vendor-name", conDesc.getVendorName());
        ConnectorNode.appendTextChild(connectorNode, "eis-type", conDesc.getEisType());
        ConnectorNode.appendTextChild(connectorNode, "resourceadapter-version", conDesc.getResourceAdapterVersion());
        for (String className : conDesc.getRequiredWorkContexts()) {
            ConnectorNode.appendTextChild(connectorNode, "required-work-context", className);
        }
        LicenseNode.writeLicenseDescriptor(connectorNode, conDesc.getLicenseDescriptor());
        RANode.writeConnectorDescriptor(connectorNode, conDesc);
        return connectorNode;
    }
}

