/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.enterprise.loader.ASURLClassLoader;
import com.sun.logging.LogDomains;
import java.io.File;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConnectorClassLoader
extends ASURLClassLoader {
    private static final Logger _logger = LogDomains.getLogger(ConnectorClassLoader.class, (String)"jakarta.enterprise.resource.resourceadapter");
    private static volatile ConnectorClassLoader classLoader;
    private final List<ASURLClassLoader> classLoaderChain = new LinkedList<ASURLClassLoader>();
    private ClassLoader parent;
    private final Map<String, ASURLClassLoader> rarModuleClassLoaders = new HashMap<String, ASURLClassLoader>();

    public static synchronized ConnectorClassLoader getInstance() {
        if (classLoader == null) {
            classLoader = new ConnectorClassLoader();
        }
        return classLoader;
    }

    private ConnectorClassLoader() {
    }

    private ConnectorClassLoader(ClassLoader parent) {
        super(parent);
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConnectorClassLoader getInstance(ClassLoader parent) {
        if (classLoader != null) return classLoader;
        Class<ConnectorClassLoader> clazz = ConnectorClassLoader.class;
        synchronized (ConnectorClassLoader.class) {
            if (classLoader != null) return classLoader;
            classLoader = new ConnectorClassLoader(parent);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return classLoader;
        }
    }

    public void addResourceAdapter(String rarName, String moduleDir) {
        try {
            File file = new File(moduleDir);
            ASURLClassLoader cl = new ASURLClassLoader(this.parent);
            cl.appendURL(file.toURI().toURL());
            this.appendJars(file, cl);
            this.classLoaderChain.add(cl);
            this.rarModuleClassLoaders.put(rarName, cl);
        }
        catch (MalformedURLException ex) {
            _logger.log(Level.SEVERE, "enterprise_util.connector_malformed_url", ex);
        }
    }

    private void appendJars(File moduleDir, ASURLClassLoader cl) throws MalformedURLException {
        File[] files;
        if (moduleDir.isDirectory() && (files = moduleDir.listFiles()) != null) {
            for (File file : files) {
                if (file.getName().toUpperCase(Locale.getDefault()).endsWith(".JAR")) {
                    cl.appendURL(file.toURI().toURL());
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.appendJars(file, cl);
            }
        }
    }

    public void removeResourceAdapter(String moduleName) {
        ASURLClassLoader classLoaderToRemove = this.rarModuleClassLoaders.get(moduleName);
        if (classLoaderToRemove != null) {
            this.classLoaderChain.remove(classLoaderToRemove);
            this.rarModuleClassLoaders.remove(moduleName);
            _logger.log(Level.WARNING, "enterprise_util.remove_connector", moduleName);
        }
    }

    public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.parent != null) {
            try {
                Class<?> clz = this.parent.loadClass(name);
                if (clz != null) {
                    if (resolve) {
                        this.resolveClass(clz);
                    }
                    return clz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
        } else {
            return super.loadClass(name, resolve);
        }
        for (ASURLClassLoader ccl : this.classLoaderChain) {
            try {
                Class clz = ccl.loadClass(name);
                if (clz == null) continue;
                if (resolve) {
                    this.resolveClass(clz);
                }
                return clz;
            }
            catch (ClassNotFoundException cnfe) {
            }
        }
        throw new ClassNotFoundException(name);
    }

    public String getClasspath() {
        StringBuilder strBuf = new StringBuilder();
        boolean first = true;
        for (ASURLClassLoader loader : this.classLoaderChain) {
            String eclClasspath = loader.getClasspath();
            if (eclClasspath == null) continue;
            if (!first) {
                strBuf.append(File.pathSeparator);
                first = false;
            }
            strBuf.append(eclClasspath);
        }
        return strBuf.toString();
    }
}

