/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.util;

import java.lang.reflect.Array;
import org.glassfish.admin.amx.util.ClassUtil;
import org.glassfish.admin.amx.util.TypeCast;

public final class ArrayUtil {
    private ArrayUtil() {
    }

    public static boolean arraysEqual(Object array1, Object array2) {
        boolean equal;
        boolean bl = equal = array1 == array2;
        if (equal) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.getClass() == array2.getClass() && ClassUtil.objectIsArray(array1) && Array.getLength(array1) == Array.getLength(array2)) {
            equal = true;
            int length = Array.getLength(array1);
            for (int i = 0; i < length; ++i) {
                Object a2;
                Object a1 = Array.get(array1, i);
                if (a1 != (a2 = Array.get(array2, i))) {
                    if (a1 == null || a2 == null) {
                        equal = false;
                    } else if (ClassUtil.objectIsArray(a1) && !ArrayUtil.arraysEqual(a1, a2)) {
                        equal = false;
                    }
                }
                if (!equal) break;
            }
        }
        return equal;
    }

    public static boolean arrayContainsNulls(Object[] array) {
        boolean containsNulls = false;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != null) continue;
            containsNulls = true;
            break;
        }
        return containsNulls;
    }

    public static <T> T[] newArray(Class<T> theClass, int numItems) {
        return (Object[])Array.newInstance(theClass, numItems);
    }

    public static <T> T[] newArray(T[] items, int startIndex, int numItems) {
        Class theClass = TypeCast.asClass(items.getClass().getComponentType());
        T[] result = ArrayUtil.newArray(theClass, numItems);
        System.arraycopy(items, startIndex, result, 0, numItems);
        return result;
    }

    public static <T> T[] newArray(T[] items1, T[] items2) {
        Class class2;
        Class class1 = TypeCast.asClass(items1.getClass().getComponentType());
        if (!class1.isAssignableFrom(class2 = TypeCast.asClass(items2.getClass().getComponentType()))) {
            throw new IllegalArgumentException();
        }
        int length1 = Array.getLength(items1);
        int length2 = Array.getLength(items2);
        T[] result = ArrayUtil.newArray(class1, length1 + length2);
        System.arraycopy(items1, 0, result, 0, length1);
        System.arraycopy(items2, 0, result, length1, length2);
        return result;
    }

    public static <T> T[] newArray(T[] items, T item) {
        Class theClass = TypeCast.asClass(items.getClass().getComponentType());
        T[] result = ArrayUtil.newArray(theClass, items.length + 1);
        System.arraycopy(items, 0, result, 0, items.length);
        result[result.length - 1] = item;
        return result;
    }
}

