/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.security.store.AsadminTruststore;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.Console;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import javax.net.ssl.X509TrustManager;

public class AsadminTrustManager
implements X509TrustManager {
    private final Object _alias;
    private boolean _alreadyInvoked;
    private boolean interactive = true;
    private CertificateException _lastCertException;
    private RuntimeException _lastRuntimeException;
    private static final LocalStringsImpl strmgr = new LocalStringsImpl(AsadminTrustManager.class);

    public AsadminTrustManager(Object alias, Map env) {
        this._alias = alias;
        this._alreadyInvoked = false;
        this._lastCertException = null;
        this._lastRuntimeException = null;
    }

    public AsadminTrustManager() {
        this(null, null);
    }

    public void setInteractive(boolean mode) {
        this.interactive = mode;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificate, String authType) throws CertificateException {
        throw new UnsupportedOperationException("Not Implemented for Client Trust Management");
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (!this._alreadyInvoked) {
            this._alreadyInvoked = true;
            try {
                this.checkCertificate(chain);
            }
            catch (RuntimeException ex) {
                this._lastRuntimeException = ex;
                throw ex;
            }
            catch (CertificateException ex) {
                this._lastCertException = ex;
                throw ex;
            }
        } else {
            if (this._lastRuntimeException != null) {
                throw this._lastRuntimeException;
            }
            if (this._lastCertException != null) {
                throw this._lastCertException;
            }
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    private boolean isItOKToAddCertToTrustStore(X509Certificate c) throws IOException {
        Console cons = System.console();
        if (!this.interactive || cons == null) {
            return true;
        }
        cons.printf("%s%n", c.toString());
        String result = cons.readLine("%s", strmgr.get("certificateTrustPrompt"));
        return result != null && result.equalsIgnoreCase("y");
    }

    private String getAliasName() {
        Object aliasName = this._alias != null ? this._alias.toString() : "";
        DateFormat f = DateFormat.getDateTimeInstance(1, 1);
        aliasName = (String)aliasName + ":" + f.format(new Date());
        return aliasName;
    }

    protected void checkCertificate(X509Certificate[] chain) throws RuntimeException, CertificateException, IllegalArgumentException {
        block6: {
            if (chain == null || chain.length == 0) {
                throw new IllegalArgumentException(strmgr.get("emptyServerCertificate"));
            }
            for (int i = 0; i < chain.length; ++i) {
                chain[i].checkValidity();
            }
            try {
                AsadminTruststore truststore = AsadminTruststore.newInstance();
                if (truststore.certificateExists((Certificate)chain[0])) break block6;
                if (this.isItOKToAddCertToTrustStore(chain[0])) {
                    truststore.addCertificate(this.getAliasName(), (Certificate)chain[0]);
                    break block6;
                }
                throw new CertificateException(strmgr.get("serverCertificateNotTrusted"));
            }
            catch (CertificateException ex) {
                throw ex;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

