/*
 * Decompiled with CFR 0.152.
 */
package com.sun.data.provider.impl;

import com.sun.data.provider.DataListener;
import com.sun.data.provider.DataProviderException;
import com.sun.data.provider.FieldKey;
import com.sun.data.provider.RefreshableDataListener;
import com.sun.data.provider.RefreshableDataProvider;
import com.sun.data.provider.impl.AbstractDataProvider;
import com.sun.data.provider.impl.ObjectDataProvider;
import java.beans.Beans;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;

public class MethodResultDataProvider
implements RefreshableDataProvider,
Serializable {
    private Object dataClassInstance;
    private transient Method dataMethod;
    private Object[] dataMethodArgs;
    private ObjectDataProvider resultProvider = new ObjectDataProvider();

    public MethodResultDataProvider() {
    }

    public MethodResultDataProvider(Object dataClassInstance, Method dataMethod) {
        this();
        this.setDataClassInstance(dataClassInstance);
        this.setDataMethod(dataMethod);
    }

    public Object getDataClassInstance() {
        return this.dataClassInstance;
    }

    public void setDataClassInstance(Object instance) {
        this.dataClassInstance = instance;
        this.resultProvider.setObject(null);
        this.refreshFieldKeys();
    }

    public Method getDataMethod() {
        return this.dataMethod;
    }

    public void setDataMethod(Method method) {
        this.dataMethod = method;
        this.resultProvider.setObject(null);
        this.refreshFieldKeys();
    }

    public Object getResultObject() throws DataProviderException {
        this.testInvokeDataMethod();
        return this.resultProvider.getObject();
    }

    public void setIncludeFields(boolean includeFields) {
        this.resultProvider.setIncludeFields(includeFields);
    }

    public boolean isIncludeFields() {
        return this.resultProvider.isIncludeFields();
    }

    protected void refreshFieldKeys() {
        this.resultProvider.clearFieldKeys();
        if (this.dataMethod != null) {
            Class<?> clazz = this.dataMethod.getReturnType();
        }
    }

    public void setDataMethodArguments(Object[] methodArgs) {
        this.dataMethodArgs = methodArgs;
        this.resultProvider.setObject(null);
        this.refreshFieldKeys();
    }

    public Object[] getDataMethodArguments() {
        return this.dataMethodArgs;
    }

    public void invokeDataMethod() throws DataProviderException {
        this.invokeDataMethod(this.getDataMethodArguments());
    }

    public void invokeDataMethod(Object[] args) throws DataProviderException {
        this.dataMethodArgs = args;
        this.resultProvider.setObject(null);
        if (this.dataMethod == null || this.dataClassInstance == null) {
            return;
        }
        try {
            Object o = null;
            o = Beans.isDesignTime() ? AbstractDataProvider.getFakeData(this.dataMethod.getReturnType()) : this.dataMethod.invoke(this.dataClassInstance, args);
            this.resultProvider.setObject(o);
            this.fireRefreshed();
        }
        catch (Exception e) {
            throw new DataProviderException(e);
        }
    }

    protected void testInvokeDataMethod() throws DataProviderException {
        if (this.resultProvider.getObject() == null) {
            this.invokeDataMethod();
        }
    }

    public void refresh() throws DataProviderException {
        this.invokeDataMethod();
    }

    public void addRefreshableDataListener(RefreshableDataListener l) {
        this.resultProvider.addDataListener(l);
    }

    public void removeRefreshableDataListener(RefreshableDataListener l) {
        this.resultProvider.removeDataListener(l);
    }

    public RefreshableDataListener[] getRefreshableDataListeners() {
        DataListener[] dpListeners = this.resultProvider.getDataListeners();
        if (dpListeners == null) {
            return new RefreshableDataListener[0];
        }
        ArrayList<DataListener> rdlList = new ArrayList<DataListener>();
        for (int i = 0; i < dpListeners.length; ++i) {
            if (!(dpListeners[i] instanceof RefreshableDataListener)) continue;
            rdlList.add(dpListeners[i]);
        }
        return rdlList.toArray(new RefreshableDataListener[rdlList.size()]);
    }

    protected void fireRefreshed() {
        RefreshableDataListener[] rdls = this.getRefreshableDataListeners();
        for (int i = 0; i < rdls.length; ++i) {
            rdls[i].refreshed(this);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.dataMethod != null) {
            HashMap<String, Object> sig = new HashMap<String, Object>();
            sig.put("class", this.dataMethod.getDeclaringClass());
            sig.put("name", this.dataMethod.getName());
            sig.put("params", this.dataMethod.getParameterTypes());
            out.writeObject(sig);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object o = in.readObject();
        if (o instanceof HashMap) {
            HashMap sig = (HashMap)o;
            Class clazz = (Class)sig.get("class");
            String name = (String)sig.get("name");
            Class[] params = (Class[])sig.get("params");
            try {
                this.dataMethod = clazz.getMethod(name, params);
            }
            catch (NoSuchMethodException nsmx) {
                // empty catch block
            }
        }
    }

    public FieldKey[] getFieldKeys() throws DataProviderException {
        return this.resultProvider.getFieldKeys();
    }

    public FieldKey getFieldKey(String fieldId) throws DataProviderException {
        return this.resultProvider.getFieldKey(fieldId);
    }

    public Class getType(FieldKey fieldKey) throws DataProviderException {
        return this.resultProvider.getType(fieldKey);
    }

    public Object getValue(FieldKey fieldKey) throws DataProviderException {
        this.testInvokeDataMethod();
        return this.resultProvider.getValue(fieldKey);
    }

    public boolean isReadOnly(FieldKey fieldKey) throws DataProviderException {
        this.testInvokeDataMethod();
        return this.resultProvider.isReadOnly(fieldKey);
    }

    public void setValue(FieldKey fieldKey, Object value) throws DataProviderException {
        this.testInvokeDataMethod();
        this.resultProvider.setValue(fieldKey, value);
    }

    public void addDataListener(DataListener listener) {
        this.resultProvider.addDataListener(listener);
    }

    public void removeDataListener(DataListener listener) {
        this.resultProvider.removeDataListener(listener);
    }

    public DataListener[] getDataListeners() {
        return this.resultProvider.getDataListeners();
    }
}

