/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.filters;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.LogFacade;
import org.glassfish.web.util.IntrospectionUtils;

public abstract class FilterBase
implements Filter {
    protected static final ResourceBundle rb = LogFacade.getLogger().getResourceBundle();

    protected abstract Logger getLogger();

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        Enumeration<String> paramNames = filterConfig.getInitParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = paramNames.nextElement();
            if (IntrospectionUtils.setProperty((Object)this, (String)paramName, (String)filterConfig.getInitParameter(paramName))) continue;
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00287"), paramName, this.getClass().getName());
            if (this.isConfigProblemFatal()) {
                throw new ServletException(msg);
            }
            this.getLogger().log(Level.WARNING, msg);
        }
    }

    @Override
    public void destroy() {
    }

    protected boolean isConfigProblemFatal() {
        return false;
    }
}

