/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.classmodel.reflect.util;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;

public class LinkedQueue<E> {
    private AtomicReference<Node<E>> head = new AtomicReference<Node<Object>>(new Node<Object>(null, null));
    private AtomicReference<Node<E>> tail = this.head;

    public boolean put(E item) {
        Node<E> newNode = new Node<E>(item, null);
        while (true) {
            Node<E> curTail = this.tail.get();
            Node residue = curTail.next.get();
            if (curTail != this.tail.get()) continue;
            if (residue == null) {
                if (!curTail.next.compareAndSet(null, newNode)) continue;
                this.tail.compareAndSet(curTail, newNode);
                return true;
            }
            this.tail.compareAndSet(curTail, residue);
        }
    }

    public Iterator<E> elements() {
        return new Iterator<E>(){
            AtomicReference<Node<E>> current;
            {
                this.current = LinkedQueue.this.head;
            }

            @Override
            public boolean hasNext() {
                return this.current.get().next != null;
            }

            @Override
            public E next() {
                Object element = this.current.get().item;
                this.current = this.current.get().next;
                return element;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("elements cannot be removed from list");
            }
        };
    }

    private static class Node<E> {
        final E item;
        final AtomicReference<Node<E>> next;

        Node(E item, Node<E> next) {
            this.item = item;
            this.next = new AtomicReference<Node<E>>(next);
        }
    }
}

