/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.admin.util.TokenValue;
import com.sun.enterprise.admin.util.TokenValueSet;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;

public final class LineTokenReplacer {
    private final TokenValue[] tokenArray;

    public LineTokenReplacer(TokenValueSet tokens) {
        Object[] tmp = tokens.toArray();
        int length = tmp.length;
        this.tokenArray = new TokenValue[length];
        System.arraycopy(tmp, 0, this.tokenArray, 0, length);
    }

    public Reader getReader(final Reader in) {
        return new Reader(){
            BufferedReader reader;
            String line;
            final String eol;
            {
                this.reader = new BufferedReader(in);
                this.eol = System.getProperty("line.separator");
            }

            @Override
            public int read(char[] cbuf, int off, int len) throws IOException {
                int copySize;
                if (this.line == null || this.line.isEmpty()) {
                    this.line = this.reader.readLine();
                    if (this.line == null) {
                        return -1;
                    }
                    this.line = LineTokenReplacer.this.replaceLine(this.line) + this.eol;
                }
                if ((copySize = len - off) > this.line.length()) {
                    copySize = this.line.length();
                }
                this.line.getChars(0, copySize, cbuf, off);
                this.line = this.line.substring(copySize);
                return copySize;
            }

            @Override
            public void close() throws IOException {
                this.reader.close();
            }
        };
    }

    public void replace(File inputFile, File outputFile) throws IllegalStateException {
        try (BufferedReader reader = new BufferedReader(new FileReader(inputFile, StandardCharsets.UTF_8));
             FileOutputStream outputStream = new FileOutputStream(outputFile);
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8));){
            String lineContents;
            while ((lineContents = reader.readLine()) != null) {
                String modifiedLine = this.replaceLine(lineContents);
                writer.write(modifiedLine);
                writer.newLine();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void replace(String inputFileName, String outputFileName) {
        this.replace(new File(inputFileName), new File(outputFileName));
    }

    private String replaceLine(String lineWithTokens) {
        String tokenFreeString = lineWithTokens;
        for (TokenValue aPair : this.tokenArray) {
            tokenFreeString = tokenFreeString.replace(aPair.delimitedToken, aPair.value);
        }
        return tokenFreeString;
    }
}

