/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import jakarta.validation.Constraint;
import jakarta.validation.Valid;
import jakarta.validation.constraints.AssertFalse;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Future;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Past;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.eclipse.persistence.internal.cache.AdvancedProcessor;
import org.eclipse.persistence.internal.cache.ComputableTask;
import org.eclipse.persistence.jaxb.ReflectionUtils;
import org.eclipse.persistence.jaxb.ValidationXMLReader;
import org.eclipse.persistence.logging.AbstractSessionLog;

public final class BeanValidationHelper {
    private java.util.concurrent.Future<Map<Class<?>, Boolean>> future;
    private final AdvancedProcessor memoizer = new AdvancedProcessor();
    private final ConstraintsDetectorService<Class<?>, Boolean> cds = new ConstraintsDetectorService();
    private final Set<Class<? extends Annotation>> knownConstraints = new HashSet<Class<? extends Annotation>>();
    private Map<Class<?>, Boolean> constraintsOnClasses = null;

    public BeanValidationHelper() {
        this.knownConstraints.add(Valid.class);
        this.knownConstraints.add(Max.class);
        this.knownConstraints.add(Min.class);
        this.knownConstraints.add(DecimalMax.class);
        this.knownConstraints.add(DecimalMin.class);
        this.knownConstraints.add(Digits.class);
        this.knownConstraints.add(NotNull.class);
        this.knownConstraints.add(Pattern.class);
        this.knownConstraints.add(Size.class);
        this.knownConstraints.add(AssertTrue.class);
        this.knownConstraints.add(AssertFalse.class);
        this.knownConstraints.add(Future.class);
        this.knownConstraints.add(Past.class);
        this.knownConstraints.add(Max.List.class);
        this.knownConstraints.add(Min.List.class);
        this.knownConstraints.add(DecimalMax.List.class);
        this.knownConstraints.add(DecimalMin.List.class);
        this.knownConstraints.add(Digits.List.class);
        this.knownConstraints.add(NotNull.List.class);
        this.knownConstraints.add(Pattern.List.class);
        this.knownConstraints.add(Size.List.class);
        this.knownConstraints.add(AssertTrue.List.class);
        this.knownConstraints.add(AssertFalse.List.class);
        this.knownConstraints.add(Future.List.class);
        this.knownConstraints.add(Past.List.class);
        if (ValidationXMLReader.isValidationXmlPresent()) {
            this.parseValidationXmlAsync();
        } else {
            this.constraintsOnClasses = new HashMap();
        }
    }

    boolean isConstrained(Class<?> clazz) {
        return (Boolean)this.memoizer.compute(this.cds, clazz);
    }

    public Map<Class<?>, Boolean> getConstraintsMap() {
        if (this.constraintsOnClasses == null) {
            if (this.future == null) {
                this.constraintsOnClasses = this.parseValidationXml();
            } else {
                try {
                    this.constraintsOnClasses = this.future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    AbstractSessionLog.getLog().log(6, "moxy", "Error parsing validation.xml the async way", new Object[0], false);
                    AbstractSessionLog.getLog().logThrowable(6, "moxy", (Throwable)e);
                    this.constraintsOnClasses = this.parseValidationXml();
                }
            }
        }
        return this.constraintsOnClasses;
    }

    private void parseValidationXmlAsync() {
        Executor executor = null;
        try {
            executor = this.createExecutor();
            this.future = executor.executorService.submit(new ValidationXMLReader());
        }
        catch (Throwable e) {
            AbstractSessionLog.getLog().log(6, "moxy", "Error creating/submitting async validation.xml parsing task.", new Object[0], false);
            AbstractSessionLog.getLog().logThrowable(6, "moxy", e);
            this.future = null;
        }
        finally {
            if (executor != null && executor.shutdownNeeded) {
                executor.executorService.shutdown();
            }
        }
    }

    private Map<Class<?>, Boolean> parseValidationXml() {
        HashMap result;
        ValidationXMLReader reader = new ValidationXMLReader();
        try {
            result = reader.call();
        }
        catch (Exception e) {
            AbstractSessionLog.getLog().log(6, "moxy", "Error parsing validation.xml synchronously", new Object[0], false);
            AbstractSessionLog.getLog().logThrowable(6, "moxy", (Throwable)e);
            result = new HashMap();
        }
        return result;
    }

    private Executor createExecutor() {
        try {
            InitialContext jndiCtx = new InitialContext();
            return new Executor((ExecutorService)jndiCtx.lookup("java:comp/env/concurrent/ThreadPool"), false);
        }
        catch (NamingException namingException) {
            return new Executor(Executors.newFixedThreadPool(1), true);
        }
    }

    private static class Executor {
        ExecutorService executorService;
        boolean shutdownNeeded;

        Executor(ExecutorService executorService, boolean shutdownNeeded) {
            this.executorService = executorService;
            this.shutdownNeeded = shutdownNeeded;
        }
    }

    public class ConstraintsDetectorService<A, V>
    implements ComputableTask<A, V> {
        public V compute(A arg) throws InterruptedException {
            Boolean b = this.isConstrained0((Class)arg);
            return (V)b;
        }

        private Boolean isConstrained0(Class<?> clazz) {
            Boolean constrained = BeanValidationHelper.this.getConstraintsMap().get(clazz);
            if (constrained == null) {
                constrained = this.detectConstraints(clazz);
                BeanValidationHelper.this.constraintsOnClasses.put(clazz, constrained);
            }
            return constrained;
        }

        private Boolean detectConstraints(Class<?> clazz) {
            if (this.detectAncestorConstraints(clazz)) {
                return true;
            }
            for (Field field : ReflectionUtils.getDeclaredFields(clazz)) {
                if ((field.getModifiers() & 8) != 0 || !this.detectFirstClassConstraints(field)) continue;
                return true;
            }
            for (AccessibleObject accessibleObject : ReflectionUtils.getDeclaredMethods(clazz)) {
                if ((((Method)accessibleObject).getModifiers() & 8) != 0 || !this.detectFirstClassConstraints(accessibleObject) && !this.detectParameterConstraints((Executable)accessibleObject)) continue;
                return true;
            }
            for (AccessibleObject accessibleObject : ReflectionUtils.getDeclaredConstructors(clazz)) {
                if (clazz.isEnum() || !this.detectFirstClassConstraints(accessibleObject) && !this.detectParameterConstraints((Executable)accessibleObject)) continue;
                return true;
            }
            return false;
        }

        private boolean detectAncestorConstraints(Class<?> clazz) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass == null) {
                return false;
            }
            return (Boolean)BeanValidationHelper.this.memoizer.compute((ComputableTask)BeanValidationHelper.this.cds, superClass);
        }

        private boolean detectFirstClassConstraints(AccessibleObject accessibleObject) {
            for (Annotation a : accessibleObject.getDeclaredAnnotations()) {
                Class<? extends Annotation> annType = a.annotationType();
                if (BeanValidationHelper.this.knownConstraints.contains(annType)) {
                    return true;
                }
                for (Annotation annOnAnnType : annType.getAnnotations()) {
                    Class<? extends Annotation> annTypeOnAnnType = annOnAnnType.annotationType();
                    if (Constraint.class != annTypeOnAnnType) continue;
                    BeanValidationHelper.this.knownConstraints.add(annType);
                    return true;
                }
            }
            return false;
        }

        private boolean detectParameterConstraints(Executable c) {
            Annotation[][] annotationArray = c.getParameterAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                Annotation[] aa;
                for (Annotation a : aa = annotationArray[i]) {
                    Class<? extends Annotation> annType = a.annotationType();
                    if (BeanValidationHelper.this.knownConstraints.contains(annType)) {
                        return true;
                    }
                    for (Annotation annOnAnnType : annType.getAnnotations()) {
                        Class<? extends Annotation> annTypeOnAnnType = annOnAnnType.annotationType();
                        if (Constraint.class != annTypeOnAnnType) continue;
                        BeanValidationHelper.this.knownConstraints.add(annType);
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

