/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.ControlImpl;
import com.sun.jts.CosTransactions.CoordinatorImpl;
import com.sun.jts.CosTransactions.DelegatedRecoveryManager;
import com.sun.jts.CosTransactions.GlobalTID;
import com.sun.jts.CosTransactions.ProxyChecker;
import com.sun.jts.CosTransactions.RecoveryManager;
import com.sun.jts.CosTransactions.SubCoordinator;
import com.sun.jts.CosTransactions.TerminatorImpl;
import com.sun.jts.CosTransactions.TimeoutManager;
import com.sun.jts.CosTransactions.TopCoordinator;
import com.sun.jts.CosTransactions.TxInflowCoordinator;
import com.sun.jts.utils.LogFormatter;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.DomainManager;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.Request;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.TransactionFactory;
import org.omg.CosTransactions.TransactionFactoryHelper;
import org.omg.CosTransactions.TransactionFactoryPOA;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

class TransactionFactoryImpl
extends TransactionFactoryPOA
implements TransactionFactory {
    private static POA poa = null;
    private TransactionFactory thisRef = null;
    static boolean active = true;
    static Logger _logger = LogDomains.getLogger(TransactionFactoryImpl.class, (String)"javax.enterprise.system.core.transaction");

    TransactionFactoryImpl() {
        TimeoutManager.initialise();
        RecoveryManager.initialise();
    }

    public Control create(int timeOut) throws SystemException {
        ControlImpl result = null;
        ControlImpl cimpl = this.localCreate(timeOut);
        if (cimpl == null) {
            return result;
        }
        result = Configuration.isLocalFactory() ? cimpl : cimpl.object();
        return result;
    }

    public ControlImpl localCreate(int timeOut) throws SystemException {
        if (!active) {
            NO_PERMISSION exc = new NO_PERMISSION(0, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        RecoveryManager.waitForResync(timeOut);
        TopCoordinator coordinator = null;
        TerminatorImpl terminator = null;
        ControlImpl result = null;
        try {
            coordinator = new TopCoordinator(timeOut);
            terminator = new TerminatorImpl(coordinator, false);
            result = new ControlImpl(terminator, coordinator, coordinator.getGlobalTid(), coordinator.getLocalTID());
            if (_logger.isLoggable(Level.FINE)) {
                _logger.logp(Level.FINE, "TransactionFactoryImpl", "localCreate()", "Control object :" + result + " corresponding to this transaction has been created, GTID is : " + coordinator.superInfo.globalTID.toString());
            }
        }
        catch (Throwable exc) {
            if (coordinator != null) {
                coordinator.doFinalize();
            }
            if (result != null) {
                result.doFinalize();
            }
            result = null;
        }
        return result;
    }

    public Control recreate(PropagationContext context) throws SystemException {
        if (!active) {
            NO_PERMISSION exc = new NO_PERMISSION(0, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        if (context.current == null || context.current.otid.formatID == -1) {
            return null;
        }
        GlobalTID globalTID = new GlobalTID(context.current.otid);
        CoordinatorImpl subordinate = RecoveryManager.getCoordinator(globalTID);
        ControlImpl result = null;
        ProxyChecker checker = Configuration.getProxyChecker();
        if (subordinate == null && !checker.isProxy((Object)context.current.coord)) {
            TRANSACTION_ROLLEDBACK exc = new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        if (subordinate == null) {
            RecoveryManager.waitForResync();
            subordinate = RecoveryManager.getCoordinator(globalTID);
        }
        try {
            if (subordinate == null) {
                if (context.parents.length > 0) {
                    CoordinatorImpl[] newAncestors = new CoordinatorImpl[context.parents.length];
                    for (int i = context.parents.length - 1; i >= 0; --i) {
                        GlobalTID subGlobalTID = new GlobalTID(context.parents[i].otid);
                        subordinate = RecoveryManager.getCoordinator(subGlobalTID);
                        if (subordinate == null) {
                            if (i == context.parents.length - 1) {
                                subordinate = new TopCoordinator(context.timeout, subGlobalTID, (Coordinator)context.parents[i].coord._duplicate(), true);
                            } else {
                                CoordinatorImpl[] subAncestors = new CoordinatorImpl[context.parents.length - i - 1];
                                System.arraycopy(newAncestors, i + 1, subAncestors, 0, context.parents.length - i - 1);
                                subordinate = new SubCoordinator(subGlobalTID, (Coordinator)context.parents[i].coord._duplicate(), true, subAncestors);
                                newAncestors[i + 1].addChild(subordinate);
                            }
                        }
                        context.parents[i].coord._release();
                        newAncestors[i] = subordinate;
                    }
                    subordinate = new SubCoordinator(globalTID, (Coordinator)context.current.coord._duplicate(), true, newAncestors);
                    newAncestors[0].addChild(subordinate);
                } else {
                    subordinate = new TopCoordinator(context.timeout, globalTID, (Coordinator)context.current.coord._duplicate(), true);
                }
            } else {
                subordinate.setPermanent();
            }
            result = Configuration.isLocalFactory() ? new ControlImpl(null, subordinate, globalTID, subordinate.getLocalTID()) : new ControlImpl(null, subordinate, globalTID, subordinate.getLocalTID()).object();
        }
        catch (Throwable exc) {
            _logger.log(Level.SEVERE, "jts.unable_to_create_subordinate_coordinator");
            String msg = LogFormatter.getLocalizedMessage(_logger, "jts.unable_to_create_subordinate_coordinator");
            throw new INTERNAL(msg);
        }
        return result;
    }

    public Control recreate(GlobalTID tid, int timeout) throws SystemException {
        if (!active) {
            NO_PERMISSION exc = new NO_PERMISSION(0, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        CoordinatorImpl subordinate = RecoveryManager.getCoordinator(tid);
        ControlImpl result = null;
        if (subordinate == null) {
            RecoveryManager.waitForResync();
            subordinate = RecoveryManager.getCoordinator(tid);
        }
        try {
            if (subordinate == null) {
                subordinate = new TopCoordinator(timeout, tid, new TxInflowCoordinator(), true);
            } else {
                Status status = subordinate.get_status();
                if (status != Status.StatusMarkedRollback && status != Status.StatusActive) {
                    throw new INVALID_TRANSACTION("tx completion in-progress");
                }
                subordinate.setPermanent();
            }
            result = Configuration.isLocalFactory() ? new ControlImpl(null, subordinate, tid, subordinate.getLocalTID()) : new ControlImpl(null, subordinate, tid, subordinate.getLocalTID()).object();
        }
        catch (Throwable exc) {
            _logger.log(Level.WARNING, "jts.unable_to_create_subordinate_coordinator");
            String msg = LogFormatter.getLocalizedMessage(_logger, "jts.unable_to_create_subordinate_coordinator");
            INTERNAL intExc = new INTERNAL(msg);
            intExc.initCause(exc);
            throw intExc;
        }
        return result;
    }

    static void deactivate() {
        active = false;
        TimeoutManager.shutdown(false);
        RecoveryManager.shutdown(false);
        DelegatedRecoveryManager.shutdown(false);
    }

    synchronized TransactionFactory object() {
        if (this.thisRef == null) {
            if (poa == null) {
                poa = Configuration.getPOA("transient");
            }
            try {
                poa.activate_object((Servant)this);
                this.thisRef = TransactionFactoryHelper.narrow((Object)poa.servant_to_reference((Servant)this));
                NamingContext namingContext = null;
                try {
                    namingContext = NamingContextHelper.narrow((Object)Configuration.getORB().resolve_initial_references("NameService"));
                }
                catch (Exception exc) {
                    _logger.log(Level.WARNING, "jts.orb_not_running");
                    return this.thisRef;
                }
                try {
                    NameComponent nc = new NameComponent(TransactionFactoryHelper.id(), "");
                    NameComponent[] path = new NameComponent[]{nc};
                    namingContext.rebind(path, (Object)this.thisRef);
                }
                catch (Exception exc) {
                    _logger.log(Level.WARNING, "jts.cannot_register_with_orb", "TransactionFactory");
                }
            }
            catch (Exception exc) {
                _logger.log(Level.SEVERE, "jts.create_transactionfactory_object_error");
                String msg = LogFormatter.getLocalizedMessage(_logger, "jts.create_transactionfactory_object_error");
                throw new INTERNAL(msg);
            }
        }
        return this.thisRef;
    }

    static final synchronized TransactionFactoryImpl servant(TransactionFactory factory) {
        TransactionFactoryImpl result = null;
        if (factory != null && Configuration.getProxyChecker().isProxy((Object)factory)) {
            return result;
        }
        if (factory instanceof TransactionFactoryImpl) {
            result = (TransactionFactoryImpl)factory;
        } else if (poa != null) {
            try {
                result = (TransactionFactoryImpl)poa.reference_to_servant((Object)factory);
                if (result.thisRef == null) {
                    result.thisRef = factory;
                }
            }
            catch (Exception exc) {
                _logger.log(Level.WARNING, "jts.cannot_locate_servant", "TransactionFactory");
            }
        }
        return result;
    }

    public Object _duplicate() {
        throw new NO_IMPLEMENT("This is a locally constrained object.");
    }

    public void _release() {
        throw new NO_IMPLEMENT("This is a locally constrained object.");
    }

    public boolean _is_a(String repository_id) {
        throw new NO_IMPLEMENT("This is a locally constrained object.");
    }

    public boolean _is_equivalent(Object that) {
        throw new NO_IMPLEMENT("This is a locally constrained object.");
    }

    public boolean _non_existent() {
        throw new NO_IMPLEMENT("This is a locally constrained object.");
    }

    public int _hash(int maximum) {
        throw new NO_IMPLEMENT("This is a locally constrained object.");
    }

    public Request _request(String operation) {
        throw new NO_IMPLEMENT("This is a locally constrained object.");
    }

    public Request _create_request(Context ctx, String operation, NVList arg_list, NamedValue result) {
        throw new NO_IMPLEMENT("This is a locally constrained object.");
    }

    public Request _create_request(Context ctx, String operation, NVList arg_list, NamedValue result, ExceptionList exceptions, ContextList contexts) {
        throw new NO_IMPLEMENT("This is a locally constrained object.");
    }

    public Object _get_interface_def() {
        throw new NO_IMPLEMENT("This is a locally constrained object.");
    }

    public Policy _get_policy(int policy_type) {
        throw new NO_IMPLEMENT("This is a locally constrained object.");
    }

    public DomainManager[] _get_domain_managers() {
        throw new NO_IMPLEMENT("This is a locally constrained object.");
    }

    public Object _set_policy_override(Policy[] policies, SetOverrideType set_add) {
        throw new NO_IMPLEMENT("This is a locally constrained object.");
    }
}

