/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.interceptors;

import com.sun.enterprise.deployment.InterceptorDescriptor;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.interceptor.AroundConstruct;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.AroundTimeout;
import jakarta.interceptor.InvocationContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;

public class SystemInterceptorProxy {
    public Object delegate;
    private Method aroundConstruct;
    private Method postConstruct;
    private Method preDestroy;
    private Method aroundInvoke;
    private Method aroundTimeout;

    public void setDelegate(Object d) {
        Class<?> delegateClass = d.getClass();
        try {
            for (Method m : delegateClass.getDeclaredMethods()) {
                if (m.getAnnotation(PostConstruct.class) != null) {
                    this.postConstruct = m;
                    this.prepareMethod(m);
                    continue;
                }
                if (m.getAnnotation(PreDestroy.class) != null) {
                    this.preDestroy = m;
                    this.prepareMethod(m);
                    continue;
                }
                if (m.getAnnotation(AroundInvoke.class) != null) {
                    this.aroundInvoke = m;
                    this.prepareMethod(m);
                    continue;
                }
                if (m.getAnnotation(AroundTimeout.class) != null) {
                    this.aroundTimeout = m;
                    this.prepareMethod(m);
                    continue;
                }
                if (m.getAnnotation(AroundConstruct.class) == null) continue;
                this.aroundConstruct = m;
                this.prepareMethod(m);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        this.delegate = d;
    }

    private void prepareMethod(final Method m) throws Exception {
        AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                if (!m.isAccessible()) {
                    m.setAccessible(true);
                }
                return null;
            }
        });
    }

    @PostConstruct
    public Object init(InvocationContext ctx) throws Exception {
        return this.doCall(ctx, this.postConstruct);
    }

    @PreDestroy
    public Object destroy(InvocationContext ctx) throws Exception {
        return this.doCall(ctx, this.preDestroy);
    }

    @AroundConstruct
    public Object create(InvocationContext ctx) throws Exception {
        return this.doCall(ctx, this.aroundConstruct);
    }

    @AroundInvoke
    public Object aroundInvoke(InvocationContext ctx) throws Exception {
        return this.doCall(ctx, this.aroundInvoke);
    }

    @AroundTimeout
    public Object aroundTimeout(InvocationContext ctx) throws Exception {
        return this.doCall(ctx, this.aroundTimeout);
    }

    private Object doCall(InvocationContext ctx, Method m) throws Exception {
        Object returnValue = null;
        if (this.delegate != null && m != null) {
            try {
                returnValue = m.invoke(this.delegate, ctx);
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getCause();
                if (cause instanceof Exception) {
                    throw (Exception)cause;
                }
                throw new Exception(cause);
            }
        } else {
            returnValue = ctx.proceed();
        }
        return returnValue;
    }

    public static InterceptorDescriptor createInterceptorDesc() {
        InterceptorDescriptor interceptor = new InterceptorDescriptor();
        Class<SystemInterceptorProxy> interceptorClass = SystemInterceptorProxy.class;
        String interceptorName = interceptorClass.getName();
        interceptor.setInterceptorClass(interceptorClass);
        LifecycleCallbackDescriptor desc = new LifecycleCallbackDescriptor();
        desc.setLifecycleCallbackClass(interceptorName);
        desc.setLifecycleCallbackMethod("create");
        interceptor.addCallbackDescriptor(LifecycleCallbackDescriptor.CallbackType.AROUND_CONSTRUCT, desc);
        desc = new LifecycleCallbackDescriptor();
        desc.setLifecycleCallbackClass(interceptorName);
        desc.setLifecycleCallbackMethod("init");
        interceptor.addCallbackDescriptor(LifecycleCallbackDescriptor.CallbackType.POST_CONSTRUCT, desc);
        desc = new LifecycleCallbackDescriptor();
        desc.setLifecycleCallbackClass(interceptorName);
        desc.setLifecycleCallbackMethod("destroy");
        interceptor.addCallbackDescriptor(LifecycleCallbackDescriptor.CallbackType.PRE_DESTROY, desc);
        desc = new LifecycleCallbackDescriptor();
        desc.setLifecycleCallbackClass(interceptorName);
        desc.setLifecycleCallbackMethod("aroundInvoke");
        interceptor.addAroundInvokeDescriptor(desc);
        desc = new LifecycleCallbackDescriptor();
        desc.setLifecycleCallbackClass(interceptorName);
        desc.setLifecycleCallbackMethod("aroundTimeout");
        interceptor.addAroundTimeoutDescriptor(desc);
        return interceptor;
    }
}

