/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.ext.Provider;
import java.util.List;
import java.util.Map;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.admin.rest.Constants;
import org.glassfish.admin.rest.composite.RestCollection;
import org.glassfish.admin.rest.composite.metadata.RestModelMetadata;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.glassfish.admin.rest.utils.JsonUtil;

@Provider
@Produces(value={"application/vnd.oracle.glassfish+json"})
public class RestCollectionProvider
extends BaseProvider<RestCollection> {
    public RestCollectionProvider() {
        super(RestCollection.class, Constants.MEDIA_TYPE_JSON_TYPE);
    }

    @Override
    public String getContent(RestCollection proxy) {
        StringBuilder sb = new StringBuilder();
        List wrapObjectHeader = ((HttpHeaders)this.requestHeaders.get()).getRequestHeader("X-Wrap-Object");
        List skipMetadataHeader = ((HttpHeaders)this.requestHeaders.get()).getRequestHeader("X-Skip-Metadata");
        boolean wrapObject = wrapObjectHeader != null && wrapObjectHeader.size() > 0;
        boolean skipMetadata = skipMetadataHeader != null && ((String)skipMetadataHeader.get(0)).equalsIgnoreCase("true");
        JSONArray models = new JSONArray();
        JSONArray metadata = new JSONArray();
        for (Map.Entry entry : proxy.entrySet()) {
            try {
                models.put(JsonUtil.getJsonObject(entry.getValue()));
                RestModelMetadata md = entry.getKey();
                JSONObject mdo = new JSONObject();
                mdo.put("id", (Object)md.getId());
                metadata.put((Object)mdo);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        JSONObject response = new JSONObject();
        try {
            response.put("items", (Object)models);
            if (!skipMetadata) {
                response.put("metadata", (Object)metadata);
            }
            sb.append(response.toString(this.getFormattingIndentLevel()));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return (wrapObject ? " { items : " : "") + sb.toString() + (wrapObject ? "}" : "");
    }
}

