/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import com.sun.appserv.server.util.Version;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.glassfish.admin.rest.provider.MethodMetaData;
import org.glassfish.admin.rest.provider.OptionsResultJsonProvider;
import org.glassfish.admin.rest.provider.OptionsResultXmlProvider;
import org.glassfish.admin.rest.provider.ParameterMetaData;
import org.glassfish.admin.rest.results.OptionsResult;
import org.glassfish.admin.rest.utils.ResourceUtil;
import org.glassfish.admin.rest.utils.Util;
import org.glassfish.external.statistics.Statistic;
import org.glassfish.external.statistics.impl.StatisticImpl;
import org.jvnet.hk2.config.ConfigBean;

public class ProviderUtil {
    public static final String KEY_CHILD_RESOURCE = "childResource";
    public static final String KEY_CHILD_RESOURCES = "childResources";
    public static final String KEY_COMMAND = "command";
    public static final String KEY_COMMANDS = "commands";
    public static final String KEY_ENTITY = "entity";
    public static final String KEY_METHODS = "methods";

    public static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuilder sb = new StringBuilder(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u").append(t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    protected static String slashToDash(String string) {
        if (string != null && !string.isEmpty()) {
            return string.replaceAll("/", "-");
        }
        return string;
    }

    protected static String readAsString(InputStream in) throws IOException {
        int l;
        InputStreamReader reader = new InputStreamReader(in);
        StringBuilder sb = new StringBuilder();
        char[] c = new char[1024];
        while ((l = reader.read(c)) != -1) {
            sb.append(c, 0, l);
        }
        return sb.toString();
    }

    public static String getElementLink(UriInfo uriInfo, String elementName) {
        return uriInfo.getRequestUriBuilder().segment(new String[]{elementName}).build(new Object[0]).toASCIIString();
    }

    protected static String getStartXmlElement(String name) {
        assert (name != null && name.length() > 0);
        Object result = "<";
        result = (String)result + name;
        result = (String)result + ">";
        return result;
    }

    protected static String getEndXmlElement(String name) {
        assert (name != null && name.length() > 0);
        Object result = "<";
        result = (String)result + "/";
        result = (String)result + name;
        result = (String)result + ">";
        return result;
    }

    public static Map getStatistics(Statistic statistic) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method[] methods;
        HashMap<String, Object> results = new HashMap<String, Object>();
        Class<?> classObject = statistic.getClass();
        for (Method method : methods = classObject.getMethods()) {
            String name;
            int modifier = method.getModifiers();
            if (!Modifier.isPublic(modifier) || !(name = method.getName()).startsWith("get")) continue;
            name = name.substring("get".length());
            Class<?> returnType = method.getReturnType();
            if (!returnType.isPrimitive() && !returnType.getName().equals("java.lang.String")) continue;
            results.put(name, method.invoke((Object)statistic, null));
        }
        return results;
    }

    public static Map<String, Object> getStatistic(Statistic statistic) {
        Map statsMap = Proxy.isProxyClass(statistic.getClass()) ? ((StatisticImpl)Proxy.getInvocationHandler(statistic)).getStaticAsMap() : ((StatisticImpl)statistic).getStaticAsMap();
        return statsMap;
    }

    public static HashMap<String, String> getStringMap(Map<String, Object> map) {
        HashMap<String, String> stringMap = new HashMap<String, String>();
        if (map != null) {
            Object key = null;
            Object value = null;
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                stringMap.put(entry.getKey(), entry.getValue().toString());
            }
        }
        return stringMap;
    }

    protected static String getHtmlRepresentationForAttributes(ConfigBean proxy, UriInfo uriInfo) {
        StringBuilder result = new StringBuilder();
        MethodMetaData methodMetaData = ResourceUtil.getMethodMetaData(proxy.model);
        Set<String> parameters = methodMetaData.parameters();
        for (String parameter : parameters) {
            ParameterMetaData parameterMetaData = methodMetaData.getParameterMetaData(parameter);
            String xmlAttributeName = ResourceUtil.convertToXMLName(parameter);
            result.append(ProviderUtil.getHtmlRespresentationForParameter(parameter, parameterMetaData, proxy.attribute(xmlAttributeName)));
        }
        if (result.length() > 0) {
            return "<div><form action=\"" + uriInfo.getAbsolutePath().toString() + "\" method=\"post\"><dl>" + result.toString() + "<dt class=\"button\"></dt><dd class=\"button\"><input value=\"Update\" type=\"submit\"></dd></dl></form></div>";
        }
        return "";
    }

    protected static String getHtmlRespresentationsForCommand(MethodMetaData methodMetaData, String commandMethod, String commandDisplayName, UriInfo uriInfo) {
        StringBuilder result = new StringBuilder();
        if (methodMetaData != null) {
            Set<String> parameters = methodMetaData.parameters();
            for (String parameter : parameters) {
                ParameterMetaData parameterMetaData = methodMetaData.getParameterMetaData(parameter);
                if (methodMetaData.isFileUploadOperation() && parameter.equals("id")) {
                    parameterMetaData.setIsFileParameter(true);
                }
                result.append(ProviderUtil.getHtmlRespresentationForParameter(parameter, parameterMetaData));
            }
            if (result.length() == 0) {
                result.append(" ");
            }
        }
        String webMethod = "post";
        if (commandMethod.equalsIgnoreCase("get")) {
            webMethod = "get";
        }
        if (result.length() != 0) {
            String encType = methodMetaData.isFileUploadOperation() ? " enctype=\"multipart/form-data\"" : "";
            result = new StringBuilder("<div><form action=\"").append(uriInfo.getAbsolutePath().toString()).append("\" method=\"").append(webMethod).append("\"").append(encType).append(">").append("<dl>").append((CharSequence)result);
            if (commandMethod.equalsIgnoreCase("DELETE")) {
                result.append("<dd><input name=\"operation\" value=\"__deleteoperation\" type=\"hidden\"></dd>");
            }
            result.append("<dd><input name=\"__remove_empty_entries__\" value=\"true\" type=\"hidden\"></dd>");
            result.append("<dt class=\"button\"></dt><dd class=\"button\"><input value=\"").append(commandDisplayName).append("\" type=\"submit\"></dd>");
            result.append("</dl></form></div>");
        }
        return result.toString();
    }

    protected static String getHtmlForComponent(String component, String heading, String result) {
        if (component != null && component.length() > 0) {
            result = (String)result + "<h2>" + heading + "</h2>";
            result = (String)result + component;
            result = (String)result + "<hr class=\"separator\"/>";
        }
        return result;
    }

    protected static String getHint(UriInfo uriInfo, String mediaType) {
        Object result = "";
        URI baseUri = uriInfo.getBaseUri();
        String monitoringLevelsConfigUrl = baseUri.getScheme() + "://" + baseUri.getHost() + ":" + baseUri.getPort() + "/management/domain/configs/config/server-config/monitoring-service/module-monitoring-levels";
        String name = Util.localStrings.getLocalString("rest.monitoring.levels.hint.heading", "Hint");
        String value = Util.localStrings.getLocalString("rest.monitoring.levels.hint.message", "Module monitoring levels may be OFF. To set module monitoring levels please visit following url: {0}", new Object[]{monitoringLevelsConfigUrl});
        if (mediaType.equals("text/html")) {
            monitoringLevelsConfigUrl = "<br><a href=\"" + monitoringLevelsConfigUrl + "\">" + monitoringLevelsConfigUrl + "</a>";
            value = Util.localStrings.getLocalString("rest.monitoring.levels.hint.message", "Module monitoring levels may be OFF. To set module monitoring levels please visit following url: {0}", new Object[]{monitoringLevelsConfigUrl});
            result = (String)result + "<h2>" + name + "</h2>";
            result = (String)result + value + "<br>";
            result = "<div>" + (String)result + "</div><br>";
            return result;
        }
        if (mediaType.equals("application/json")) {
            result = " " + ProviderUtil.quote(name) + ":" + ProviderUtil.jsonValue(value);
            return result;
        }
        if (mediaType.equals("application/xml")) {
            result = (String)result + " " + name + "=" + ProviderUtil.quote(value);
            return result;
        }
        return result;
    }

    public static String jsonValue(Object value) {
        String result = "";
        result = value.getClass().getName().equals("java.lang.String") ? ProviderUtil.quote(value.toString()) : value.toString();
        return result;
    }

    public static String getHtmlHeader(String baseUri) {
        String title = Version.getVersion() + " REST Interface";
        String result = "<html><head><title>" + title + "</title>";
        result = result + ProviderUtil.getInternalStyleSheet(baseUri);
        result = result + ProviderUtil.getAjaxJavascript(baseUri);
        result = result + "</head><body>";
        result = result + "<h1 class=\"mainheader\">" + title + "</h1>";
        result = result + "<hr/>";
        return result;
    }

    protected static JSONArray getJsonForMethodMetaData(OptionsResult metaData) throws JSONException {
        OptionsResultJsonProvider provider = new OptionsResultJsonProvider();
        return provider.getRespresenationForMethodMetaData(metaData);
    }

    protected static String getJsonForMethodMetaData(OptionsResult metaData, String indent) {
        OptionsResultJsonProvider provider = new OptionsResultJsonProvider();
        return provider.getRespresenationForMethodMetaData(metaData).toString();
    }

    protected static String getXmlForMethodMetaData(OptionsResult metaData, String indent) {
        OptionsResultXmlProvider provider = new OptionsResultXmlProvider();
        return provider.getRespresenationForMethodMetaData(metaData, indent);
    }

    private static String getHtmlRespresentationForParameter(String parameter, ParameterMetaData parameterMetaData) {
        return ProviderUtil.getHtmlRespresentationForParameter(parameter, parameterMetaData, null);
    }

    private static String getHtmlRespresentationForParameter(String parameter, ParameterMetaData parameterMetaData, String parameterValue) {
        boolean keyAttribute;
        String defaultValue;
        if ("true".equals(parameterMetaData.getAttributeValue("deprecated"))) {
            return "";
        }
        String parameterType = parameterMetaData.isFileParameter() ? "file" : "text";
        StringBuilder result = new StringBuilder();
        result.append("<dt><label for=\"").append(parameter).append("\">").append(parameter).append(parameterMetaData.getAttributeValue("optional").equalsIgnoreCase("false") ? "<sup>*</sup>" : "").append(":&nbsp;").append("</label></dt>");
        boolean isBoolean = false;
        if (parameterMetaData.getAttributeValue("type").endsWith("java.lang.Boolean") || parameterMetaData.getAttributeValue("type").equals("boolean")) {
            isBoolean = true;
        }
        boolean hasAcceptableValues = false;
        String acceptableValues = parameterMetaData.getAttributeValue("acceptableValues");
        if (acceptableValues != null && acceptableValues.length() > 0) {
            hasAcceptableValues = true;
        }
        boolean hasValue = false;
        if ((parameterValue == null || parameterValue.equals("")) && (defaultValue = parameterMetaData.getAttributeValue("defaultValue")) != null && defaultValue.length() > 0) {
            parameterValue = defaultValue;
        }
        if (parameterValue != null && parameterValue.length() > 0) {
            hasValue = true;
        }
        if (keyAttribute = Boolean.valueOf(parameterMetaData.getAttributeValue("key")).booleanValue()) {
            if (hasValue) {
                result.append("<dd><input name=\"").append(parameter).append("\" value =\"").append(parameterValue).append("\" type=\"").append(parameterType).append("\" disabled=\"disabled\"></dd>");
            } else {
                result.append("<dd><input name=\"").append(parameter).append("\" type=\"").append(parameterType).append("\"></dd>");
            }
        } else if (isBoolean || hasAcceptableValues) {
            result.append("<dd><select name=").append(parameter).append(">");
            String[] values = isBoolean ? new String[]{"true", "false"} : ProviderUtil.stringToArray(acceptableValues, ",");
            for (String value : values) {
                if (hasValue && value.equalsIgnoreCase(parameterValue)) {
                    if (isBoolean) {
                        parameterValue = parameterValue.toLowerCase(Locale.US);
                    }
                    result.append("<option selected>").append(parameterValue).append("<br>");
                    continue;
                }
                result.append("<option>").append(value).append("<br>");
            }
            result.append("</select></dd>");
        } else {
            boolean isList = parameterMetaData.getAttributeValue("type").equals("interface java.util.List");
            String field = hasValue ? "<input name=\"" + parameter + "\" value =\"" + parameterValue + "\" type=\"" + parameterType + "\">" : "<input name=\"" + parameter + "\" type=\"" + parameterType + "\">";
            result.append("<dd>").append(field);
            if (isList) {
                result.append("<a href=\"#\" onclick=\"try { var newNode = this.previousSibling.cloneNode(false); this.parentNode.insertBefore(newNode, this);} catch (err) { alert (err); } return false; return false;\">Add row<a/>");
            }
            result.append("</dd>");
        }
        return result.toString();
    }

    private static String[] stringToArray(String str, String delimiter) {
        String[] retString = new String[]{};
        if (str != null) {
            if (delimiter == null) {
                delimiter = " ";
            }
            StringTokenizer tokens = new StringTokenizer(str, delimiter);
            retString = new String[tokens.countTokens()];
            int i = 0;
            while (tokens.hasMoreTokens()) {
                retString[i++] = tokens.nextToken();
            }
        }
        return retString;
    }

    private static String getInternalStyleSheet(String baseUri) {
        return " <link rel=\"stylesheet\" type=\"text/css\" href=\"" + baseUri + "static/std.css\" />";
    }

    private static String getAjaxJavascript(String baseUri) {
        return " <script type=\"text/javascript\" src=\"" + baseUri + "static/ajax.javascript\"></script>";
    }
}

