/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.handlers;

import com.sun.jsftemplating.component.ComponentUtil;
import com.sun.jsftemplating.layout.LayoutDefinitionManager;
import com.sun.jsftemplating.layout.LayoutViewHandler;
import com.sun.jsftemplating.layout.descriptors.LayoutComponent;
import com.sun.jsftemplating.layout.descriptors.LayoutElement;
import com.sun.jsftemplating.layout.descriptors.LayoutElementBase;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.jsftemplating.util.LayoutElementUtil;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ComponentHandlers {
    public static void getChildren(HandlerContext context) {
        UIComponent parent = (UIComponent)context.getInputValue("parent");
        List list = parent.getChildren();
        context.setOutputValue("children", list);
        context.setOutputValue("size", new Integer(list.size()));
    }

    public static void replaceUIComponent(HandlerContext context) {
        UIComponent oldComp = (UIComponent)context.getInputValue("old");
        if (oldComp == null) {
            throw new IllegalArgumentException("You must provide a non-null value for 'component'.");
        }
        UIComponent newComp = (UIComponent)context.getInputValue("new");
        List list = oldComp.getParent().getChildren();
        if (newComp == null) {
            list.remove(oldComp);
        } else {
            int index = list.indexOf(oldComp);
            list.set(index, newComp);
        }
    }

    public static void buildUIComponentTree(HandlerContext context) {
        LayoutElement desc = (LayoutElement)context.getInputValue("layoutElement");
        UIComponent parent = (UIComponent)context.getInputValue("parent");
        if (parent == null) {
            parent = new UIViewRoot();
            ((UIViewRoot)parent).setViewId("fake");
        }
        FacesContext facesCtx = context.getFacesContext();
        if (desc instanceof LayoutComponent) {
            UIComponent tmpParent = ((LayoutComponent)desc).getChild(facesCtx, parent);
            LayoutViewHandler.buildUIComponentTree(facesCtx, tmpParent, desc);
        } else {
            LayoutViewHandler.buildUIComponentTree(facesCtx, parent, desc);
        }
        String id = desc.getId(facesCtx, parent);
        UIComponent result = parent.findComponent(id);
        if (result == null) {
            List children;
            if (desc instanceof LayoutComponent) {
                result = (UIComponent)parent.getFacets().get(id);
            }
            if (result == null && (children = parent.getChildren()).size() > 0) {
                result = (UIComponent)children.get(children.size() - 1);
            }
        }
        context.setOutputValue("result", result);
    }

    public static void createComponent(HandlerContext context) {
        String type = (String)context.getInputValue("type");
        UIComponent parent = (UIComponent)context.getInputValue("parent");
        String id = (String)context.getInputValue("id");
        if (id == null) {
            id = LayoutElementUtil.getGeneratedId(type);
        }
        FacesContext ctx = context.getFacesContext();
        LayoutComponent desc = new LayoutComponent(null, id, LayoutDefinitionManager.getGlobalComponentType(ctx, type));
        UIComponent component = ComponentUtil.getInstance(ctx).createChildComponent(ctx, desc, parent);
        context.setOutputValue("component", component);
    }

    public static void setComponentProperty(HandlerContext context) {
        UIComponent component = (UIComponent)context.getInputValue("component");
        String propName = (String)context.getInputValue("property");
        Object value = context.getInputValue("value");
        component.getAttributes().put(propName, value);
    }

    public static void getUIComponent(HandlerContext context) {
        UIViewRoot viewRoot = context.getFacesContext().getViewRoot();
        String clientId = (String)context.getInputValue("clientId");
        context.setOutputValue("component", viewRoot.findComponent(clientId));
    }

    public static void getUIComponentProperty(HandlerContext context) {
        UIComponent comp = (UIComponent)context.getInputValue("component");
        String name = (String)context.getInputValue("name");
        if (comp == null || name == null) {
            throw new IllegalArgumentException("This Handler requires non-null values for 'component' and 'name'.  'component' was specified as '" + context.getHandler().getInputValue("component") + "' and evaluated to '" + comp + "'. 'name' was specified as '" + context.getHandler().getInputValue("name") + "' and evaluated to '" + name + "'.");
        }
        Object value = comp.getAttributes().get(name);
        context.setOutputValue("value", value);
    }

    public static void getFacet(HandlerContext context) {
        UIComponent comp = ComponentHandlers.getUIComponentFromInput(context);
        String clientId = "" + (String)context.getInputValue("name");
        UIComponent value = null;
        if (comp != null) {
            value = (UIComponent)comp.getFacets().get(clientId);
        }
        context.setOutputValue("value", value);
    }

    public static void encode(HandlerContext context) throws IOException {
        UIComponent comp = ComponentHandlers.getUIComponentFromInput(context);
        LayoutElementBase.encodeChild(context.getFacesContext(), comp);
    }

    private static UIComponent getUIComponentFromInput(HandlerContext context) {
        UIComponent comp = (UIComponent)context.getInputValue("component");
        if (comp == null) {
            String clientId = (String)context.getInputValue("clientId");
            if (clientId != null) {
                UIViewRoot viewRoot = context.getFacesContext().getViewRoot();
                comp = viewRoot.findComponent(clientId);
            } else {
                throw new IllegalArgumentException("You must specify the component to use, or a clientId to locate the UIComponent to use.");
            }
        }
        return comp;
    }

    public static void dumpUIComponentTree(HandlerContext context) {
        UIComponent comp = (UIComponent)context.getInputValue("component");
        if (comp == null) {
            EventObject eventObject = context.getEventObject();
            if (eventObject instanceof UIComponent) {
                comp = (UIComponent)eventObject;
            } else {
                comp = context.getFacesContext().getViewRoot();
                if (comp == null) {
                    throw new IllegalArgumentException("Unable to determine UIComponent to dump!");
                }
            }
        }
        StringBuffer buf = new StringBuffer("UIComponent Tree:\n");
        ComponentHandlers.dumpTree(comp, buf, "    ");
        context.setOutputValue("value", buf.toString());
    }

    private static void dumpTree(UIComponent comp, StringBuffer buf, String indent) {
        Map facetMap;
        Iterator facetNames;
        buf.append(indent + comp.getId() + " (" + comp.getClass().getName() + ") = (" + comp.getAttributes().get("value") + ")\n");
        Iterator it = comp.getChildren().iterator();
        if (it.hasNext()) {
            buf.append(indent + "  Children:\n");
            while (it.hasNext()) {
                ComponentHandlers.dumpTree((UIComponent)it.next(), buf, indent + "    ");
            }
        }
        if ((facetNames = (facetMap = comp.getFacets()).keySet().iterator()).hasNext()) {
            while (facetNames.hasNext()) {
                String name = (String)facetNames.next();
                buf.append(indent + "  Facet (" + name + "):\n");
                ComponentHandlers.dumpTree((UIComponent)facetMap.get(name), buf, indent + "    ");
            }
        }
    }

    public static void dumpLayoutElementTree(HandlerContext context) {
        LayoutElement elt = (LayoutElement)context.getInputValue("layoutElement");
        if (elt == null && (elt = context.getLayoutElement()) == null) {
            throw new IllegalArgumentException("Unable to determine LayoutElement to dump!");
        }
        StringBuffer buf = new StringBuffer("LayoutElement Tree:\n");
        LayoutElementUtil.dumpTree(elt, buf, "    ");
        context.setOutputValue("value", buf.toString());
    }
}

