/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.shoal.gms.api.core;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import org.glassfish.shoal.gms.api.core.GMSException;
import org.glassfish.shoal.gms.api.core.GMSNotEnabledException;
import org.glassfish.shoal.gms.api.core.GMSNotInitializedException;
import org.glassfish.shoal.gms.api.core.GroupManagementService;

public class GMSFactory {
    private static final System.Logger LOG = System.getLogger(GMSFactory.class.getName());
    private static final Hashtable<String, GroupManagementService> GROUPS = new Hashtable();
    private static final Map<String, Boolean> GMS_ENABLED_MAP = new Hashtable<String, Boolean>();
    private static String memberToken;

    private GMSFactory() {
    }

    public static Runnable startGMSModule(String serverToken, String groupName, GroupManagementService.MemberType memberType, Properties properties) {
        GroupManagementService gms;
        if (serverToken == null) {
            throw new RuntimeException("instance name was not specified and cannot be null");
        }
        if (groupName == null) {
            throw new RuntimeException("group name was not specified and cannot be null");
        }
        GMS_ENABLED_MAP.put(groupName, Boolean.TRUE);
        try {
            gms = GMSFactory.getGMSModule(groupName);
        }
        catch (GMSException e) {
            gms = GMSFactory.getGroupManagementServiceInstance();
            gms.initialize(serverToken, groupName, memberType, properties);
            memberToken = serverToken;
            GROUPS.put(GMSFactory.getCompositeKey(groupName), gms);
        }
        return (Runnable)((Object)gms);
    }

    public static GroupManagementService getGMSModule(String groupName) throws GMSNotEnabledException, GMSException, GMSNotInitializedException {
        if (groupName == null) {
            throw new GMSException("group name was not specified and cannot be null");
        }
        String key = GMSFactory.getCompositeKey(groupName);
        if (GROUPS.containsKey(key)) {
            return GROUPS.get(key);
        }
        if (!GMSFactory.isGMSEnabled(groupName)) {
            throw new GMSNotEnabledException("GMS not enabled for group " + groupName);
        }
        throw new GMSNotInitializedException("Group Management Service is not initialized for group " + groupName);
    }

    public static GroupManagementService getGMSModule() throws GMSException {
        Collection instances = GMSFactory.getAllGMSInstancesForMember();
        if (instances.isEmpty()) {
            throw new GMSNotInitializedException("Group Management Service is not initialized for any group");
        }
        GroupManagementService gms = (GroupManagementService)instances.toArray()[0];
        return gms;
    }

    public static Collection getAllGMSInstancesForMember() {
        return GROUPS.values();
    }

    private static String getCompositeKey(String groupName) {
        return memberToken + "::" + groupName;
    }

    public static boolean isGMSEnabled(String groupName) {
        Boolean val = GMS_ENABLED_MAP.get(groupName);
        return val != null && !Boolean.FALSE.equals(val);
    }

    public static void setGMSEnabledState(String groupName, Boolean value) {
        GMS_ENABLED_MAP.put(groupName, value);
    }

    public static void removeGMSModule(String groupName) {
        String key;
        if (groupName != null && GROUPS.containsKey(key = GMSFactory.getCompositeKey(groupName))) {
            GROUPS.remove(key);
        }
    }

    private static GroupManagementService findByServiceLoader() {
        Object groupManagementService = null;
        ServiceLoader<GroupManagementService> loader = ServiceLoader.load(GroupManagementService.class);
        Iterator<GroupManagementService> iter = loader.iterator();
        if (iter.hasNext()) {
            try {
                groupManagementService = (GroupManagementService)iter.next().getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable t) {
                LOG.log(System.Logger.Level.WARNING, "GMS2002: error instantiating GroupManagementService service", t);
            }
        }
        if (groupManagementService == null) {
            LOG.log(System.Logger.Level.ERROR, "SMG2003: fatal error, no GroupManagementService implementations found");
        } else {
            LOG.log(System.Logger.Level.DEBUG, "GMS2001: findByServiceLoader() loaded service {0}", groupManagementService.getClass());
        }
        return groupManagementService;
    }

    private static GroupManagementService findByClassLoader(String classname) {
        GroupManagementService gmsImpl = null;
        try {
            Class<?> gmsImplClass = Class.forName(classname);
            if (gmsImplClass == null) {
                LOG.log(System.Logger.Level.ERROR, "factory.load.service.error");
            } else {
                gmsImpl = (GroupManagementService)gmsImplClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                LOG.log(System.Logger.Level.DEBUG, "findByClassLoader() loaded service " + String.valueOf(gmsImpl.getClass()));
            }
        }
        catch (Throwable x) {
            LOG.log(System.Logger.Level.ERROR, "GMS2004: fatal error instantiating GroupManagementService service", x);
        }
        return gmsImpl;
    }

    public static GroupManagementService getGroupManagementServiceInstance() {
        GroupManagementService gmsImpl = null;
        try {
            gmsImpl = GMSFactory.findByServiceLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (gmsImpl == null) {
            String classname = "org.glassfish.shoal.gms.common.GroupManagementServiceImpl";
            gmsImpl = GMSFactory.findByClassLoader(classname);
        }
        return gmsImpl;
    }
}

