/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.server.was;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.platform.server.JMXServerPlatformBase;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.ExternalTransactionController;
import org.eclipse.persistence.transaction.was.WebSphereTransactionController;

public class WebSpherePlatform
extends JMXServerPlatformBase {
    protected Class<?> websphereConnectionClass;
    protected Class<?> websphereUtilClass;
    protected Method vendorConnectionMethod;

    public WebSpherePlatform(DatabaseSession newDatabaseSession) {
        super(newDatabaseSession);
        this.disableRuntimeServices();
    }

    @Override
    public Class<? extends ExternalTransactionController> getExternalTransactionControllerClass() {
        if (this.externalTransactionControllerClass == null) {
            this.externalTransactionControllerClass = WebSphereTransactionController.class;
        }
        return this.externalTransactionControllerClass;
    }

    protected Class<?> getWebsphereUtilClass() {
        if (this.websphereUtilClass == null) {
            try {
                this.websphereUtilClass = this.getDatabaseSession().getPlatform().convertObject("com.ibm.ws.rsadapter.jdbc.WSJdbcUtil", Class.class);
            }
            catch (Throwable exception) {
                this.getDatabaseSession().getSessionLog().logThrowable(6, "server", exception);
                this.websphereUtilClass = Void.TYPE;
            }
        }
        return this.websphereUtilClass;
    }

    protected Class<?> getWebsphereConnectionClass() {
        if (this.websphereConnectionClass == null) {
            try {
                this.websphereConnectionClass = this.getDatabaseSession().getPlatform().convertObject("com.ibm.ws.rsadapter.jdbc.WSJdbcConnection", Class.class);
            }
            catch (Throwable exception) {
                this.getDatabaseSession().getSessionLog().logThrowable(6, "server", exception);
                this.websphereConnectionClass = Void.TYPE;
            }
        }
        return this.websphereConnectionClass;
    }

    protected Method getVendorConnectionMethod() {
        if (this.vendorConnectionMethod == null && !this.getWebsphereUtilClass().equals(Void.TYPE)) {
            try {
                Class[] args = new Class[]{this.getWebsphereConnectionClass()};
                this.vendorConnectionMethod = PrivilegedAccessHelper.getDeclaredMethod(this.getWebsphereUtilClass(), "getNativeConnection", args);
            }
            catch (NoSuchMethodException exception) {
                this.getDatabaseSession().getSessionLog().logThrowable(6, "server", exception);
            }
        }
        return this.vendorConnectionMethod;
    }

    @Override
    public Connection unwrapConnection(Connection connection) {
        if (this.getWebsphereConnectionClass().isInstance(connection) && this.getVendorConnectionMethod() != null) {
            try {
                return (Connection)PrivilegedAccessHelper.invokeMethod(this.getVendorConnectionMethod(), null, new Object[]{connection});
            }
            catch (IllegalAccessException exception) {
                this.getDatabaseSession().getSessionLog().logThrowable(6, "server", exception);
            }
            catch (InvocationTargetException exception) {
                this.getDatabaseSession().getSessionLog().logThrowable(6, "server", exception);
            }
        }
        return super.unwrapConnection(connection);
    }

    @Override
    public int getJNDIConnectorLookupType() {
        return 1;
    }
}

