/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.persistent.timer;

import com.sun.ejb.PersistentTimerService;
import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.EjbContainerUtil;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.enterprise.ee.cms.core.CallBack;
import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.PlannedShutdownSignal;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.transaction.api.RecoveryResourceRegistry;
import com.sun.enterprise.transaction.spi.RecoveryEventListener;
import jakarta.inject.Inject;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.ejb.persistent.timer.PersistentEJBTimerService;
import org.glassfish.gms.bootstrap.GMSAdapter;
import org.glassfish.gms.bootstrap.GMSAdapterService;
import org.glassfish.hk2.api.PostConstruct;
import org.jvnet.hk2.annotations.Service;

@Service
public class DistributedEJBTimerService
implements PersistentTimerService,
RecoveryEventListener,
PostConstruct,
CallBack {
    private static Logger logger = EjbContainerUtilImpl.getLogger();
    @Inject
    private EjbContainerUtil ejbContainerUtil;
    @Inject
    GMSAdapterService gmsAdapterService;
    @Inject
    RecoveryResourceRegistry recoveryResourceRegistry;

    public void postConstruct() {
        if (!this.ejbContainerUtil.isDas()) {
            GMSAdapter gmsAdapter;
            if (this.gmsAdapterService != null && (gmsAdapter = this.gmsAdapterService.getGMSAdapter()) != null) {
                gmsAdapter.registerPlannedShutdownListener((CallBack)this);
            }
            this.recoveryResourceRegistry.addEventListener((RecoveryEventListener)this);
        }
    }

    @Override
    public void initPersistentTimerService(String target) {
        PersistentEJBTimerService.initEJBTimerService(target);
    }

    public void processNotification(Signal signal) {
        if (signal instanceof PlannedShutdownSignal) {
            PlannedShutdownSignal pssig;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "[DistributedEJBTimerService] planned shutdown signal: " + signal);
            }
            if ((pssig = (PlannedShutdownSignal)signal).getEventSubType() == GMSConstants.shutdownType.INSTANCE_SHUTDOWN) {
                this.migrateTimers(signal.getMemberToken());
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "[DistributedEJBTimerService] ignoring signal: " + signal);
        }
    }

    public void beforeRecovery(boolean delegated, String instance) {
    }

    public void afterRecovery(boolean success, boolean delegated, String instance) {
        if (!delegated) {
            return;
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "[DistributedEJBTimerService] afterRecovery event for instance " + instance);
        }
        if (instance != null && !instance.equals(this.ejbContainerUtil.getServerEnvironment().getInstanceName())) {
            if (success) {
                this.migrateTimers(instance);
            } else {
                logger.log(Level.WARNING, "[DistributedEJBTimerService] Cannot perform automatic timer migration after failed transaction recovery");
            }
        }
    }

    private int migrateTimers(String serverId) {
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "[DistributedEJBTimerService] migrating timers from " + serverId);
        }
        int result = 0;
        EJBTimerService ejbTimerService = EJBTimerService.getEJBTimerService();
        if (ejbTimerService != null && ejbTimerService.isPersistent()) {
            result = ejbTimerService.migrateTimers(serverId);
        }
        return result;
    }
}

