/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cluster.ssh.util;

import com.jcraft.jsch.Session;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.glassfish.api.admin.CommandException;
import org.glassfish.cluster.ssh.util.Strings;

public class SSHUtil {
    private static final List<Session> activeConnections = new ArrayList<Session>();

    public static synchronized void register(Session session) {
        if (!activeConnections.contains(session)) {
            activeConnections.add(session);
        }
    }

    public static synchronized void unregister(Session session) {
        session.disconnect();
        activeConnections.remove(session);
    }

    public static String checkString(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        return s;
    }

    public static File getExistingKeyFile() {
        Path h = FileUtils.USER_HOME.toPath();
        for (String keyName : Arrays.asList("id_rsa", "id_dsa", "identity")) {
            File f = h.resolve(Path.of(".ssh", keyName)).toFile();
            if (!f.exists()) continue;
            return f;
        }
        return null;
    }

    public static File getDefaultKeyFile() {
        return FileUtils.USER_HOME.toPath().resolve(Path.of(".ssh", "id_rsa")).toFile();
    }

    public static boolean isEncryptedKey(File keyFile) throws CommandException {
        boolean res = false;
        try {
            String f = FileUtils.readSmallFile((File)keyFile, (Charset)StandardCharsets.ISO_8859_1).trim();
            if (f.startsWith("-----BEGIN ") && f.contains("ENCRYPTED") && f.endsWith(" PRIVATE KEY-----")) {
                res = true;
            }
        }
        catch (IOException ioe) {
            throw new CommandException(Strings.get("error.parsing.key", keyFile, ioe.getMessage()), (Throwable)ioe);
        }
        return res;
    }

    public static boolean validateKeyFile(File file) throws CommandException {
        if (!file.exists()) {
            throw new CommandException(Strings.get("key.does.not.exist", file));
        }
        if (!file.getName().endsWith(".pub")) {
            String key = null;
            try {
                key = FileUtils.readSmallFile((File)file, (Charset)StandardCharsets.ISO_8859_1).trim();
            }
            catch (IOException ioe) {
                throw new CommandException(Strings.get("unable.to.read.key", file, ioe.getMessage()));
            }
            if (!key.startsWith("-----BEGIN ") && !key.endsWith(" PRIVATE KEY-----")) {
                throw new CommandException(Strings.get("invalid.key.file", file));
            }
        }
        return true;
    }
}

