/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.fileupload;

import jakarta.servlet.http.Part;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.rmi.server.UID;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.LogFacade;
import org.apache.catalina.fileupload.DeferredFileOutputStream;
import org.apache.catalina.fileupload.Multipart;
import org.apache.catalina.fileupload.ParameterParser;
import org.apache.catalina.fileupload.PartHeaders;
import org.apache.catalina.fileupload.Streams;
import org.apache.catalina.util.RequestUtil;

class PartItem
implements Serializable,
Part {
    private static final long serialVersionUID = 2237570099615271025L;
    private static final Logger log = LogFacade.getLogger();
    private final ResourceBundle rb = log.getResourceBundle();
    private static final String UID = new UID().toString().replace(':', '_').replace('-', '_');
    private static int counter = 0;
    private String fieldName;
    private String contentType;
    private boolean isFormField;
    private String fileName;
    private long size = -1L;
    private int sizeThreshold;
    private File repository;
    private byte[] cachedContent;
    private transient DeferredFileOutputStream dfos;
    private transient File tempFile;
    private File dfosFile;
    private PartHeaders headers;
    private Multipart multipart;
    private String requestCharEncoding;

    public PartItem(Multipart multipart, PartHeaders headers, String fieldName, String contentType, boolean isFormField, String fileName, String requestCharEncoding) {
        this.multipart = multipart;
        this.headers = headers;
        this.fieldName = fieldName;
        this.contentType = contentType;
        this.isFormField = isFormField;
        this.fileName = fileName;
        this.requestCharEncoding = requestCharEncoding;
        this.sizeThreshold = multipart.getFileSizeThreshold();
        this.repository = multipart.getRepository();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.isInMemory()) {
            return new FileInputStream(this.dfos.getFile());
        }
        if (this.cachedContent == null) {
            this.cachedContent = this.dfos.getData();
        }
        return new ByteArrayInputStream(this.cachedContent);
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    public String getCharSet() {
        ParameterParser parser = new ParameterParser();
        parser.setLowerCaseNames(true);
        Map<String, String> params = parser.parse(this.getContentType(), ';');
        return params.get("charset");
    }

    @Override
    public String getSubmittedFileName() {
        return this.fileName;
    }

    public boolean isInMemory() {
        if (this.cachedContent != null) {
            return true;
        }
        return this.dfos.isInMemory();
    }

    @Override
    public long getSize() {
        if (this.size >= 0L) {
            return this.size;
        }
        if (this.cachedContent != null) {
            return this.cachedContent.length;
        }
        if (this.dfos.isInMemory()) {
            return this.dfos.getData().length;
        }
        return this.dfos.getFile().length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] get() {
        if (this.isInMemory()) {
            if (this.cachedContent == null) {
                this.cachedContent = this.dfos.getData();
            }
            return this.cachedContent;
        }
        byte[] fileData = new byte[(int)this.getSize()];
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.dfos.getFile());
            if (fis.read(fileData) != (int)this.getSize() && log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, "AS-WEB-CORE-00285");
            }
        }
        catch (IOException e) {
            fileData = null;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return fileData;
    }

    public String getString(String charset) throws UnsupportedEncodingException {
        return new String(this.get(), RequestUtil.lookupCharset(charset));
    }

    public String getString() {
        byte[] rawdata = this.get();
        String charset = this.getCharSet();
        if (charset == null) {
            charset = this.requestCharEncoding != null ? this.requestCharEncoding : "ISO-8859-1";
        }
        try {
            return new String(rawdata, RequestUtil.lookupCharset(charset));
        }
        catch (UnsupportedEncodingException e) {
            return new String(rawdata, Charset.defaultCharset());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file) throws IOException {
        if (this.isInMemory()) {
            try (FileOutputStream fout = null;){
                fout = new FileOutputStream(file);
                fout.write(this.get());
            }
        }
        File outputFile = this.getStoreLocation();
        if (outputFile != null) {
            this.size = outputFile.length();
            if (!outputFile.renameTo(file)) {
                BufferedInputStream in = null;
                FilterOutputStream out = null;
                try {
                    in = new BufferedInputStream(new FileInputStream(outputFile));
                    out = new BufferedOutputStream(new FileOutputStream(file));
                    Streams.copy(in, out, false);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        } else {
            throw new IOException("Cannot write uploaded file to disk!");
        }
    }

    @Override
    public void write(String file) throws IOException {
        this.write(new File(this.repository, file));
    }

    @Override
    public void delete() {
        this.cachedContent = null;
        File outputFile = this.getStoreLocation();
        if (outputFile != null && outputFile.exists()) {
            this.deleteFile(outputFile);
        }
    }

    @Override
    public String getName() {
        return this.fieldName;
    }

    public void setName(String fieldName) {
        this.fieldName = fieldName;
    }

    public boolean isFormField() {
        return this.isFormField;
    }

    public void setFormField(boolean state) {
        this.isFormField = state;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.dfos == null) {
            File outputFile = this.getTempFile();
            this.dfos = new DeferredFileOutputStream(this.sizeThreshold, outputFile);
        }
        return this.dfos;
    }

    public File getStoreLocation() {
        return this.dfos == null ? null : this.dfos.getFile();
    }

    protected void finalize() {
        File outputFile = this.dfos.getFile();
        if (outputFile != null && outputFile.exists()) {
            this.deleteFile(outputFile);
        }
    }

    protected File getTempFile() {
        if (this.tempFile == null) {
            File tempDir = this.repository;
            if (tempDir == null) {
                tempDir = new File(System.getProperty("java.io.tmpdir"));
            }
            String tempFileName = "upload_" + UID + "_" + PartItem.getUniqueId() + ".tmp";
            this.tempFile = new File(tempDir, tempFileName);
        }
        return this.tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getUniqueId() {
        int limit = 100000000;
        Class<PartItem> clazz = PartItem.class;
        synchronized (PartItem.class) {
            int current = counter++;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            String id = Integer.toString(current);
            if (current < 100000000) {
                id = ("00000000" + id).substring(id.length());
            }
            return id;
        }
    }

    public String toString() {
        return "File name=" + this.getSubmittedFileName() + ", StoreLocation=" + String.valueOf(this.getStoreLocation()) + ", size=" + this.getSize() + "bytes, isFormField=" + this.isFormField() + ", FieldName=" + this.getName();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.dfos.isInMemory()) {
            this.cachedContent = this.get();
        } else {
            this.cachedContent = null;
            this.dfosFile = this.dfos.getFile();
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.repository != null) {
            if (this.repository.isDirectory()) {
                if (this.repository.getPath() != null && this.repository.getPath().contains("\u0000")) {
                    String msg = MessageFormat.format(this.rb.getString("AS-WEB-CORE-00550"), this.repository.getPath());
                    throw new IOException(msg);
                }
            } else {
                String msg = MessageFormat.format(this.rb.getString("AS-WEB-CORE-00549"), this.repository.getAbsolutePath());
                throw new IOException(msg);
            }
        }
        try (OutputStream output = this.getOutputStream();){
            if (this.cachedContent != null) {
                output.write(this.cachedContent);
            } else {
                if (this.dfosFile != null && (this.dfosFile.getPath() == null || this.dfosFile.getPath().contains("\u0000"))) {
                    String msg = MessageFormat.format(this.rb.getString("AS-WEB-CORE-00550"), this.dfosFile.getPath());
                    throw new IOException(msg);
                }
                FileInputStream input = new FileInputStream(this.dfosFile);
                Streams.copy(input, output, false);
                this.deleteFile(this.dfosFile);
                this.dfosFile = null;
            }
        }
        this.cachedContent = null;
    }

    @Override
    public String getHeader(String name) {
        return this.headers.getHeader(name);
    }

    @Override
    public Collection<String> getHeaders(String name) {
        List<String> values = this.headers.getHeaders(name);
        if (values != Collections.EMPTY_LIST) {
            values = Collections.unmodifiableList(values);
        }
        return values;
    }

    @Override
    public Collection<String> getHeaderNames() {
        return this.headers.getHeaderNames();
    }

    private void deleteFile(File file) {
        if (!file.delete() && log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Cannot delete file: " + file);
        }
    }
}

