/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.httptunnel.tunnel.servlet;

import com.sun.messaging.jmq.httptunnel.api.share.HttpTunnelDefaults;
import com.sun.messaging.jmq.httptunnel.tunnel.HttpTunnelPacket;
import com.sun.messaging.jmq.httptunnel.tunnel.Link;
import com.sun.messaging.jmq.httptunnel.tunnel.servlet.ServerLinkTable;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;

public class ServerLink
extends Link
implements HttpTunnelDefaults {
    private static boolean DEBUG = Boolean.getBoolean("httptunnel.debug");
    private Socket serverConn = null;
    private ServerLinkTable parent = null;
    private String serverName = null;
    private boolean listenState = false;
    private boolean serverReady = false;

    public ServerLink(Socket serverConn, ServerLinkTable parent) throws IOException {
        try {
            serverConn.setTcpNoDelay(true);
        }
        catch (SocketException e) {
            parent.servletContext.log("WARNING: HttpTunnelTcpLink()[" + serverConn.toString() + "]setTcpNoDelay: " + e.toString(), (Throwable)e);
        }
        this.serverConn = serverConn;
        this.parent = parent;
        this.is = serverConn.getInputStream();
        this.os = serverConn.getOutputStream();
        this.setName("HttpTunnelTcpLink[" + serverConn + "]");
        this.start();
    }

    @Override
    protected void createLink() {
    }

    @Override
    protected void handleLinkDown() {
        try {
            this.serverConn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.parent.serverDown(this);
    }

    @Override
    protected void linkDown() {
        super.linkDown();
    }

    protected boolean isDone() {
        return this.done;
    }

    protected String getServerName() {
        return this.serverName;
    }

    protected boolean getListenState() {
        return this.listenState;
    }

    @Override
    protected void receivePacket(HttpTunnelPacket p) {
        if (this.serverReady) {
            if (p.getPacketType() == 11) {
                this.receiveListenStatePacket(p);
                return;
            }
            if (DEBUG) {
                this.log("Received Packet : " + p);
            }
            this.parent.receivePacket(p, this);
            return;
        }
        if (p.getPacketType() != 8) {
            this.parent.servletContext.log("HttpTunnelServlet: ServerLink[" + this.serverName + "] received unexpected packet type " + p.getPacketType());
            this.shutdown();
            this.linkDown();
            return;
        }
        byte[] buf = p.getPacketBody();
        ByteArrayInputStream bis = new ByteArrayInputStream(buf);
        DataInputStream dis = new DataInputStream(bis);
        try {
            this.serverName = dis.readUTF();
            int n = dis.readInt();
            for (int i = 0; i < n; ++i) {
                int connId = dis.readInt();
                int pullPeriod = dis.readInt();
                this.parent.updateConnection(connId, pullPeriod, this);
            }
            this.parent.servletContext.log("HttpTunnelServlet: ServerLink[" + this.serverName + "] link initialized");
            this.parent.updateServerName(this);
            this.serverReady = true;
        }
        catch (Exception e) {
            this.parent.servletContext.log("HttpTunnelServlet: ServerLink[" + this.serverName + "] init link failed: " + e.getMessage(), (Throwable)e);
            this.shutdown();
            this.linkDown();
        }
    }

    private void receiveListenStatePacket(HttpTunnelPacket p) {
        byte[] buf = p.getPacketBody();
        ByteArrayInputStream bis = new ByteArrayInputStream(buf);
        DataInputStream dis = new DataInputStream(bis);
        String sname = null;
        try {
            sname = dis.readUTF();
            this.listenState = dis.readBoolean();
        }
        catch (Exception e) {
            this.parent.servletContext.log("HttpTunnelServlet: ServerLink[" + sname + "] receiveListenStatePacket failed: " + e.getMessage(), (Throwable)e);
            this.shutdown();
            this.linkDown();
        }
    }
}

