/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.ejb.cmp;

import com.sun.jdo.api.persistence.support.JDOException;
import com.sun.jdo.api.persistence.support.JDOHelper;
import com.sun.jdo.api.persistence.support.PersistenceCapable;
import com.sun.jdo.api.persistence.support.PersistenceManager;
import com.sun.jdo.spi.persistence.support.ejb.cmp.LogHelperEntityFinder;
import com.sun.jdo.spi.persistence.support.ejb.cmp.LogHelperEntityInternal;
import com.sun.jdo.spi.persistence.support.ejb.cmp.LogHelperEntityLifecycle;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.EJBHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import jakarta.ejb.DuplicateKeyException;
import jakarta.ejb.EJBException;
import jakarta.ejb.ObjectNotFoundException;
import java.util.Arrays;
import java.util.Collection;
import java.util.ResourceBundle;
import org.glassfish.persistence.common.I18NHelper;

public class CMPBeanHelper {
    private static final ResourceBundle cmpMessages = I18NHelper.loadBundle((String)"com.sun.jdo.spi.persistence.support.ejb.ejbc.Bundle", (ClassLoader)CMPBeanHelper.class.getClassLoader());
    private static Logger cmpLifecycleLogger = LogHelperEntityLifecycle.getLogger();
    private static Logger cmpFinderLogger = LogHelperEntityFinder.getLogger();
    private static Logger cmpInternalLogger = LogHelperEntityInternal.getLogger();

    public static void logJDOExceptionWithLifecycleLogger(String key, String beanName, JDOException ex) {
        cmpLifecycleLogger.log(900, I18NHelper.getMessage((ResourceBundle)cmpMessages, (String)key, (String)beanName, (String)CMPBeanHelper.findCallingMethodName()), (Throwable)ex);
    }

    public static void logJDOExceptionWithLifecycleLogger(String key, String beanName, String paramList, JDOException ex) {
        cmpLifecycleLogger.log(900, I18NHelper.getMessage((ResourceBundle)cmpMessages, (String)key, (String)beanName, (String)CMPBeanHelper.findCallingMethodName(), (String)paramList), (Throwable)ex);
    }

    public static void logJDOExceptionWithInternalLogger(String beanName, JDOException ex) {
        cmpInternalLogger.log(900, I18NHelper.getMessage((ResourceBundle)cmpMessages, (String)"GEN.generic_method_exception", (String)beanName, (String)CMPBeanHelper.findCallingMethodName()), (Throwable)ex);
    }

    public static void logJDOExceptionWithFinderLogger(String beanName, Object[] params, JDOException ex) {
        String msg = null;
        msg = params != null ? I18NHelper.getMessage((ResourceBundle)cmpMessages, (String)"GEN.ejbSSReturnBody_exception", (String)beanName, (String)CMPBeanHelper.findCallingMethodName(), (String)Arrays.asList(params).toString()) : I18NHelper.getMessage((ResourceBundle)cmpMessages, (String)"GEN.ejbSSReturnBody_exception_woparams", (String)beanName, (String)CMPBeanHelper.findCallingMethodName());
        cmpFinderLogger.log(900, msg, (Throwable)ex);
    }

    public static void logFinderException(int level, String beanName, Exception ex) {
        if (cmpFinderLogger.isLoggable(level)) {
            cmpFinderLogger.log(level, I18NHelper.getMessage((ResourceBundle)cmpMessages, (String)"GEN.generic_method_exception", (String)beanName, (String)CMPBeanHelper.findCallingMethodName()), (Throwable)ex);
        }
    }

    public static String logJDOExceptionFromPKSetter(String beanName, JDOException ex) {
        String msg = I18NHelper.getMessage((ResourceBundle)cmpMessages, (String)"EXC_PKUpdate", (String)beanName, (String)CMPBeanHelper.findCallingMethodName());
        if (cmpInternalLogger.isLoggable(500)) {
            cmpInternalLogger.log(500, msg, (Throwable)ex);
        }
        return msg;
    }

    public static void assertPersistent(PersistenceCapable pc, String beanName) {
        if (!JDOHelper.isPersistent(pc)) {
            String msg = I18NHelper.getMessage((ResourceBundle)cmpMessages, (String)"GEN.cmrgettersetter_exception", (String)beanName, (String)CMPBeanHelper.findCallingMethodName());
            cmpInternalLogger.log(1000, msg);
            throw new IllegalStateException(msg);
        }
    }

    public static void assertCollectionNotNull(Collection c, String beanName) {
        if (c == null) {
            String msg = I18NHelper.getMessage((ResourceBundle)cmpMessages, (String)"GEN.cmrsettercol_nullexception", (String)beanName, (String)CMPBeanHelper.findCallingMethodName());
            cmpInternalLogger.log(1000, msg);
            throw new IllegalArgumentException(msg);
        }
    }

    public static void assertPersistenceManagerNotNull(PersistenceManager pm, Object bean) {
        if (pm == null) {
            String msg = I18NHelper.getMessage((ResourceBundle)cmpMessages, (String)"JDO.beannotloaded_exception", (Object)bean);
            cmpInternalLogger.log(1000, msg);
            throw new IllegalStateException(msg);
        }
    }

    public static void assertPersistenceManagerIsNull(PersistenceManager pm, Object bean, StringBuffer buf) {
        if (pm != null) {
            String msg = I18NHelper.getMessage((ResourceBundle)cmpMessages, (String)"JDO.beaninuse_exception", (Object)bean);
            IllegalStateException e = new IllegalStateException(msg);
            if (buf != null && buf.length() > 0) {
                msg = new StringBuffer(msg).append(" ...Last Instance Usage: ").append(buf).toString();
            }
            cmpInternalLogger.log(1000, msg);
            throw e;
        }
    }

    public static void assertNotContainerTransaction(Object bean) {
        if (EJBHelper.getTransaction() != null) {
            String msg = I18NHelper.getMessage((ResourceBundle)cmpMessages, (String)"JDO.containertransaction_exception", (Object)bean);
            cmpInternalLogger.log(1000, msg);
            throw new IllegalStateException(msg);
        }
    }

    public static void handleJDODuplicateObjectIdAsDuplicateKeyException(String beanName, String paramList, JDOException ex) throws DuplicateKeyException {
        String msg = I18NHelper.getMessage((ResourceBundle)cmpMessages, (String)"GEN.ejbcreate_exception_dup", (String)beanName, (String)CMPBeanHelper.findCallingMethodName(), (String)paramList);
        cmpLifecycleLogger.log(400, msg, (Throwable)ex);
        throw new DuplicateKeyException(msg);
    }

    public static void handleJDODuplicateObjectIdAsEJBException(String beanName, String paramList, JDOException ex) {
        String msg = I18NHelper.getMessage((ResourceBundle)cmpMessages, (String)"GEN.ejbcreate_exception_dup", (String)beanName, (String)CMPBeanHelper.findCallingMethodName(), (String)paramList);
        cmpLifecycleLogger.log(400, msg, (Throwable)ex);
        throw new EJBException(msg);
    }

    public static void handleJDOObjectNotFoundException(Object primaryKey, String beanName, JDOException ex) throws ObjectNotFoundException {
        String msg = I18NHelper.getMessage((ResourceBundle)cmpMessages, (String)"GEN.findbypk_exception_notfound", (String)beanName, (String)primaryKey.toString());
        cmpLifecycleLogger.log(400, msg, (Throwable)ex);
        throw new ObjectNotFoundException(msg);
    }

    public static void handleUpdateNotAllowedException(String beanName) {
        String msg = I18NHelper.getMessage((ResourceBundle)cmpMessages, (String)"GEN.update_not_allowed", (String)beanName, (String)CMPBeanHelper.findCallingMethodName());
        cmpLifecycleLogger.log(1000, msg);
        throw new EJBException(msg);
    }

    public static void handleCloneException(Object primaryKey, String beanName, Exception ex) {
        String msg = I18NHelper.getMessage((ResourceBundle)cmpMessages, (String)"GEN.clone_exception", (String)beanName, (String)primaryKey.toString());
        cmpLifecycleLogger.log(1000, msg, (Throwable)ex);
        throw new EJBException(msg);
    }

    private static String findCallingMethodName() {
        StackTraceElement[] ste = new Throwable().getStackTrace();
        return ste[2].getMethodName();
    }
}

