/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.pool;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.pool.BasicRunnable;
import com.sun.messaging.jmq.jmsserver.pool.RunnableFactory;
import com.sun.messaging.jmq.util.MQThread;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Vector;

public class ThreadPool {
    public boolean destroyed = false;
    private boolean in_destroy = false;
    private static boolean DEBUG = false;
    protected Logger logger = Globals.getLogger();
    RunnableFactory runfac = null;
    LinkedHashSet availIndx = null;
    ArrayList current = null;
    LinkedList available = null;
    int nextThreadId = 0;
    protected ThreadGroup tgroup = null;
    protected int min;
    protected int max;
    protected String name = null;
    protected int current_count = 0;
    protected boolean notActive = true;
    protected int priority = 5;

    public boolean isValid() {
        return !this.destroyed && !this.in_destroy;
    }

    public void setPriority(int p) {
        this.priority = p;
    }

    public synchronized int getMinimum() {
        return this.min;
    }

    public synchronized int getMaximum() {
        return this.max;
    }

    public synchronized void setMinimum(int num) throws IllegalArgumentException {
        this.setMinMax(num, this.max);
    }

    public synchronized void setMaximum(int num) throws IllegalArgumentException {
        this.setMinMax(this.min, num);
    }

    public synchronized Hashtable getDebugState() {
        Vector<Object> v;
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("min", this.min);
        ht.put("max", this.max);
        ht.put("name", this.name);
        ht.put("current_count", this.current_count);
        ht.put("nextThreadId", this.nextThreadId);
        ht.put("notActive", this.notActive);
        ht.put("destroyed", this.destroyed);
        ht.put("in_destroy", this.in_destroy);
        ht.put("priority", this.priority);
        if (this.current != null) {
            ht.put("currentCnt", this.current.size());
            v = new Vector<Object>();
            for (BasicRunnable runner : this.current) {
                if (runner == null) {
                    v.add("Runner is null");
                    continue;
                }
                v.add(runner.getDebugState());
            }
            ht.put("current", v);
        } else {
            ht.put("currentCnt", "null");
        }
        if (this.availIndx != null) {
            ht.put("availIndxCnt", this.availIndx.size());
            v = new Vector();
            for (Integer index : this.availIndx) {
                v.add(index);
            }
            ht.put("availIndx", v);
        } else {
            ht.put("availIndxCnt", "null");
        }
        if (this.available != null) {
            ht.put("availableCnt", this.available.size());
            v = new Vector();
            for (BasicRunnable runner : this.available) {
                v.add(runner.getDebugState());
            }
            ht.put("available", v);
        } else {
            ht.put("availableCnt", "null");
        }
        return ht;
    }

    public synchronized int[] setMinMax(int newmin, int newmax) throws IllegalArgumentException {
        BasicRunnable runner;
        int i;
        int[] rets = new int[]{-1, -1};
        if (this.in_destroy) {
            return rets;
        }
        if (newmin == -1) {
            newmin = this.min;
        }
        if (newmax == -1) {
            newmax = this.max;
        }
        if (newmin > newmax) {
            Object[] args = new String[]{this.name, String.valueOf(newmin), String.valueOf(newmax)};
            String emsg = Globals.getBrokerResources().getKString("B2292", args);
            this.logger.log(16, emsg);
            newmin = newmax;
        }
        int count = this.current.size();
        for (i = newmax; i < this.max && i < count; ++i) {
            runner = (BasicRunnable)this.current.get(i);
            if (runner == null) continue;
            runner.setThreadBehavior(2);
        }
        for (i = newmin; i > this.min && i > 0 && i < count; --i) {
            runner = (BasicRunnable)this.current.get(i);
            if (runner == null) continue;
            runner.setThreadBehavior(0);
        }
        for (i = newmin; i < this.max && i < count; ++i) {
            runner = (BasicRunnable)this.current.get(i);
            if (runner == null) continue;
            runner.setThreadBehavior(1);
        }
        LinkedHashSet<Integer> list = new LinkedHashSet<Integer>();
        for (int i2 = 0; i2 < count; ++i2) {
            Object obj = this.current.get(i2);
            if (obj != null) continue;
            list.add(i2);
        }
        if (this.min != newmin) {
            rets[0] = this.min = newmin;
        }
        if (this.max != newmax) {
            rets[1] = this.max = newmax;
        }
        this.availIndx = list;
        return rets;
    }

    public synchronized void debug() {
        StringBuilder info = new StringBuilder();
        info.append("\n--------------------------------------------\n DUMPING THREAD POOL ").append(this).append("\n--------------------------------------------\n[min, max] = [").append(this.min).append(',').append(this.max).append("]\n---- threads ----\n#\tAvailable\thash\tRunner\n");
        for (int i = 0; i < this.max; ++i) {
            BasicRunnable runner = null;
            if (i < this.current.size()) {
                runner = (BasicRunnable)this.current.get(i);
            }
            if (runner == null) continue;
            info.append(i).append('\t').append(this.available.contains(runner)).append('\t').append(Long.toHexString(runner.hashCode())).append('\t').append(runner).append('\n');
        }
        info.append("--------------------------------------------\nDONE DUMPING THREAD POOL\n--------------------------------------------\n\n");
        this.logger.log(4, info.toString());
    }

    public synchronized int getThreadNum() {
        return this.current_count;
    }

    public synchronized int getAssignedCnt() {
        return this.current_count - this.available.size() - this.availIndx.size();
    }

    public ThreadPool(String name, int min, int max, RunnableFactory runfac) {
        if (DEBUG) {
            Object[] args = new String[]{name, String.valueOf(min), String.valueOf(max)};
            this.logger.log(4, "ThreadPool: Creating Thread Pool({0}) = [ {1}, {2} ]", args);
        }
        this.min = min;
        this.max = max;
        this.tgroup = new MyThreadGroup("ThreadPool(" + name + ")");
        this.name = name;
        this.availIndx = new LinkedHashSet();
        this.current = new ArrayList();
        this.available = new LinkedList();
        this.runfac = runfac;
        this.current_count = 0;
        this.nextThreadId = 0;
    }

    public void start() {
        this.resume();
    }

    public synchronized boolean isSuspended() {
        return this.notActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        if (DEBUG) {
            this.logger.log(4, "ThreadPool:  SUSPENDING ThreadPool({0})", this.name);
        }
        if (this.in_destroy) {
            return;
        }
        this.notActive = true;
        ArrayList copy = null;
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            copy = new ArrayList(this.current);
        }
        for (int i = 0; i < copy.size(); ++i) {
            BasicRunnable runner = (BasicRunnable)copy.get(i);
            if (runner == null) continue;
            runner.suspend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        if (DEBUG) {
            this.logger.log(4, "ThreadPool:  RESUMING ThreadPool({0})", this.name);
        }
        if (this.in_destroy) {
            return;
        }
        this.notActive = false;
        ArrayList copy = null;
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            copy = new ArrayList(this.current);
        }
        for (int i = 0; i < copy.size(); ++i) {
            BasicRunnable runner = (BasicRunnable)copy.get(i);
            if (runner == null) continue;
            runner.resume();
        }
        ThreadPool threadPool2 = this;
        synchronized (threadPool2) {
            this.notifyAll();
        }
    }

    public void setSuspended(boolean susp) {
        if (susp) {
            this.suspend();
        } else {
            this.resume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicRunnable getAvailRunnable(boolean wait) {
        try {
            BasicRunnable runner = null;
            String how = null;
            while (!this.in_destroy && !this.destroyed) {
                Object object = this;
                synchronized (object) {
                    if (!this.available.isEmpty()) {
                        how = "availableList";
                        runner = (BasicRunnable)this.available.removeFirst();
                    } else if (!this.availIndx.isEmpty()) {
                        how = "existing index";
                        Iterator itr = this.availIndx.iterator();
                        int indx = (Integer)itr.next();
                        itr.remove();
                        runner = this.createNewThread(indx);
                    } else if (this.nextThreadId < this.max) {
                        how = "new thread";
                        int indx = this.nextThreadId++;
                        runner = this.createNewThread(indx);
                    } else {
                        return null;
                    }
                }
                if (runner == null) {
                    this.logger.log(32, "B3100", how);
                    continue;
                }
                object = runner;
                synchronized (object) {
                    if (runner.available()) {
                        runner.setState(2);
                    } else {
                        runner = null;
                    }
                }
                if (runner != null) break;
                object = this;
                synchronized (object) {
                    if (wait) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ex) {
                        }
                    }
                    break;
                }
            }
            return runner;
        }
        catch (Exception ex) {
            this.logger.logStack(16, ex.getMessage(), ex);
            return null;
        }
    }

    private synchronized BasicRunnable createNewThread(int indx) throws ArrayIndexOutOfBoundsException {
        if (indx >= this.max) {
            throw new ArrayIndexOutOfBoundsException(Globals.getBrokerResources().getString("B4117", "Too many threads " + this.current_count + "," + this.max));
        }
        BasicRunnable runner = null;
        if (indx < this.current.size()) {
            runner = (BasicRunnable)this.current.get(indx);
        }
        if (runner == null) {
            runner = this.runfac.getRunnable(indx, this);
            if (this.current.size() <= indx) {
                this.current.add(indx, runner);
            } else {
                this.current.set(indx, runner);
            }
        }
        runner.setState(1);
        MQThread thr = new MQThread(this.tgroup, runner, "Thread-" + this.name + "[" + indx + "]");
        thr.setPriority(this.priority);
        if (indx >= this.min) {
            runner.setThreadBehavior(1);
        }
        ++this.current_count;
        thr.start();
        return runner;
    }

    public synchronized void runnableDestroying(int indx) {
        if (indx >= this.current.size()) {
            this.logger.log(32, "B3100", " attempting to destroy unknown thread  " + indx);
            this.debug();
            return;
        }
        BasicRunnable r = (BasicRunnable)this.current.get(indx);
        this.current.set(indx, null);
        this.available.remove(r);
    }

    public synchronized void runnableExit(int indx) {
        if (this.in_destroy) {
            return;
        }
        --this.current_count;
        if (indx < this.min) {
            BasicRunnable runner = this.createNewThread(indx);
            this.available.add(runner);
        } else if (indx <= this.max) {
            this.availIndx.add(indx);
        }
        this.notifyAll();
    }

    public synchronized void releaseRunnable(BasicRunnable run) {
        if (this.in_destroy) {
            return;
        }
        if (run == null) {
            this.logger.log(16, "B3100", "null basic runnable " + run);
            return;
        }
        int indx = run.getId();
        if (indx < this.min) {
            if (!this.available.contains(run)) {
                this.available.addFirst(run);
            }
        } else if (!this.available.contains(run)) {
            this.available.addLast(run);
        }
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ArrayList copy = null;
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            this.in_destroy = true;
            copy = new ArrayList(this.current);
        }
        for (int i = 0; i < copy.size(); ++i) {
            BasicRunnable runner = (BasicRunnable)copy.get(i);
            if (runner == null) continue;
            runner.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitOnDestroy(long timeout) {
        this.destroy();
        ArrayList copy = null;
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            copy = new ArrayList(this.current);
        }
        for (int i = 0; i < copy.size(); ++i) {
            BasicRunnable runner = (BasicRunnable)copy.get(i);
            if (runner == null) continue;
            if (runner.isBusy()) {
                runner.waitOnDestroy(timeout);
            }
            if (runner.isDestroyed() || !runner.isCritical()) continue;
            this.logger.log(16, "B2046", (Object)runner, String.valueOf(timeout));
        }
        this.destroyed = true;
        ThreadPool threadPool2 = this;
        synchronized (threadPool2) {
            this.notifyAll();
        }
    }

    public void handleException(Throwable thr) {
        this.logger.logStack(16, "B3100", "Unexpected Exception or Error", thr);
    }

    public static class MyThreadGroup
    extends ThreadGroup {
        public MyThreadGroup(String name) {
            super(name);
        }

        @Override
        public void uncaughtException(Thread t, Throwable thr) {
            Globals.handleGlobalError(thr, "Unexpected thread pool error");
        }
    }
}

