/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.Status;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolGlobals;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ReplyStatus;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.HashMap;

abstract class ReplyWaiter {
    protected Logger logger = Globals.getLogger();
    protected static final int WAITING = 0;
    protected int waitStatus = 0;
    protected HashMap participants = new HashMap();
    protected HashMap replies = new HashMap();
    private short protocol;
    private static final long DEFAULT_WAIT_INTERVAL = 60000L;

    public ReplyWaiter(BrokerAddress participant, short protocol) {
        this(new BrokerAddress[]{participant}, protocol);
    }

    public ReplyWaiter(BrokerAddress[] brokerList, short protocol) {
        for (int i = 0; i < brokerList.length; ++i) {
            this.participants.put(brokerList[i], "");
        }
        this.protocol = protocol;
    }

    public synchronized int getWaitStatus() {
        return this.waitStatus;
    }

    public synchronized void setWaitStatus(int s) {
        this.waitStatus = s;
        this.notifyAll();
    }

    private synchronized String currentParticipants() {
        StringBuilder cp = new StringBuilder("");
        for (BrokerAddress addr : this.participants.keySet()) {
            cp.append("\n\t" + addr.toString());
        }
        return cp.toString();
    }

    public synchronized ReplyStatus waitForReply(int timeout) throws BrokerException {
        long endtime = System.currentTimeMillis() + (long)timeout * 1000L;
        long waittime = (long)timeout * 1000L;
        if (waittime > 60000L) {
            waittime = 60000L;
        }
        int loglevel = 1;
        int i = 0;
        while (this.waitStatus == 0) {
            try {
                Object[] args = new Object[]{i++, ProtocolGlobals.getPacketTypeDisplayString(this.protocol), this.currentParticipants()};
                this.logger.log(loglevel, Globals.getBrokerResources().getKTString("B1174", args));
                this.wait(waittime);
            }
            catch (Exception args) {
                // empty catch block
            }
            long curtime = System.currentTimeMillis();
            if (curtime >= endtime) {
                if (this.waitStatus != 0) continue;
                this.waitStatus = 408;
                continue;
            }
            waittime = endtime - curtime;
            if (waittime > 60000L) {
                waittime = 60000L;
            }
            loglevel = 8;
        }
        if (this.waitStatus == 200) {
            return this.getReply();
        }
        throw new BrokerException(Status.getString(this.waitStatus), this.waitStatus);
    }

    public synchronized void abort() {
        if (this.waitStatus != 0) {
            return;
        }
        this.waitStatus = 200;
        this.notifyAll();
    }

    public synchronized void notifyReply(BrokerAddress from, GPacket reply) {
        if (this.participants.remove(from) != null) {
            this.replies.put(from, new ReplyStatus(reply));
            this.onReply(from, reply);
        }
    }

    public synchronized void addParticipant(BrokerAddress remote) {
        this.onAddParticipant(remote);
    }

    public synchronized void removeParticipant(BrokerAddress remote, boolean goodbyed, boolean shutdown) {
        if (this.waitStatus != 0) {
            return;
        }
        this.onRemoveParticipant(remote, goodbyed, shutdown);
    }

    public abstract void onReply(BrokerAddress var1, GPacket var2);

    public abstract void onAddParticipant(BrokerAddress var1);

    public abstract void onRemoveParticipant(BrokerAddress var1, boolean var2, boolean var3);

    public abstract ReplyStatus getReply();
}

