/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class ClusterTxnInfoInfo {
    protected Logger logger = Globals.getLogger();
    private Long transactionID = null;
    private int transactionState;
    private BrokerAddress[] brokers;
    private BrokerAddress[] waitfor;
    private BrokerAddress txnHome;
    private UID msgStoreSession = null;
    private boolean owner = false;
    private Cluster c = null;
    private Long xid = null;
    private GPacket pkt = null;

    private ClusterTxnInfoInfo(Long txnID, int txnState, BrokerAddress[] brokers, BrokerAddress[] waitfor, BrokerAddress txnHome, boolean owner, UID msgStoreSession, Cluster c, Long xid) {
        this.transactionID = txnID;
        this.transactionState = txnState;
        this.brokers = brokers;
        this.waitfor = waitfor;
        this.txnHome = txnHome;
        this.msgStoreSession = msgStoreSession;
        this.owner = owner;
        this.c = c;
        this.xid = xid;
    }

    private ClusterTxnInfoInfo(GPacket pkt, Cluster c) {
        this.pkt = pkt;
        this.c = c;
    }

    public static ClusterTxnInfoInfo newInstance(Long txnID, int txnState, BrokerAddress[] brokers, BrokerAddress[] waitfor, BrokerAddress txnHome, boolean owner, UID msgStoreSession, Cluster c, Long xid) {
        return new ClusterTxnInfoInfo(txnID, txnState, brokers, waitfor, txnHome, owner, msgStoreSession, c, xid);
    }

    public static ClusterTxnInfoInfo newInstance(GPacket pkt, Cluster c) {
        return new ClusterTxnInfoInfo(pkt, c);
    }

    public GPacket getGPacket() throws IOException {
        int i;
        StringBuilder buf;
        GPacket gp = GPacket.getInstance();
        gp.setType((short)48);
        gp.putProp("transactionID", this.transactionID);
        gp.putProp("transactionState", this.transactionState);
        if (this.owner) {
            gp.putProp("owner", Boolean.TRUE);
            this.c.marshalBrokerAddress(this.c.getSelfAddress(), gp);
        }
        if (this.msgStoreSession != null) {
            gp.putProp("messageStoreSession", this.msgStoreSession.longValue());
        }
        if (this.brokers != null) {
            buf = new StringBuilder();
            for (i = 0; i < this.brokers.length; ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(this.brokers[i].toProtocolString());
            }
            gp.putProp("brokers", buf.toString());
        }
        if (this.waitfor != null) {
            buf = new StringBuilder();
            for (i = 0; i < this.waitfor.length; ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(this.waitfor[i].toProtocolString());
            }
            gp.putProp("waitfor", buf.toString());
        }
        if (this.txnHome != null) {
            gp.putProp("transactionHome", this.txnHome.toProtocolString());
        }
        if (this.xid != null) {
            gp.putProp("X", this.xid);
        }
        gp.setBit(1, false);
        return gp;
    }

    public boolean isOwner() {
        assert (this.pkt != null);
        Boolean b = (Boolean)this.pkt.getProp("owner");
        if (b == null) {
            return false;
        }
        return b;
    }

    public BrokerAddress getOwnerBrokerAddress() throws Exception {
        assert (this.pkt != null);
        if (!this.isOwner()) {
            return null;
        }
        return this.c.unmarshalBrokerAddress(this.pkt);
    }

    public int getTransactionState() {
        assert (this.pkt != null);
        return (Integer)this.pkt.getProp("transactionState");
    }

    public Long getTransactionID() {
        assert (this.pkt != null);
        return (Long)this.pkt.getProp("transactionID");
    }

    public UID getMessageStoreSessionUID() {
        assert (this.pkt != null);
        Long ssid = (Long)this.pkt.getProp("messageStoreSession");
        if (ssid == null) {
            return null;
        }
        return new UID(ssid);
    }

    public List getWaitfor() throws Exception {
        assert (this.pkt != null);
        String w = (String)this.pkt.getProp("waitfor");
        if (w == null) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(w, ",", false);
        ArrayList<BrokerAddress> bas = new ArrayList<BrokerAddress>();
        String b = null;
        while (tokens.hasMoreElements()) {
            b = (String)tokens.nextElement();
            bas.add(Globals.getMyAddress().fromProtocolString(b));
        }
        return bas;
    }

    public boolean isWaitedfor(BrokerAddress me) throws Exception {
        List waitfor = this.getWaitfor();
        if (waitfor == null) {
            return false;
        }
        TransactionBroker tb = null;
        Iterator itr = waitfor.iterator();
        while (itr.hasNext()) {
            tb = new TransactionBroker((BrokerAddress)itr.next());
            if (!tb.getCurrentBrokerAddress().equals(me)) continue;
            return true;
        }
        return false;
    }

    public BrokerAddress[] getBrokers() throws Exception {
        assert (this.pkt != null);
        String p = (String)this.pkt.getProp("brokers");
        if (p == null) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(p, ",", false);
        ArrayList<BrokerAddress> bas = new ArrayList<BrokerAddress>();
        String b = null;
        while (tokens.hasMoreElements()) {
            b = (String)tokens.nextElement();
            bas.add(Globals.getMyAddress().fromProtocolString(b));
        }
        return bas.toArray(new BrokerAddress[bas.size()]);
    }

    public BrokerAddress getTransactionHome() {
        assert (this.pkt != null);
        String b = (String)this.pkt.getProp("transactionHome");
        if (b == null) {
            return null;
        }
        try {
            return Globals.getMyAddress().fromProtocolString(b);
        }
        catch (Exception e) {
            Logger logger = Globals.getLogger();
            Globals.getLogger();
            logger.log(16, "Unable to get transaction home broker address for TID=" + this.getTransactionID() + ":" + e.getMessage());
            return null;
        }
    }

    public String toString() {
        if (this.pkt == null) {
            int i;
            StringBuilder bf;
            StringBuilder buf = new StringBuilder();
            buf.append("\n\tTransactionID = ").append(this.transactionID);
            buf.append("\n\tTransactionState = ").append(TransactionState.toString(this.transactionState));
            if (this.txnHome != null) {
                buf.append("\n\tTransactionHome = ").append(this.txnHome);
            }
            if (this.brokers != null) {
                bf = new StringBuilder();
                for (i = 0; i < this.brokers.length; ++i) {
                    if (i > 0) {
                        bf.append(',');
                    }
                    bf.append(this.brokers[i].toProtocolString());
                }
                buf.append("\n\tBrokers = ").append(bf.toString());
            }
            if (this.waitfor != null) {
                bf = new StringBuilder();
                for (i = 0; i < this.waitfor.length; ++i) {
                    if (i > 0) {
                        bf.append(',');
                    }
                    bf.append(this.waitfor[i].toProtocolString());
                }
                buf.append("\n\tWaitfor = ").append(bf.toString());
            }
            if (this.xid != null) {
                buf.append("\n\tXID = ").append(this.xid);
            }
            buf.append('\n');
            return buf.toString();
        }
        StringBuilder buf = new StringBuilder();
        buf.append("\n\tTransactionID = ").append(this.getTransactionID());
        buf.append("\n\tTransactionState = ").append(TransactionState.toString(this.getTransactionState()));
        try {
            BrokerAddress b = this.getTransactionHome();
            if (b != null) {
                buf.append("\n\tTransactionHome = ").append(b);
            }
        }
        catch (Exception e) {
            buf.append("\n\tTransactionHome = ERROR:").append(e.toString());
        }
        BrokerAddress[] bas = null;
        try {
            bas = this.getBrokers();
            if (bas != null) {
                StringBuilder bf = new StringBuilder();
                for (int i = 0; i < bas.length; ++i) {
                    if (i > 0) {
                        bf.append(',');
                    }
                    bf.append(bas[i].toProtocolString());
                }
                buf.append("\n\tBrokers = ").append(bf.toString());
            }
        }
        catch (Exception e) {
            buf.append("\n\tBrokers = ERROR:").append(e.toString());
        }
        try {
            List wbas = this.getWaitfor();
            if (wbas != null) {
                Iterator itr = wbas.iterator();
                StringBuilder bf = new StringBuilder();
                int i = 0;
                while (itr.hasNext()) {
                    if (i > 0) {
                        bf.append(',');
                    }
                    bf.append(((BrokerAddress)itr.next()).toProtocolString());
                    ++i;
                }
                buf.append("\n\tWaitfor = ").append(bf.toString());
            }
        }
        catch (Exception e) {
            buf.append("\n\tWaitfor = ERROR:").append(e.toString());
        }
        if (this.pkt.getProp("X") != null) {
            buf.append("\n\tXID = ").append(this.pkt.getProp("X"));
        }
        buf.append('\n');
        return buf.toString();
    }
}

