/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.probe;

import jakarta.enterprise.event.Reception;
import jakarta.enterprise.event.TransactionPhase;
import jakarta.enterprise.inject.Vetoed;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.ObserverMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.event.ObserverMethodImpl;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.probe.Components;
import org.jboss.weld.probe.EventInfo;
import org.jboss.weld.probe.Invocation;
import org.jboss.weld.probe.Probe;
import org.jboss.weld.probe.ProbeLogger;

@Vetoed
final class Queries {
    static final int DEFAULT_PAGE_SIZE = 50;

    private Queries() {
    }

    static <T, F extends Filters<T>> Page<T> find(List<T> data, int page, int pageSize, F filters) {
        if (filters != null && !filters.isEmpty()) {
            ProbeLogger.LOG.filtersApplied(filters);
            Iterator<T> iterator = data.iterator();
            while (iterator.hasNext()) {
                T element = iterator.next();
                if (filters.test(element)) continue;
                iterator.remove();
            }
        }
        if (pageSize == 0) {
            return new Page<T>(page, 1, data.size(), data);
        }
        if (data.isEmpty()) {
            return new Page(0, 0, 0, Collections.emptyList());
        }
        if (page <= 0 || page > 1 && (page - 1) * pageSize >= data.size()) {
            page = 1;
        }
        int lastIdx = data.size() / pageSize;
        if (data.size() % pageSize > 0) {
            ++lastIdx;
        }
        if (lastIdx == 1) {
            return new Page<T>(1, lastIdx, data.size(), data);
        }
        int start = (page - 1) * pageSize;
        int end = start + pageSize;
        if (end > data.size()) {
            end = data.size();
        }
        return new Page<T>(page, lastIdx, data.size(), data.subList(start, end));
    }

    static <E, T extends Filters<E>> T initFilters(String filtersParam, T uninitializedFilters) {
        if (filtersParam == null || filtersParam.trim().length() == 0) {
            return null;
        }
        uninitializedFilters.initialize(filtersParam);
        return uninitializedFilters;
    }

    static class EventsFilters
    extends Filters<EventInfo> {
        private Boolean container;
        private String eventInfo;
        private String type;
        private String qualifiers;

        EventsFilters(Probe probe) {
            super(probe);
        }

        @Override
        boolean test(EventInfo event) {
            return this.testContainsIgnoreCase(this.eventInfo, event.getEventString()) && this.testContainsIgnoreCase(this.type, event.getType()) && this.testAnyContains(this.qualifiers, event.getQualifiers()) && (this.container == null || this.container.booleanValue() == event.isContainerEvent());
        }

        @Override
        void processFilter(String name, String value) {
            if ("eventInfo".equals(name)) {
                this.eventInfo = value;
            } else if ("type".equals(name)) {
                this.type = value;
            } else if ("qualifiers".equals(name)) {
                this.qualifiers = value;
            } else if ("kind".equals(name)) {
                if ("container".equalsIgnoreCase(value)) {
                    this.container = true;
                } else if ("application".equalsIgnoreCase(value)) {
                    this.container = false;
                }
            }
        }

        public String toString() {
            return String.format("EventsFilters [container=%s, eventInfo=%s, type=%s, qualifiers=%s]", this.container, this.eventInfo, this.type, this.qualifiers);
        }

        @Override
        boolean isEmpty() {
            return this.container == null && this.eventInfo == null && this.type == null && this.qualifiers == null;
        }
    }

    static class InvocationsFilters
    extends Filters<Invocation> {
        private String beanClass;
        private String methodName;
        private String search;
        private String description;

        InvocationsFilters(Probe probe) {
            super(probe);
        }

        @Override
        boolean test(Invocation invocation) {
            return this.testSearch(this.search, invocation) && this.testContainsIgnoreCase(this.beanClass, invocation.getBeanClass()) && this.testContainsIgnoreCase(this.methodName, invocation.getMethodName()) && this.testContainsIgnoreCase(this.description, invocation.getDescription());
        }

        @Override
        void processFilter(String name, String value) {
            if ("beanClass".equals(name)) {
                this.beanClass = value;
            } else if ("methodName".equals(name)) {
                this.methodName = value;
            } else if ("search".equals(name)) {
                this.search = value;
            } else if ("description".equals(name)) {
                this.description = value;
            }
        }

        boolean testSearch(String search, Invocation invocation) {
            if (search == null) {
                return true;
            }
            if (this.containsIgnoreCase(search, invocation.getBeanClass()) || this.containsIgnoreCase(search, invocation.getMethodName())) {
                return true;
            }
            if (invocation.hasChildren()) {
                for (Invocation child : invocation.getChildren()) {
                    if (!this.testSearch(search, child)) continue;
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return String.format("InvocationsFilters [beanClass=%s, methodName=%s, search=%s, description=%s]", this.beanClass, this.methodName, this.search, this.description);
        }

        @Override
        boolean isEmpty() {
            return this.beanClass == null && this.methodName == null && this.search == null && this.description == null;
        }
    }

    static class ObserverFilters
    extends Filters<ObserverMethod<?>> {
        private String beanClass;
        private String observedType;
        private String qualifier;
        private Reception reception;
        private TransactionPhase txPhase;
        private Components.BeanKind declaringBeanKind;
        private String bda;

        ObserverFilters(Probe probe) {
            super(probe);
        }

        ObserverFilters(Probe probe, String observedType, String bda) {
            super(probe);
            this.observedType = observedType;
            this.bda = bda;
        }

        @Override
        boolean test(ObserverMethod<?> observer) {
            RIBean declaringBean = observer instanceof ObserverMethodImpl ? ((ObserverMethodImpl)observer).getDeclaringBean() : null;
            return this.testBda(this.bda, declaringBean) && this.testEquals((Object)this.declaringBeanKind, (Object)Components.BeanKind.from(declaringBean)) && this.testEquals((Object)this.reception, (Object)observer.getReception()) && this.testEquals((Object)this.txPhase, (Object)observer.getTransactionPhase()) && this.testContainsIgnoreCase(this.beanClass, observer.getBeanClass()) && this.testContainsIgnoreCase(this.observedType, observer.getObservedType()) && this.testAnyContains(this.qualifier, observer.getObservedQualifiers());
        }

        @Override
        void processFilter(String name, String value) {
            if ("kind".equals(name)) {
                this.declaringBeanKind = Components.BeanKind.from(value);
            } else if ("beanClass".equals(name)) {
                this.beanClass = value;
            } else if ("observedType".equals(name)) {
                this.observedType = value;
            } else if ("qualifier".equals(name)) {
                this.qualifier = value;
            } else if ("reception".equals(name)) {
                for (Reception recept : Reception.values()) {
                    if (!recept.toString().equals(value)) continue;
                    this.reception = recept;
                }
            } else if ("txPhase".equals(name)) {
                for (TransactionPhase phase : TransactionPhase.values()) {
                    if (!phase.toString().equals(value)) continue;
                    this.txPhase = phase;
                }
            } else if ("bda".equals(name)) {
                this.bda = value;
            }
        }

        public String toString() {
            return String.format("ObserverFilters [beanClass=%s, observedType=%s, qualifier=%s, reception=%s, txPhase=%s, declaringBeanKind=%s, bda=%s]", new Object[]{this.beanClass, this.observedType, this.qualifier, this.reception, this.txPhase, this.declaringBeanKind, this.bda});
        }

        @Override
        boolean isEmpty() {
            return this.beanClass == null && this.observedType == null && this.qualifier == null && this.reception == null && this.bda == null && this.txPhase == null && this.declaringBeanKind == null;
        }
    }

    static class BeanFilters
    extends Filters<Bean<?>> {
        private Components.BeanKind kind;
        private String beanClass;
        private String beanType;
        private String qualifier;
        private String scope;
        private String bda;
        private Boolean isAlternative;
        private String stereotypes;
        private boolean unused;

        BeanFilters(Probe probe) {
            super(probe);
        }

        BeanFilters(Probe probe, String bda) {
            super(probe);
            this.bda = bda;
        }

        @Override
        public boolean test(Bean<?> bean) {
            return this.testBda(this.bda, bean) && this.testEquals((Object)this.kind, (Object)Components.BeanKind.from(bean)) && this.testContainsIgnoreCase(this.beanClass, bean.getBeanClass()) && this.testContainsIgnoreCase(this.scope, bean.getScope()) && this.testAnyContains(this.beanType, bean.getTypes()) && this.testAnyContains(this.qualifier, bean.getQualifiers()) && this.testEquals(this.isAlternative, bean.isAlternative()) && this.testAnyContains(this.stereotypes, bean.getStereotypes()) && this.testUnused(bean);
        }

        boolean testUnused(Bean<?> bean) {
            return !this.unused || this.probe.isUnused(bean);
        }

        @Override
        void processFilter(String name, String value) {
            if ("kind".equals(name)) {
                this.kind = Components.BeanKind.from(value);
            } else if ("beanClass".equals(name)) {
                this.beanClass = value;
            } else if ("beanType".equals(name)) {
                this.beanType = value;
            } else if ("qualifier".equals(name)) {
                this.qualifier = value;
            } else if ("scope".equals(name)) {
                this.scope = value;
            } else if ("bda".equals(name)) {
                this.bda = value;
            } else if ("isAlternative".equals(name)) {
                this.isAlternative = Boolean.valueOf(value);
            } else if ("stereotypes".equals(name)) {
                this.stereotypes = value;
            } else if ("unused".equals(name) && Boolean.valueOf(value).booleanValue()) {
                this.unused = true;
            }
        }

        public String toString() {
            return String.format("BeanFilters [kind=%s, beanClass=%s, beanType=%s, qualifier=%s, scope=%s, bda=%s, isAlternative=%s, stereotypes=%s, unused=%s]", new Object[]{this.kind, this.beanClass, this.beanType, this.qualifier, this.scope, this.bda, this.isAlternative, this.stereotypes, this.unused});
        }

        @Override
        boolean isEmpty() {
            return this.kind == null && this.beanClass == null && this.beanType == null && this.qualifier == null && this.scope == null && this.bda == null && this.isAlternative == null && this.stereotypes == null && !this.unused;
        }
    }

    static abstract class Filters<T> {
        private static final char PAIR_SEPARATOR = ' ';
        private static final char KEY_VALUE_SEPARATOR = ':';
        private static final char VALUE_QUOTE = '\"';
        static final String FILTER_ADDITIONAL_BDAS_MARKER = "probe-filterAdditionalBdas";
        protected final Probe probe;

        static Map<String, String> parseFilters(String filters) {
            ArrayList<String> pairs = new ArrayList<String>();
            boolean inSeparator = false;
            boolean inValueLiteral = false;
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < filters.length(); ++i) {
                if (filters.charAt(i) == ' ') {
                    if (inSeparator) continue;
                    if (!inValueLiteral) {
                        if (buffer.length() > 0) {
                            pairs.add(buffer.toString());
                            buffer = new StringBuilder();
                        }
                        inSeparator = true;
                        continue;
                    }
                    buffer.append(filters.charAt(i));
                    continue;
                }
                if (filters.charAt(i) == '\"' && (i == 0 || filters.charAt(i - 1) == ':' || i + 1 >= filters.length() || filters.charAt(i + 1) == ' ')) {
                    inValueLiteral = !inValueLiteral;
                }
                inSeparator = false;
                buffer.append(filters.charAt(i));
            }
            if (buffer.length() > 0) {
                if (inValueLiteral) {
                    throw ProbeLogger.LOG.unableToParseQueryFilter(filters);
                }
                pairs.add(buffer.toString());
            }
            HashMap<String, String> map = new HashMap<String, String>();
            for (String pair : pairs) {
                int separator;
                if (pair.length() == 0 || (separator = pair.indexOf(58)) == -1) continue;
                String key = pair.substring(0, separator);
                String value = pair.substring(separator + 1, pair.length());
                map.put(key, value.substring(1, value.length() - 1));
            }
            return map;
        }

        public Filters(Probe probe) {
            this.probe = probe;
        }

        void initialize(String filters) {
            for (Map.Entry<String, String> entry : Filters.parseFilters(filters).entrySet()) {
                this.processFilter(entry.getKey(), entry.getValue());
            }
        }

        abstract boolean test(T var1);

        abstract void processFilter(String var1, String var2);

        boolean testEquals(Object filter, Object value) {
            return filter == null || filter.equals(value);
        }

        boolean testContainsIgnoreCase(String filter, Object value) {
            return filter == null || this.containsIgnoreCase(filter, value);
        }

        boolean testAnyContains(String filter, Collection<?> values) {
            if (filter == null) {
                return true;
            }
            for (Object value : values) {
                if (!this.testContainsIgnoreCase(filter, value)) continue;
                return true;
            }
            return false;
        }

        boolean testBda(String bda, Bean<?> bean) {
            if (bda == null) {
                return true;
            }
            if (bean == null) {
                return false;
            }
            BeanManagerImpl beanManagerImpl = this.probe.getBeanManager(bean);
            if (beanManagerImpl == null) {
                return false;
            }
            return !(FILTER_ADDITIONAL_BDAS_MARKER.equals(bda) ? beanManagerImpl.getId().endsWith(".additionalClasses") : !Components.getId(beanManagerImpl.getId()).equals(bda));
        }

        boolean containsIgnoreCase(String filter, Object value) {
            return value.toString().toLowerCase().contains(this.prepareFilter(filter).toLowerCase());
        }

        private String prepareFilter(String filter) {
            return filter.startsWith("@") ? filter.substring(1, filter.length()) : filter;
        }

        abstract boolean isEmpty();
    }

    static class Page<T> {
        private final int idx;
        private final int lastIdx;
        private final int total;
        private final List<T> data;

        Page(int idx, int lastIdx, int total, List<T> data) {
            this.idx = idx;
            this.lastIdx = lastIdx;
            this.total = total;
            this.data = data;
        }

        int getIdx() {
            return this.idx;
        }

        int getLastIdx() {
            return this.lastIdx;
        }

        int getTotal() {
            return this.total;
        }

        List<T> getData() {
            return this.data;
        }
    }
}

