/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.probe;

import jakarta.enterprise.context.BeforeDestroyed;
import jakarta.enterprise.context.Destroyed;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.event.Reception;
import jakarta.enterprise.event.TransactionPhase;
import jakarta.enterprise.inject.Vetoed;
import jakarta.enterprise.inject.spi.EventMetadata;
import jakarta.enterprise.inject.spi.ObserverMethod;
import jakarta.enterprise.inject.spi.Prioritized;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jboss.weld.event.CurrentEventMetadata;
import org.jboss.weld.event.ObserverNotifier;
import org.jboss.weld.event.ResolvedObservers;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.probe.EventInfo;
import org.jboss.weld.probe.Probe;
import org.jboss.weld.probe.ProbeExtension;
import org.jboss.weld.probe.ProbeLogger;
import org.jboss.weld.util.collections.ImmutableList;
import org.jboss.weld.util.reflection.Formats;

@Vetoed
class ProbeObserver
implements ObserverMethod<Object>,
Prioritized {
    private static final int PRIORITY_OFFSET = 100;
    private final Pattern excludePattern;
    private final Probe probe;
    private final CurrentEventMetadata currentEventMetadata;
    private final BeanManagerImpl manager;

    ProbeObserver(BeanManagerImpl manager, Pattern excludePattern, Probe probe) {
        this.currentEventMetadata = manager.getServices().get(CurrentEventMetadata.class);
        this.manager = manager;
        this.excludePattern = excludePattern;
        this.probe = probe;
    }

    @Override
    public Class<?> getBeanClass() {
        return ProbeExtension.class;
    }

    @Override
    public Type getObservedType() {
        return Object.class;
    }

    @Override
    public Set<Annotation> getObservedQualifiers() {
        return Collections.emptySet();
    }

    @Override
    public Reception getReception() {
        return Reception.ALWAYS;
    }

    @Override
    public TransactionPhase getTransactionPhase() {
        return TransactionPhase.IN_PROGRESS;
    }

    @Override
    public void notify(Object event) {
        EventMetadata metadata = (EventMetadata)this.currentEventMetadata.peek();
        if (this.excludePattern != null && this.excludePattern.matcher(Formats.formatType(metadata.getType(), false)).matches()) {
            ProbeLogger.LOG.eventExcluded(metadata.getType());
            return;
        }
        boolean containerEvent = this.isContainerEvent(metadata.getQualifiers());
        List<ObserverMethod<?>> observers = this.resolveObservers(metadata, containerEvent);
        EventInfo info = new EventInfo(metadata.getType(), metadata.getQualifiers(), event, metadata.getInjectionPoint(), observers, containerEvent, System.currentTimeMillis());
        this.probe.addEvent(info);
    }

    private List<ObserverMethod<?>> resolveObservers(EventMetadata metadata, boolean containerEvent) {
        ArrayList observers = new ArrayList();
        ObserverNotifier notifier = containerEvent ? this.manager.getAccessibleLenientObserverNotifier() : this.manager.getGlobalLenientObserverNotifier();
        ResolvedObservers resolvedObservers = notifier.resolveObserverMethods(metadata.getType(), metadata.getQualifiers());
        for (ObserverMethod observer : resolvedObservers.getAllObservers()) {
            if (this.getBeanClass() == observer.getBeanClass()) continue;
            observers.add(observer);
        }
        return ImmutableList.copyOf(observers);
    }

    @Override
    public int getPriority() {
        return 100;
    }

    private boolean isContainerEvent(Set<Annotation> qualifiers) {
        for (Annotation annotation : qualifiers) {
            if (annotation.annotationType() != Initialized.class && annotation.annotationType() != Destroyed.class && annotation.annotationType() != BeforeDestroyed.class) continue;
            return true;
        }
        return false;
    }
}

