/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.deployment.discovery.jandex;

import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.security.ConstructorNewInstanceAction;
import org.jboss.weld.security.NewInstanceAction;

final class SecurityActions {
    private SecurityActions() {
    }

    static <T> T newInstance(Class<T> javaClass) throws InstantiationException, IllegalAccessException {
        if (System.getSecurityManager() != null) {
            try {
                return AccessController.doPrivileged(NewInstanceAction.of(javaClass));
            }
            catch (PrivilegedActionException e) {
                throw new WeldException(e.getCause());
            }
        }
        return javaClass.newInstance();
    }

    static <T> T newConstructorInstance(Class<T> javaClass, Class<?>[] constructorParamTypes, Object ... constructorParamInstances) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (System.getSecurityManager() != null) {
            try {
                return AccessController.doPrivileged(ConstructorNewInstanceAction.of(javaClass, constructorParamTypes, constructorParamInstances));
            }
            catch (PrivilegedActionException e) {
                throw new WeldException(e.getCause());
            }
        }
        return javaClass.getConstructor(constructorParamTypes).newInstance(constructorParamInstances);
    }
}

