/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanAttributes;
import org.jboss.weld.bean.ForwardingBean;
import org.jboss.weld.bean.ForwardingDecorator;
import org.jboss.weld.bean.ForwardingInterceptor;
import org.jboss.weld.bean.WeldBean;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.util.bean.ForwardingBeanAttributes;
import org.jboss.weld.util.reflection.Reflections;

public abstract class CommonBean<T>
extends ForwardingBeanAttributes<T>
implements Bean<T>,
WeldBean<T> {
    private volatile BeanAttributes<T> attributes;
    private final BeanIdentifier identifier;

    protected CommonBean(BeanAttributes<T> attributes, BeanIdentifier identifier) {
        this.attributes = attributes;
        this.identifier = identifier;
    }

    protected Object unwrap(Object object) {
        if (object instanceof ForwardingBean) {
            return ((ForwardingBean)Reflections.cast(object)).delegate();
        }
        if (object instanceof ForwardingInterceptor) {
            return ((ForwardingInterceptor)Reflections.cast(object)).delegate();
        }
        if (object instanceof ForwardingDecorator) {
            return ((ForwardingDecorator)Reflections.cast(object)).delegate();
        }
        return object;
    }

    @Override
    public boolean equals(Object obj) {
        Object object = this.unwrap(obj);
        if (this == obj) {
            return true;
        }
        if (object instanceof CommonBean) {
            CommonBean that = (CommonBean)object;
            return this.getIdentifier().equals(that.getIdentifier());
        }
        return false;
    }

    @Override
    protected BeanAttributes<T> attributes() {
        return this.attributes;
    }

    public void setAttributes(BeanAttributes<T> attributes) {
        this.attributes = attributes;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public int hashCode() {
        return this.identifier.hashCode();
    }

    public String getId() {
        return this.identifier.asString();
    }

    @Override
    public BeanIdentifier getIdentifier() {
        return this.identifier;
    }

    public String toString() {
        return this.getId();
    }
}

