/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.services.impl;

import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.spi.services.IBatchArtifactFactory;
import com.ibm.jbatch.spi.services.IBatchConfig;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.inject.se.SeContainer;
import jakarta.enterprise.inject.se.SeContainerInitializer;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Named;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;

@Named(value="MyWeldBean")
public class WeldSEBatchArtifactFactoryImpl
implements IBatchArtifactFactory {
    private static final Logger logger = Logger.getLogger(WeldSEBatchArtifactFactoryImpl.class.getName());
    private static final String CLASSNAME = WeldSEBatchArtifactFactoryImpl.class.getName();
    private boolean loaded = false;
    private SeContainer container;

    @Override
    public Object load(String batchId) {
        Object loadedArtifact;
        String methodName = "load";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASSNAME, methodName, "Loading batch artifact id = " + batchId);
        }
        if ((loadedArtifact = this.getArtifactById(batchId)) == null) {
            logger.exiting(CLASSNAME, methodName, "Returning null artifact for id: " + batchId);
            return loadedArtifact;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASSNAME, methodName, "For batch artifact id = " + batchId + ", loaded artifact instance: " + loadedArtifact + " of type: " + loadedArtifact.getClass().getCanonicalName());
        }
        return loadedArtifact;
    }

    private Object getArtifactById(String id) {
        Object artifactInstance = null;
        try {
            BeanManager bm = this.container.getBeanManager();
            Bean bean = bm.resolve(bm.getBeans(id));
            Class clazz = bean.getBeanClass();
            artifactInstance = bm.getReference(bean, (Type)clazz, bm.createCreationalContext((Contextual)bean));
        }
        catch (Exception e) {
            logger.fine("Tried but failed to load artifact with id: " + id + ", Exception = " + e);
        }
        return artifactInstance;
    }

    @Override
    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
        this.container = SeContainerInitializer.newInstance().initialize();
    }

    @Override
    public void shutdown() throws BatchContainerServiceException {
        this.container.close();
    }
}

