/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.Provider;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.glassfish.admin.rest.provider.ProviderUtil;
import org.glassfish.admin.rest.results.GetResultList;
import org.glassfish.admin.rest.utils.DomConfigurator;
import org.glassfish.admin.rest.utils.Util;
import org.jvnet.hk2.config.Dom;

@Provider
@Produces(value={"text/html"})
public class GetResultListHtmlProvider
extends BaseProvider<GetResultList> {
    public GetResultListHtmlProvider() {
        super(GetResultList.class, MediaType.TEXT_HTML_TYPE);
    }

    @Override
    public String getContent(GetResultList proxy) {
        Object result = ProviderUtil.getHtmlHeader(((UriInfo)this.uriInfo.get()).getBaseUri().toASCIIString());
        String typeKey = Util.upperCaseFirstLetter(Util.decode(Util.getName(((UriInfo)this.uriInfo.get()).getPath(), '/')));
        result = (String)result + "<h1>" + typeKey + "</h1>";
        String postCommand = ProviderUtil.getHtmlRespresentationsForCommand(proxy.getMetaData().getMethodMetaData("POST"), "POST", "Create", (UriInfo)this.uriInfo.get());
        result = ProviderUtil.getHtmlForComponent(postCommand, "Create " + typeKey, (String)result);
        String childResourceLinks = this.getResourcesLinks(proxy.getDomList());
        result = ProviderUtil.getHtmlForComponent(childResourceLinks, "Child Resources", (String)result);
        String commandLinks = this.getCommandLinks(proxy.getCommandResourcesPaths());
        result = ProviderUtil.getHtmlForComponent(commandLinks, "Commands", (String)result);
        result = (String)result + "</html></body>";
        return result;
    }

    private String getResourcesLinks(List<Dom> proxyList) {
        StringBuilder result = new StringBuilder("<div>");
        Collections.sort(proxyList, new DomConfigurator());
        for (Map.Entry<String, String> link : this.getResourceLinks(proxyList).entrySet()) {
            result.append("<a href=\"").append(link.getValue()).append("\">").append(link.getKey()).append("</a><br>");
        }
        result.append("</div><br/>");
        return result.toString();
    }

    private String getCommandLinks(String[][] commandResourcesPaths) {
        StringBuilder result = new StringBuilder("<div>");
        for (String[] commandResourcePath : commandResourcesPaths) {
            try {
                result.append("<a href=\"").append(ProviderUtil.getElementLink((UriInfo)this.uriInfo.get(), commandResourcePath[0])).append("\">").append(commandResourcePath[0]).append("</a><br/>");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        result.append("</div><br/>");
        return result.toString();
    }
}

