/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.common.util.logging.LoggingConfigImpl;
import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.AvailabilityService;
import com.sun.enterprise.config.serverbeans.ConfigLoader;
import com.sun.enterprise.config.serverbeans.DiagnosticService;
import com.sun.enterprise.config.serverbeans.GroupManagementService;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.config.serverbeans.LogService;
import com.sun.enterprise.config.serverbeans.MonitoringService;
import com.sun.enterprise.config.serverbeans.RefContainer;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.config.serverbeans.SystemPropertyBag;
import com.sun.enterprise.config.serverbeans.ThreadPools;
import com.sun.enterprise.config.serverbeans.customvalidators.NotDuplicateTargetName;
import com.sun.enterprise.config.serverbeans.customvalidators.NotTargetKeyword;
import com.sun.enterprise.config.util.ServerHelper;
import jakarta.validation.Payload;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.api.admin.config.ConfigExtension;
import org.glassfish.api.admin.config.Container;
import org.glassfish.api.admin.config.Named;
import org.glassfish.api.admin.config.PropertiesDesc;
import org.glassfish.api.admin.config.PropertyDesc;
import org.glassfish.config.support.datatypes.Port;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.glassfish.quality.ToDo;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigExtensionMethod;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.ConfigView;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;
import org.jvnet.hk2.config.types.PropertyBag;

@Configured
@NotDuplicateTargetName(message="{config.duplicate.name}", payload={Config.class})
public interface Config
extends Named,
PropertyBag,
SystemPropertyBag,
Payload,
ConfigLoader,
ConfigBeanProxy,
RefContainer {
    @NotNull
    @NotTargetKeyword(message="{config.reserved.name}", payload={Config.class})
    @Pattern(regexp="[A-Za-z0-9_][A-Za-z0-9\\-_\\.;]*", message="{config.invalid.name}", payload={Config.class})
    public @NotNull @Pattern(regexp="[A-Za-z0-9_][A-Za-z0-9\\-_\\.;]*", message="{config.invalid.name}", payload={Config.class}) String getName();

    public void setName(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="true", dataType=Boolean.class)
    public String getDynamicReconfigurationEnabled();

    public void setDynamicReconfigurationEnabled(String var1) throws PropertyVetoException;

    @Element(required=true)
    public NetworkConfig getNetworkConfig();

    public void setNetworkConfig(NetworkConfig var1) throws PropertyVetoException;

    @Element(required=true)
    public HttpService getHttpService();

    public void setHttpService(HttpService var1) throws PropertyVetoException;

    @Element(required=true)
    public AdminService getAdminService();

    public void setAdminService(AdminService var1) throws PropertyVetoException;

    @Element(required=true)
    public LogService getLogService();

    public void setLogService(LogService var1) throws PropertyVetoException;

    @Element(required=true)
    public SecurityService getSecurityService();

    public void setSecurityService(SecurityService var1) throws PropertyVetoException;

    @Element
    @NotNull
    public MonitoringService getMonitoringService();

    public void setMonitoringService(MonitoringService var1) throws PropertyVetoException;

    @Element
    public DiagnosticService getDiagnosticService();

    public void setDiagnosticService(DiagnosticService var1) throws PropertyVetoException;

    @Element(required=true)
    public JavaConfig getJavaConfig();

    public void setJavaConfig(JavaConfig var1) throws PropertyVetoException;

    @Element
    @NotNull
    public AvailabilityService getAvailabilityService();

    public void setAvailabilityService(AvailabilityService var1) throws PropertyVetoException;

    @Element(required=true)
    public ThreadPools getThreadPools();

    public void setThreadPools(ThreadPools var1) throws PropertyVetoException;

    @Element
    @NotNull
    public GroupManagementService getGroupManagementService();

    public void setGroupManagementService(GroupManagementService var1) throws PropertyVetoException;

    @Override
    @ToDo(priority=ToDo.Priority.IMPORTANT, details="Any more legal system properties?")
    @PropertiesDesc(systemProperties=true, props={@PropertyDesc(name="HTTP_LISTENER_PORT", defaultValue="8080", dataType=Port.class), @PropertyDesc(name="HTTP_SSL_LISTENER_PORT", defaultValue="1043", dataType=Port.class), @PropertyDesc(name="HTTP_ADMIN_LISTENER_PORT", defaultValue="4848", dataType=Port.class), @PropertyDesc(name="IIOP_LISTENER_PORT", defaultValue="3700", dataType=Port.class), @PropertyDesc(name="IIOP_SSL_LISTENER_PORT", defaultValue="1060", dataType=Port.class), @PropertyDesc(name="IIOP_SSL_MUTUALAUTH_PORT", defaultValue="1061", dataType=Port.class), @PropertyDesc(name="JMX_SYSTEM_CONNECTOR_PORT", defaultValue="8686", dataType=Port.class)})
    @Element
    public List<SystemProperty> getSystemProperty();

    @DuckTyped
    public Map<String, String> getLoggingProperties();

    @DuckTyped
    public String setLoggingProperty(String var1, String var2);

    @DuckTyped
    public Map<String, String> updateLoggingProperties(Map<String, String> var1);

    @DuckTyped
    public NetworkListener getAdminListener();

    @DuckTyped
    public <T extends ConfigExtension> T createDefaultChildByType(Class<T> var1);

    @ConfigExtensionMethod
    public <T extends ConfigExtension> T getExtensionByType(Class<T> var1);

    @DuckTyped
    public void addIndex(ServiceLocator var1, String var2);

    @DuckTyped
    public <P extends ConfigExtension> boolean checkIfExtensionExists(Class<P> var1);

    @DuckTyped
    public ResourceRef getResourceRef(String var1);

    @DuckTyped
    public boolean isResourceRefExists(String var1);

    @DuckTyped
    public void createResourceRef(String var1, String var2) throws TransactionFailure;

    @DuckTyped
    public void deleteResourceRef(String var1) throws TransactionFailure;

    @DuckTyped
    public boolean isDas();

    @ToDo(priority=ToDo.Priority.IMPORTANT, details="Provide PropertyDesc for legal props")
    @PropertiesDesc(props={})
    @Element
    public List<Property> getProperty();

    @Element(value="*")
    public List<Container> getContainers();

    @Element(value="*")
    public List<ConfigExtension> getExtensions();

    public static class Duck {
        public static boolean isDas(Config c) {
            try {
                String type = c.getAdminService().getType();
                if (type != null && (type.equals("das") || type.equals("das-and-server"))) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }

        public static String setLoggingProperty(Config c, String property, String value) {
            ConfigBean cb = (ConfigBean)((ConfigView)Proxy.getInvocationHandler(c)).getMasterView();
            ServerEnvironmentImpl env = (ServerEnvironmentImpl)cb.getHabitat().getService(ServerEnvironmentImpl.class, new Annotation[0]);
            LoggingConfigImpl loggingConfig = new LoggingConfigImpl();
            loggingConfig.setupConfigDir(env.getConfigDirPath(), env.getLibPath());
            String prop = null;
            try {
                prop = loggingConfig.setLoggingProperty(property, value);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return prop;
        }

        public static Map<String, String> getLoggingProperties(Config c) {
            ConfigBean cb = (ConfigBean)((ConfigView)Proxy.getInvocationHandler(c)).getMasterView();
            ServerEnvironmentImpl env = (ServerEnvironmentImpl)cb.getHabitat().getService(ServerEnvironmentImpl.class, new Annotation[0]);
            LoggingConfigImpl loggingConfig = new LoggingConfigImpl();
            loggingConfig.setupConfigDir(env.getConfigDirPath(), env.getLibPath());
            HashMap<String, String> map = new HashMap();
            try {
                map = loggingConfig.getLoggingProperties();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return map;
        }

        public static Map<String, String> updateLoggingProperties(Config c, Map<String, String> properties) {
            ConfigBean cb = (ConfigBean)((ConfigView)Proxy.getInvocationHandler(c)).getMasterView();
            ServerEnvironmentImpl env = (ServerEnvironmentImpl)cb.getHabitat().getService(ServerEnvironmentImpl.class, new Annotation[0]);
            LoggingConfigImpl loggingConfig = new LoggingConfigImpl();
            loggingConfig.setupConfigDir(env.getConfigDirPath(), env.getLibPath());
            Map<String, String> map = new HashMap<String, String>();
            try {
                map = loggingConfig.updateLoggingProperties(properties);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return map;
        }

        public static NetworkListener getAdminListener(Config c) {
            return ServerHelper.getAdminListener(c);
        }

        public static void addIndex(Config c, ServiceLocator habitat, String name) {
            ServiceLocatorUtilities.addOneDescriptor((ServiceLocator)habitat, (Descriptor)BuilderHelper.createConstantDescriptor((Object)c, (String)name, (Type[])new Type[]{Config.class}));
            ConfigBeanProxy[] dirref = new ConfigBeanProxy[]{c.getAdminService(), c.getAvailabilityService(), c.getDiagnosticService(), c.getHttpService(), c.getJavaConfig(), c.getLogService(), c.getNetworkConfig(), c.getSecurityService(), c.getThreadPools(), c.getMonitoringService()};
            for (ConfigBeanProxy cbp : dirref) {
                if (cbp == null) continue;
                ServiceLocatorUtilities.addOneDescriptor((ServiceLocator)habitat, (Descriptor)BuilderHelper.createConstantDescriptor((Object)cbp, (String)name, (Type[])new Type[]{ConfigSupport.getImpl((ConfigBeanProxy)cbp).getProxyType()}));
            }
            for (Container extension : c.getContainers()) {
                ServiceLocatorUtilities.addOneDescriptor((ServiceLocator)habitat, (Descriptor)BuilderHelper.createConstantDescriptor((Object)extension, (String)name, (Type[])new Type[]{ConfigSupport.getImpl((ConfigBeanProxy)extension).getProxyType()}));
            }
        }

        public static <P extends ConfigExtension> boolean checkIfExtensionExists(Config c, Class<P> configBeanType) {
            for (ConfigExtension extension : c.getExtensions()) {
                try {
                    configBeanType.cast(extension);
                    return true;
                }
                catch (Exception exception) {
                }
            }
            return false;
        }

        public static void createResourceRef(Config config, final String enabled, final String refName) throws TransactionFailure {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Config>(){

                public Object run(Config param) throws PropertyVetoException, TransactionFailure {
                    ResourceRef newResourceRef = (ResourceRef)param.createChild(ResourceRef.class);
                    newResourceRef.setEnabled(enabled);
                    newResourceRef.setRef(refName);
                    param.getResourceRef().add(newResourceRef);
                    return newResourceRef;
                }
            }, (ConfigBeanProxy)config);
        }

        public static ResourceRef getResourceRef(Config config, String refName) {
            for (ResourceRef ref : config.getResourceRef()) {
                if (!ref.getRef().equals(refName)) continue;
                return ref;
            }
            return null;
        }

        public static boolean isResourceRefExists(Config config, String refName) {
            return Duck.getResourceRef(config, refName) != null;
        }

        public static void deleteResourceRef(Config config, String refName) throws TransactionFailure {
            final ResourceRef ref = Duck.getResourceRef(config, refName);
            if (ref != null) {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Config>(){

                    public Object run(Config param) {
                        return param.getResourceRef().remove(ref);
                    }
                }, (ConfigBeanProxy)config);
            }
        }
    }
}

