/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.webservices;

import com.sun.enterprise.security.jmac.provider.PacketMapMessageInfo;
import com.sun.enterprise.security.jmac.provider.PacketMessageInfo;
import com.sun.enterprise.security.jmac.provider.config.PipeHelper;
import com.sun.enterprise.security.webservices.LogUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.PipeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterPipeImpl;
import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.config.ServerAuthContext;
import jakarta.xml.ws.WebServiceException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;

public class CommonServerSecurityPipe
extends AbstractFilterPipeImpl {
    protected static final Logger _logger = LogUtils.getLogger();
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CommonServerSecurityPipe.class);
    private final boolean isHttpBinding;
    private PipeHelper helper;
    private static final String WSIT_SERVER_AUTH_CONTEXT = "com.sun.xml.wss.provider.wsit.WSITServerAuthContext";

    public CommonServerSecurityPipe(Map props, Pipe next, boolean isHttpBinding) {
        super(next);
        props.put("SECURITY_PIPE", this);
        this.helper = new PipeHelper("SOAP", props, null);
        this.isHttpBinding = isHttpBinding;
    }

    protected CommonServerSecurityPipe(CommonServerSecurityPipe that, PipeCloner cloner) {
        super((AbstractFilterPipeImpl)that, cloner);
        this.helper = that.helper;
        this.isHttpBinding = that.isHttpBinding;
    }

    public void preDestroy() {
        this.helper.disable();
        try {
            Packet request = new Packet();
            PacketMapMessageInfo info = new PacketMapMessageInfo(request, new Packet());
            Subject subj = new Subject();
            ServerAuthContext sAC = this.helper.getServerAuthContext(info, subj);
            if (sAC != null && WSIT_SERVER_AUTH_CONTEXT.equals(sAC.getClass().getName())) {
                sAC.cleanSubject((MessageInfo)info, subj);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.next.preDestroy();
    }

    public Pipe copy(PipeCloner cloner) {
        return new CommonServerSecurityPipe(this, cloner);
    }

    public Packet process(Packet request) {
        Packet response;
        if (this.isHttpBinding) {
            return this.next.process(request);
        }
        try {
            response = this.processRequest(request);
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Failure in security pipe process", e);
            }
            response = this.helper.makeFaultResponse(null, e);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Packet processRequest(Packet request) throws Exception {
        AuthStatus status = AuthStatus.SUCCESS;
        PacketMapMessageInfo info = new PacketMapMessageInfo(request, new Packet());
        Subject serverSubject = (Subject)request.invocationProperties.get("SERVER_SUBJECT");
        ServerAuthContext sAC = this.helper.getServerAuthContext(info, serverSubject);
        Subject clientSubject = CommonServerSecurityPipe.getClientSubject(request);
        try {
            if (sAC != null) {
                status = sAC.validateRequest((MessageInfo)info, clientSubject, serverSubject);
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "AS-WSSECURITY-00002", e);
            WebServiceException wse = new WebServiceException(localStrings.getLocalString("enterprise.webservice.cantValidateRequest", "Cannot validate request for {0}", new Object[]{this.helper.getModelName()}), (Throwable)e);
            status = AuthStatus.SEND_FAILURE;
            Packet packet = this.helper.getFaultResponse(info.getRequestPacket(), info.getResponsePacket(), (Throwable)wse);
            return packet;
        }
        finally {
            Packet validatedRequest = info.getRequestPacket();
            this.helper.auditInvocation(validatedRequest, status);
        }
        Packet response = null;
        if (status == AuthStatus.SUCCESS) {
            Packet validatedRequest;
            boolean authorized = false;
            try {
                this.helper.authorize(validatedRequest);
                authorized = true;
            }
            catch (Exception e) {
                response = this.helper.getFaultResponse(validatedRequest, info.getResponsePacket(), e);
            }
            if (authorized) {
                if (System.getSecurityManager() == null) {
                    try {
                        response = this.next.process(validatedRequest);
                    }
                    catch (Exception e) {
                        _logger.log(Level.SEVERE, "AS-WSSECURITY-00001", e);
                        response = this.helper.getFaultResponse(validatedRequest, info.getResponsePacket(), e);
                    }
                } else {
                    try {
                        response = (Packet)Subject.doAsPrivileged(clientSubject, new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return CommonServerSecurityPipe.this.next.process(validatedRequest);
                            }
                        }, null);
                    }
                    catch (PrivilegedActionException pae) {
                        Throwable cause = pae.getCause();
                        _logger.log(Level.SEVERE, "AS-WSSECURITY-00001", cause);
                        response = this.helper.getFaultResponse(validatedRequest, info.getResponsePacket(), cause);
                    }
                }
            }
            if (response == null) {
                WebServiceException wse = new WebServiceException(localStrings.getLocalString("enterprise.webservice.nullResponsePacket", "Invocation of Service {0} returned null response packet", new Object[]{this.helper.getModelName()}));
                response = this.helper.getFaultResponse(validatedRequest, info.getResponsePacket(), (Throwable)wse);
                _logger.log(Level.SEVERE, "AS-WSSECURITY-00011", (Throwable)wse);
            }
            if (sAC != null && response.getMessage() != null) {
                info.setResponsePacket(response);
                response = this.processResponse(info, sAC, serverSubject);
            }
        } else {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "ws.status_validate_request", status);
            }
            response = info.getResponsePacket();
        }
        return response;
    }

    private Packet processResponse(PacketMessageInfo info, ServerAuthContext sAC, Subject serverSubject) throws Exception {
        AuthStatus status;
        try {
            status = sAC.secureResponse((MessageInfo)info, serverSubject);
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if (_logger.isLoggable(Level.INFO)) {
                    _logger.log(Level.INFO, "AS-WSSECURITY-00003", e);
                }
            } else {
                _logger.log(Level.SEVERE, "AS-WSSECURITY-00003", e);
            }
            return this.helper.makeFaultResponse(info.getResponsePacket(), e);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "ws.status_secure_response", status);
        }
        return info.getResponsePacket();
    }

    private static Subject getClientSubject(Packet p) {
        Subject s = null;
        if (p != null) {
            s = (Subject)p.invocationProperties.get("CLIENT_SUBJECT");
        }
        if (s == null) {
            s = PipeHelper.getClientSubject();
            if (p != null) {
                p.invocationProperties.put("CLIENT_SUBJECT", s);
            }
        }
        return s;
    }
}

