/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jmac.provider;

import com.sun.enterprise.deployment.runtime.common.MessageSecurityBindingDescriptor;
import com.sun.enterprise.deployment.runtime.common.MessageSecurityDescriptor;
import com.sun.enterprise.security.jauth.AuthConfig;
import com.sun.enterprise.security.jauth.AuthException;
import com.sun.enterprise.security.jauth.AuthPolicy;
import com.sun.enterprise.security.jauth.ClientAuthContext;
import com.sun.enterprise.security.jmac.provider.BaseAuthConfig;
import jakarta.xml.ws.handler.soap.SOAPMessageContext;
import java.util.ArrayList;
import javax.security.auth.callback.CallbackHandler;

public class ClientAuthConfig
extends BaseAuthConfig {
    private ClientAuthConfig(ClientAuthContext defaultContext) {
        super(defaultContext);
    }

    private ClientAuthConfig(ArrayList descriptors, ArrayList authContexts) {
        super(descriptors, authContexts);
    }

    public static ClientAuthConfig getConfig(String authLayer, MessageSecurityBindingDescriptor binding, CallbackHandler cbh) throws AuthException {
        ClientAuthConfig rvalue = null;
        String provider = null;
        ArrayList descriptors = null;
        ClientAuthContext defaultContext = null;
        if (binding != null) {
            String layer = binding.getAttributeValue("AuthLayer");
            if (authLayer != null && layer.equals(authLayer)) {
                provider = binding.getAttributeValue("ProviderID");
                descriptors = binding.getMessageSecurityDescriptors();
            }
        }
        if (descriptors == null || descriptors.size() == 0) {
            defaultContext = ClientAuthConfig.getAuthContext(authLayer, provider, null, null, cbh);
            if (defaultContext != null) {
                rvalue = new ClientAuthConfig(defaultContext);
            }
        } else {
            boolean hasPolicy = false;
            ArrayList<ClientAuthContext> authContexts = new ArrayList<ClientAuthContext>();
            for (int i = 0; i < descriptors.size(); ++i) {
                MessageSecurityDescriptor msd = (MessageSecurityDescriptor)descriptors.get(i);
                AuthPolicy requestPolicy = ClientAuthConfig.getAuthPolicy(msd.getRequestProtectionDescriptor());
                AuthPolicy responsePolicy = ClientAuthConfig.getAuthPolicy(msd.getResponseProtectionDescriptor());
                if (requestPolicy.authRequired() || responsePolicy.authRequired()) {
                    authContexts.add(ClientAuthConfig.getAuthContext(authLayer, provider, requestPolicy, responsePolicy, cbh));
                    hasPolicy = true;
                    continue;
                }
                authContexts.add(null);
            }
            if (hasPolicy) {
                rvalue = new ClientAuthConfig(descriptors, authContexts);
            }
        }
        return rvalue;
    }

    private static ClientAuthContext getAuthContext(String layer, String provider, AuthPolicy requestPolicy, AuthPolicy responsePolicy, CallbackHandler cbh) throws AuthException {
        AuthConfig authConfig = AuthConfig.getAuthConfig();
        return authConfig.getClientAuthContext(layer, provider, requestPolicy, responsePolicy, cbh);
    }

    public ClientAuthContext getAuthContext(SOAPMessageContext context) {
        return (ClientAuthContext)this.getContext(context);
    }
}

