/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.authorize;

import com.sun.enterprise.security.authorize.HandlerData;
import jakarta.security.jacc.PolicyContextHandler;
import java.security.SecurityPermission;

public class PolicyContextHandlerImpl
implements PolicyContextHandler {
    public static final String HTTP_SERVLET_REQUEST = "jakarta.servlet.http.HttpServletRequest";
    public static final String SOAP_MESSAGE = "jakarta.xml.soap.SOAPMessage";
    public static final String ENTERPRISE_BEAN = "jakarta.ejb.EnterpriseBean";
    public static final String EJB_ARGUMENTS = "jakarta.ejb.arguments";
    public static final String SUBJECT = "javax.security.auth.Subject.container";
    public static final String REUSE = "java.security.Policy.supportsReuse";
    private static PolicyContextHandlerImpl pchimpl = null;
    private ThreadLocal thisHandlerData = new ThreadLocal();

    private PolicyContextHandlerImpl() {
    }

    private static synchronized PolicyContextHandlerImpl _getInstance() {
        if (pchimpl == null) {
            pchimpl = new PolicyContextHandlerImpl();
        }
        return pchimpl;
    }

    public static PolicyContextHandlerImpl getInstance() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SecurityPermission("setPolicy"));
        }
        return PolicyContextHandlerImpl._getInstance();
    }

    public boolean supports(String key) {
        String[] s;
        for (String element : s = this.getKeys()) {
            if (!element.equalsIgnoreCase(key)) continue;
            return true;
        }
        return false;
    }

    public String[] getKeys() {
        String[] s = new String[]{HTTP_SERVLET_REQUEST, SOAP_MESSAGE, ENTERPRISE_BEAN, SUBJECT, EJB_ARGUMENTS, REUSE};
        return s;
    }

    public Object getContext(String key, Object data) {
        return this.getHandlerData().get(key);
    }

    public HandlerData getHandlerData() {
        HandlerData handlerData = (HandlerData)this.thisHandlerData.get();
        if (handlerData == null) {
            handlerData = HandlerData.getInstance();
            this.thisHandlerData.set(handlerData);
        }
        return handlerData;
    }

    public void reset() {
        HandlerData handlerData = (HandlerData)this.thisHandlerData.get();
        if (handlerData != null) {
            handlerData.reset();
        }
        this.thisHandlerData.set(null);
    }
}

