/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb;

import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.annotation.DomHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.persistence.exceptions.JAXBException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.JAXBErrorHandler;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.platform.xml.XMLTransformer;
import org.eclipse.persistence.sessions.Session;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;

public class DomHandlerConverter
implements XMLConverter {
    private DomHandler domHandler;
    private XMLPlatform xmlPlatform;
    private String domHandlerClassName;
    private Class elementClass;
    private Class resultType;

    public DomHandlerConverter(String domHandlerClassName) {
        this.domHandlerClassName = domHandlerClassName;
    }

    public void initialize(DatabaseMapping mapping, Session session) {
        try {
            ConversionManager cMgr = session.getDatasourcePlatform().getConversionManager();
            Class domHandlerClass = PrivilegedAccessHelper.getClassForName((String)this.domHandlerClassName, (boolean)true, (ClassLoader)cMgr.getLoader());
            Constructor cons = PrivilegedAccessHelper.getDeclaredConstructorFor((Class)domHandlerClass, (Class[])new Class[0], (boolean)true);
            this.domHandler = (DomHandler)PrivilegedAccessHelper.invokeConstructor((Constructor)cons, (Object[])new Object[0]);
            Method createUnmarshallerMethod = PrivilegedAccessHelper.getDeclaredMethod((Class)domHandlerClass, (String)"createUnmarshaller", (Class[])new Class[]{ValidationEventHandler.class});
            this.resultType = PrivilegedAccessHelper.getMethodReturnType((Method)createUnmarshallerMethod);
            Method getElementMethod = PrivilegedAccessHelper.getDeclaredMethod((Class)domHandlerClass, (String)"getElement", (Class[])new Class[]{this.resultType});
            this.elementClass = PrivilegedAccessHelper.getMethodReturnType((Method)getElementMethod);
            this.xmlPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
        }
        catch (Exception ex) {
            throw JAXBException.couldNotInitializeDomHandlerConverter((Exception)ex, (String)this.domHandlerClassName, (String)mapping.getAttributeName());
        }
    }

    public Object convertDataValueToObjectValue(Object dataValue, Session session, XMLUnmarshaller unmarshaller) {
        if (dataValue instanceof Element) {
            ErrorHandler handler = unmarshaller.getErrorHandler();
            Result result = null;
            result = handler != null && handler instanceof JAXBErrorHandler ? this.domHandler.createUnmarshaller(((JAXBErrorHandler)handler).getValidationEventHandler()) : this.domHandler.createUnmarshaller(null);
            if (result instanceof DOMResult) {
                ((DOMResult)result).setNode((Element)dataValue);
            } else {
                this.xmlPlatform.newXMLTransformer().transform((Node)((Element)dataValue), result);
            }
            return this.domHandler.getElement(result);
        }
        return dataValue;
    }

    public Object convertObjectValueToDataValue(Object objectValue, Session session, XMLMarshaller marshaller) {
        if (objectValue != null && this.elementClass.isAssignableFrom(objectValue.getClass())) {
            ErrorHandler handler = marshaller.getErrorHandler();
            Source source = null;
            source = handler != null && handler instanceof JAXBErrorHandler ? this.domHandler.marshal(objectValue, ((JAXBErrorHandler)handler).getValidationEventHandler()) : this.domHandler.marshal(objectValue, null);
            DOMResult result = new DOMResult();
            if (source instanceof DOMSource) {
                Node n = ((DOMSource)source).getNode();
                if (n.getNodeType() == 9) {
                    return ((Document)n).getDocumentElement();
                }
                return n;
            }
            XMLTransformer xmlTransformer = this.xmlPlatform.newXMLTransformer();
            xmlTransformer.setFormattedOutput(marshaller.isFormattedOutput());
            xmlTransformer.transform(source, (Result)result);
            return result.getNode().getFirstChild();
        }
        return objectValue;
    }

    public boolean isMutable() {
        return true;
    }

    public Object convertDataValueToObjectValue(Object dataValue, Session session) {
        return this.convertDataValueToObjectValue(dataValue, session, null);
    }

    public Object convertObjectValueToDataValue(Object objectValue, Session session) {
        return this.convertObjectValueToDataValue(objectValue, session, null);
    }
}

