/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.Status;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.ha.HAClusteredBroker;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;

public class ClusterTakeoverInfo {
    private static boolean DEBUG = false;
    private GPacket pkt = null;
    private String brokerID = null;
    private UID storeSession = null;
    private UID brokerSession = null;
    private String brokerHost = null;
    private Long xid = null;
    private boolean fromTaker = true;
    private String taker = null;
    private Long timestamp = null;
    private boolean timedout = false;

    private ClusterTakeoverInfo(String brokerID, UID storeSession, String brokerHost, UID brokerSession, Long xid, boolean fromTaker, boolean timedout) {
        this.brokerID = brokerID;
        this.storeSession = storeSession;
        this.brokerHost = brokerHost;
        this.brokerSession = brokerSession;
        this.xid = xid;
        this.fromTaker = fromTaker;
        this.timedout = timedout;
    }

    private ClusterTakeoverInfo(GPacket pkt) {
        assert (pkt.getType() == 41 || pkt.getType() == 39 || pkt.getType() == 43);
        this.pkt = pkt;
        this.brokerID = (String)pkt.getProp((Object)"brokerID");
        this.storeSession = new UID(((Long)pkt.getProp((Object)"storeSession")).longValue());
        Long v = (Long)pkt.getProp((Object)"brokerSession");
        if (v != null) {
            this.brokerSession = new UID(v.longValue());
        }
        this.brokerHost = (String)pkt.getProp((Object)"brokerHost");
        this.taker = (String)pkt.getProp((Object)"taker");
        this.fromTaker = this.taker != null;
        this.timestamp = (Long)pkt.getProp((Object)"timestamp");
        if (this.timestamp != null) {
            this.timedout = this.timestamp.equals(0L);
        }
        this.xid = (Long)pkt.getProp((Object)"X");
    }

    public static ClusterTakeoverInfo newInstance(String brokerID, UID storeSession) {
        return new ClusterTakeoverInfo(brokerID, storeSession, null, null, null, false, false);
    }

    public static ClusterTakeoverInfo newInstance(String brokerID, UID storeSession, String brokerHost, UID brokerSession, Long xid, boolean fromTaker) {
        return new ClusterTakeoverInfo(brokerID, storeSession, brokerHost, brokerSession, xid, fromTaker, false);
    }

    public static ClusterTakeoverInfo newInstance(String brokerID, UID storeSession, String brokerHost, UID brokerSession, Long xid, boolean fromTaker, boolean timedout) {
        return new ClusterTakeoverInfo(brokerID, storeSession, brokerHost, brokerSession, xid, fromTaker, timedout);
    }

    public static ClusterTakeoverInfo newInstance(GPacket pkt) {
        return new ClusterTakeoverInfo(pkt);
    }

    public GPacket getGPacket(short protocol) throws BrokerException {
        if (!Globals.getHAEnabled() && !Globals.isBDBStore()) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B3100", "Broker is not running in HA mode"));
        }
        if (this.pkt != null) {
            assert (this.pkt.getType() == protocol);
            return this.pkt;
        }
        GPacket gp = GPacket.getInstance();
        gp.putProp((Object)"brokerID", (Object)this.brokerID);
        gp.putProp((Object)"storeSession", (Object)this.storeSession.longValue());
        if (protocol == 41) {
            gp.setType(protocol);
            gp.setBit(1, false);
            return gp;
        }
        HAClusteredBroker cb = (HAClusteredBroker)Globals.getClusterManager().getLocalBroker();
        if (protocol == 39) {
            gp.setType((short)39);
            gp.setBit(1, false);
            gp.putProp((Object)"brokerSession", (Object)this.brokerSession.longValue());
            gp.putProp((Object)"brokerHost", (Object)this.brokerHost);
            if (this.fromTaker) {
                this.taker = cb.getBrokerName();
                gp.putProp((Object)"taker", (Object)this.taker);
                gp.putProp((Object)"timestamp", (Object)cb.getHeartbeat());
                gp.setBit(1, true);
            } else if (this.timedout) {
                gp.putProp((Object)"timestamp", (Object)0L);
            }
            gp.putProp((Object)"X", (Object)this.xid);
            return gp;
        }
        if (protocol == 43) {
            gp.setType((short)43);
            if (this.fromTaker) {
                gp.putProp((Object)"taker", (Object)cb.getBrokerName());
            }
            gp.setBit(1, false);
            gp.putProp((Object)"X", (Object)this.xid);
            return gp;
        }
        throw new BrokerException("Unknown protocol: " + protocol);
    }

    public String getBrokerID() {
        return this.brokerID;
    }

    public UID getStoreSession() {
        return this.storeSession;
    }

    public Long getXid() {
        return this.xid;
    }

    public UID getBrokerSession() {
        return this.brokerSession;
    }

    public String getBrokerHost() {
        return this.brokerHost;
    }

    public String getTaker() {
        return this.taker;
    }

    public Long getTimestamp() {
        assert (this.pkt != null);
        return this.timestamp;
    }

    public boolean isTimedout() {
        return this.timedout;
    }

    public boolean isFromTaker() {
        return this.fromTaker;
    }

    public String toString() {
        if (this.pkt == null) {
            return this.getTaker() + ":[brokerID=" + this.getBrokerID() + ", storeSession=" + this.getStoreSession() + "]" + (String)(this.getBrokerSession() == null ? "" : "brokerSession=" + this.getBrokerSession()) + ", xid=" + this.xid;
        }
        if (this.pkt.getType() == 41) {
            return "[brokerID=" + this.getBrokerID() + ", storeSession=" + this.getStoreSession() + "]";
        }
        if (this.pkt.getType() == 39) {
            Object prefix = "";
            if (DEBUG) {
                if (this.getTaker() != null) {
                    prefix = this.getTaker() + "(" + (String)(this.timestamp == null ? "" : "" + this.timestamp) + ":";
                }
                return (String)prefix + "[brokerID=" + this.getBrokerID() + ", storeSession=" + this.getStoreSession() + "]" + (String)(this.getBrokerSession() == null ? "" : "brokerSession=" + this.getBrokerSession()) + ", " + this.getBrokerHost() + ", xid=" + this.xid;
            }
            return (String)prefix + "[brokerID=" + this.getBrokerID() + ", storeSession=" + this.getStoreSession() + "]" + (String)(this.getBrokerSession() == null ? "" : "brokerSession=" + this.getBrokerSession()) + ", xid=" + this.xid;
        }
        return this.getTaker() + ":[brokerID=" + this.getBrokerID() + ", storeSession=" + this.getStoreSession() + "]" + (String)(this.getBrokerSession() == null ? "" : "brokerSession=" + this.getBrokerSession()) + ", xid=" + this.xid;
    }

    public boolean needReply() {
        assert (this.pkt != null);
        return this.pkt.getBit(1);
    }

    public GPacket getReplyGPacket(short protocol, int status, String reason) {
        assert (this.pkt != null);
        assert (protocol == 40);
        GPacket gp = GPacket.getInstance();
        gp.setType(protocol);
        gp.putProp((Object)"X", this.pkt.getProp((Object)"X"));
        gp.putProp((Object)"brokerID", this.pkt.getProp((Object)"brokerID"));
        gp.putProp((Object)"storeSession", this.pkt.getProp((Object)"storeSession"));
        gp.putProp((Object)"taker", this.pkt.getProp((Object)"taker"));
        gp.putProp((Object)"S", (Object)status);
        if (reason != null) {
            gp.putProp((Object)"reason", (Object)reason);
        }
        return gp;
    }

    public static int getReplyStatus(GPacket reply) {
        return (Integer)reply.getProp((Object)"S");
    }

    public static String getReplyStatusReason(GPacket reply) {
        return (String)reply.getProp((Object)"reason");
    }

    public static Long getReplyXid(GPacket reply) {
        return (Long)reply.getProp((Object)"X");
    }

    public static String toString(GPacket reply) {
        StringBuilder buf = new StringBuilder();
        buf.append("\n\tstatus=").append(Status.getString((int)ClusterTakeoverInfo.getReplyStatus(reply)));
        if (reply.getProp((Object)"reason") != null) {
            buf.append("\n\treason=").append(ClusterTakeoverInfo.getReplyStatusReason(reply));
        }
        buf.append("[brokerID=").append((String)reply.getProp((Object)"brokerID"));
        buf.append(", storeSession=").append(reply.getProp((Object)"storeSession"));
        buf.append("]xid=").append(reply.getProp((Object)"X"));
        buf.append(", taker=").append((String)reply.getProp((Object)"taker"));
        return buf.toString();
    }
}

