/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.jmsclient.XAConnectionImpl;
import com.sun.messaging.jmq.jmsclient.XAResourceForMC;
import com.sun.messaging.jms.ra.ConnectionAdapter;
import com.sun.messaging.jms.ra.ConnectionCreator;
import com.sun.messaging.jms.ra.ConnectionEventListener;
import com.sun.messaging.jms.ra.ConnectionRequestInfo;
import com.sun.messaging.jms.ra.DirectConnection;
import com.sun.messaging.jms.ra.DirectLocalTransaction;
import com.sun.messaging.jms.ra.DirectXAResource;
import com.sun.messaging.jms.ra.LocalTransaction;
import com.sun.messaging.jms.ra.ManagedConnectionFactory;
import com.sun.messaging.jms.ra.ManagedConnectionMetaData;
import com.sun.messaging.jms.ra.QueueConnectionAdapter;
import com.sun.messaging.jms.ra.ResourceAdapter;
import com.sun.messaging.jms.ra.TopicConnectionAdapter;
import com.sun.messaging.jms.ra.Util;
import com.sun.messaging.jms.ra.api.JMSRAManagedConnection;
import jakarta.jms.InvalidClientIDException;
import jakarta.jms.JMSException;
import jakarta.jms.JMSSecurityException;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.EISSystemException;
import jakarta.resource.spi.IllegalStateException;
import jakarta.resource.spi.ResourceAdapterInternalException;
import jakarta.resource.spi.SecurityException;
import jakarta.resource.spi.security.PasswordCredential;
import java.io.PrintWriter;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;

public class ManagedConnection
implements jakarta.resource.spi.ManagedConnection,
JMSRAManagedConnection {
    private ManagedConnectionFactory mcf = null;
    private ConnectionAdapter ca = null;
    private XAResourceForMC xar = null;
    private DirectXAResource dxar = null;
    private XAConnectionImpl xac = null;
    private DirectConnection dc = null;
    private ConnectionEventListener evtlistener = null;
    private LocalTransaction localTransaction = null;
    private DirectLocalTransaction directLocalTransaction = null;
    private boolean ltActive = false;
    private ManagedConnectionMetaData mcMetaData = null;
    private PasswordCredential pwCredential = null;
    private boolean isRADirect = false;
    private boolean destroyed = false;
    private boolean pwcValid;
    private PrintWriter logWriter = null;
    private transient int mcId = 0;
    private static int idCounter = 0;
    private static final transient String _className = "com.sun.messaging.jms.ra.ManagedConnectionFactory";
    protected static final transient String _lgrNameOutboundConnection = "javax.resourceadapter.mqjmsra.outbound.connection";
    protected static final transient Logger _loggerOC = Logger.getLogger("javax.resourceadapter.mqjmsra.outbound.connection");
    protected static final transient String _lgrMIDPrefix = "MQJMSRA_MC";
    protected static final transient String _lgrMID_EET = "MQJMSRA_MC1001: ";
    protected static final transient String _lgrMID_INF = "MQJMSRA_MC1101: ";
    protected static final transient String _lgrMID_WRN = "MQJMSRA_MC2001: ";
    protected static final transient String _lgrMID_ERR = "MQJMSRA_MC3001: ";
    protected static final transient String _lgrMID_EXC = "MQJMSRA_MC4001: ";

    public ManagedConnection(ManagedConnectionFactory mcf, Subject subject, ConnectionRequestInfo cxRequestInfo, ResourceAdapter ra) throws ResourceException {
        String pw;
        String un;
        _loggerOC.entering(_className, "constructor()");
        this.mcId = ++idCounter;
        this.mcf = mcf;
        this.isRADirect = mcf.getEnableRADirect();
        this.pwCredential = Util.getPasswordCredential(mcf, subject, cxRequestInfo);
        this.pwcValid = Util.isPasswordCredentialValid(subject);
        if (this.pwCredential != null) {
            if (this.pwcValid) {
                if (cxRequestInfo != null && cxRequestInfo.getUserName() != null) {
                    _loggerOC.fine("MQJMSRA_MC2001: createConnection API used w/ username, password for Container Auth");
                }
            } else if (cxRequestInfo != null && cxRequestInfo.getUserName() == null) {
                _loggerOC.fine("MQJMSRA_MC2001: createConnection API used w/o username, password for Application Auth");
            }
            un = this.pwCredential.getUserName();
            pw = new String(this.pwCredential.getPassword());
            _loggerOC.finer("MQJMSRA_MC1101: constructor:Using pwCred:u,p=" + un);
        } else {
            un = mcf.getUserName();
            pw = mcf.getPassword();
            _loggerOC.finer("MQJMSRA_MC1101: constructor:Using mcfConfig:u,p=" + un);
        }
        try {
            _loggerOC.finer("MQJMSRA_MC1101: constructor:Creating mcId=" + this.mcId + ":Using xacf config=" + mcf._getXACF().getCurrentConfiguration());
            ConnectionCreator cc = mcf.getConnectionCreator();
            if (this.isRADirect) {
                this.dc = cxRequestInfo != null && cxRequestInfo.getConnectionType() == ConnectionRequestInfo.ConnectionType.QUEUE_CONNECTION ? (DirectConnection)cc._createQueueConnection(un, pw) : (cxRequestInfo != null && cxRequestInfo.getConnectionType() == ConnectionRequestInfo.ConnectionType.TOPIC_CONNECTION ? (DirectConnection)cc._createTopicConnection(un, pw) : (DirectConnection)cc._createConnection(un, pw));
                this.dc.setManaged(true, this);
            } else {
                this.xac = (XAConnectionImpl)mcf._getXACF().createXAConnection(un, pw);
            }
        }
        catch (JMSSecurityException jmsse) {
            SecurityException se = new SecurityException("MQJMSRA_MC4001: constructor:Aborting:JMSException on createConnection=" + jmsse.getMessage(), jmsse.getErrorCode());
            se.initCause((Throwable)jmsse);
            _loggerOC.severe(se.getMessage());
            jmsse.printStackTrace();
            _loggerOC.throwing(_className, "constructor()", se);
            throw se;
        }
        catch (JMSException jmse) {
            ResourceException re = new ResourceException("MQJMSRA_MC4001: constructor:Aborting:JMSException on createConnection=" + jmse.getMessage(), jmse.getErrorCode());
            re.initCause((Throwable)jmse);
            _loggerOC.severe(re.getMessage());
            jmse.printStackTrace();
            _loggerOC.throwing(_className, "constructor()", re);
            throw re;
        }
        this.evtlistener = new ConnectionEventListener(this);
        try {
            if (this.isRADirect) {
                this.dc._setExceptionListener(this.evtlistener);
                this.directLocalTransaction = new DirectLocalTransaction(this, this.dc);
            } else {
                this.xac._setExceptionListenerFromRA(this.evtlistener);
                this.xac.setExtendedEventNotification(true);
                this.ca = cxRequestInfo != null && cxRequestInfo.getConnectionType() == ConnectionRequestInfo.ConnectionType.QUEUE_CONNECTION ? new QueueConnectionAdapter(this, this.xac, ra) : (cxRequestInfo != null && cxRequestInfo.getConnectionType() == ConnectionRequestInfo.ConnectionType.TOPIC_CONNECTION ? new TopicConnectionAdapter(this, this.xac, ra) : new ConnectionAdapter(this, this.xac, ra));
                this.mcMetaData = new ManagedConnectionMetaData(this);
                this.localTransaction = new LocalTransaction(this, this.xac);
                _loggerOC.fine("MQJMSRA_MC1101: constructor:Created mcId=" + this.mcId + ":xacId=" + this.xac._getConnectionID() + ":Using xacf config=" + mcf._getXACF().getCurrentConfiguration());
                this.xac.setEventListener(this.evtlistener);
            }
        }
        catch (JMSException jmse) {
            throw new ResourceAdapterInternalException("MQRA:MC:JMSException upon setExceptionListener", (Throwable)jmse);
        }
        try {
            if (this.isRADirect) {
                this.dxar = this.dc._getXAResource();
            } else {
                this.xar = new XAResourceForMC(this, this.xac, this.xac);
            }
        }
        catch (JMSException jmse) {
            String errMsg = "MQRA:MC:Constr:Exception on xar creation-" + jmse.getMessage();
            System.err.println(errMsg);
            jmse.printStackTrace();
            throw new ResourceAdapterInternalException(errMsg, (Throwable)jmse);
        }
        this.logWriter = null;
        _loggerOC.exiting(_className, "constructor()");
    }

    public void addConnectionEventListener(jakarta.resource.spi.ConnectionEventListener listener) {
        _loggerOC.entering(_className, "addConnectionEventListener():mcId=" + this.mcId, listener);
        this.evtlistener.addConnectionEventListener(listener);
    }

    public void removeConnectionEventListener(jakarta.resource.spi.ConnectionEventListener listener) {
        _loggerOC.entering(_className, "removeConnectionEventListener():mcId=" + this.mcId, listener);
        this.evtlistener.removeConnectionEventListener(listener);
    }

    public void cleanup() throws ResourceException {
        _loggerOC.entering(_className, "cleanup():mcId=" + this.mcId);
        this.checkDestroyed();
        if (this.isRADirect) {
            try {
                this.dc._cleanup();
            }
            catch (JMSException ex) {
                throw new ResourceException((Throwable)ex);
            }
        } else if (this.ca != null) {
            this.ca.cleanup();
        }
    }

    public void destroy() throws ResourceException {
        if (this.destroyed) {
            _loggerOC.warning("MQJMSRA_MC2001: destroy:Previously destroyed-mcId=" + this.mcId);
        } else {
            if (this.isRADirect) {
                try {
                    this.dc.closeAndDestroy();
                }
                catch (JMSException ex) {
                    throw new ResourceException((Throwable)ex);
                }
            } else if (this.ca != null) {
                this.ca.destroy();
            }
            this.destroyed = true;
        }
    }

    public XAResource getXAResource() throws ResourceException {
        _loggerOC.entering(_className, "getXAResource():mcId=" + this.mcId);
        this.checkDestroyed();
        if (this.isRADirect) {
            return this.dxar;
        }
        return this.xar;
    }

    public jakarta.resource.spi.LocalTransaction getLocalTransaction() throws ResourceException {
        _loggerOC.entering(_className, "getLocalTransaction():mcId=" + this.mcId);
        this.checkDestroyed();
        if (this.isRADirect) {
            return this.directLocalTransaction;
        }
        return this.localTransaction;
    }

    public jakarta.resource.spi.ManagedConnectionMetaData getMetaData() throws ResourceException {
        _loggerOC.entering(_className, "getMetaData():mcId=" + this.mcId);
        this.checkDestroyed();
        return this.mcMetaData;
    }

    public Object getConnection(Subject subject, jakarta.resource.spi.ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        Object[] params = new Object[]{subject, cxRequestInfo};
        ConnectionRequestInfo cri = (ConnectionRequestInfo)cxRequestInfo;
        this.checkDestroyed();
        PasswordCredential pwCred = Util.getPasswordCredential(this.mcf, subject, cri);
        if (!Util.isPasswordCredentialEqual(pwCred, this.pwCredential)) {
            throw new SecurityException("MQRA:MC:getConnection-auth failed for Subject-" + (subject != null ? subject.toString() : "null-subject"));
        }
        String cid = this.mcf.getClientId();
        if (cid != null) {
            try {
                if (this.isRADirect) {
                    _loggerOC.fine("MQJMSRA_MC1101: getConnection():mcId=" + this.mcId + ":xacId=" + this.dc.getConnectionId() + ":opening CA;setting ClientId:" + cid);
                    this.dc._activate(cid);
                }
                _loggerOC.fine("MQJMSRA_MC1101: getConnection():mcId=" + this.mcId + ":xacId=" + this.xac._getConnectionID() + ":opening CA;setting ClientId:" + cid);
                this.ca.open(cid);
            }
            catch (InvalidClientIDException icide) {
                EISSystemException re = new EISSystemException("MQRA:MC:InvalidClientIDException-" + icide.getMessage());
                re.initCause((Throwable)icide);
                throw re;
            }
            catch (JMSException jmse) {
                EISSystemException re = new EISSystemException("MQRA:MC:JMSException-" + jmse.getMessage());
                re.initCause((Throwable)jmse);
                throw re;
            }
        } else if (this.isRADirect) {
            try {
                this.dc._activate(null);
            }
            catch (InvalidClientIDException icide) {
                EISSystemException re = new EISSystemException("MQRA:MC:InvalidClientIDException-" + icide.getMessage());
                re.initCause((Throwable)icide);
                throw re;
            }
            catch (JMSException jmse) {
                EISSystemException re = new EISSystemException("MQRA:MC:JMSException-" + jmse.getMessage());
                re.initCause((Throwable)jmse);
                throw re;
            }
        } else {
            _loggerOC.fine("MQJMSRA_MC1101: getConnection():mcId=" + this.mcId + ":xacId=" + this.xac._getConnectionID() + ":opening CA;NO ClientId");
            this.ca.open();
        }
        if (this.isRADirect) {
            return this.dc;
        }
        return this.ca;
    }

    public void associateConnection(Object connection) throws ResourceException {
        _loggerOC.entering(_className, "associateConnection():mcId=" + this.mcId, connection);
        this.checkDestroyed();
        if (this.isRADirect) {
            return;
        }
        if (!(connection instanceof ConnectionAdapter)) {
            throw new ResourceException("MQRA:MC:associateConnection-invalid connection:class=" + connection.getClass() + ":toString=" + connection.toString());
        }
        ConnectionAdapter connection_adapter = (ConnectionAdapter)connection;
        connection_adapter.associateManagedConnection(this);
        this.ca = connection_adapter;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        _loggerOC.entering(_className, "setLogWriter():mcId=" + this.mcId, out);
        this.logWriter = out;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        _loggerOC.entering(_className, "getLogWriter():mcId=" + this.mcId, this.logWriter);
        return this.logWriter;
    }

    @Override
    public int getMCId() {
        return this.mcId;
    }

    public ManagedConnectionFactory getManagedConnectionFactory() {
        return this.mcf;
    }

    public PasswordCredential getPasswordCredential() {
        return this.pwCredential;
    }

    @Override
    public ConnectionAdapter getConnectionAdapter() {
        return this.ca;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public boolean xaTransactionStarted() {
        if (this.ltActive) {
            if (this.isRADirect) {
                return this.directLocalTransaction.started();
            }
            return this.localTransaction.started();
        }
        if (this.isRADirect) {
            return this.dxar.isEnlisted();
        }
        return this.xar.started();
    }

    public boolean xaTransactionActive() {
        if (this.ltActive) {
            if (this.isRADirect) {
                return this.directLocalTransaction.isActive();
            }
            return this.localTransaction.isActive();
        }
        if (this.isRADirect) {
            return this.dxar.isEnlisted();
        }
        return this.xar.isActive();
    }

    @Override
    public long getTransactionID() {
        if (this.ltActive) {
            if (this.isRADirect) {
                return this.directLocalTransaction.getTransactionID();
            }
            return this.localTransaction.getTransactionID();
        }
        if (this.isRADirect) {
            return this.dxar._getTransactionId();
        }
        return this.xar.getTransactionID();
    }

    public void setLTActive(boolean active) {
        this.ltActive = active;
    }

    public void sendEvent(int type, Exception ex) {
        this.evtlistener.sendEvent(type, ex, null);
    }

    public void sendEvent(int type, Exception ex, Object handle) {
        this.evtlistener.sendEvent(type, ex, handle);
    }

    protected void _setDirect(boolean value) {
        this.isRADirect = value;
    }

    private void checkDestroyed() throws ResourceException {
        if (this.destroyed) {
            throw new IllegalStateException("MQRA:MC:Destroyed-Id=" + this.mcId);
        }
    }
}

