/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.io.JMSPacket;
import com.sun.messaging.jms.ra.DirectPacket;
import com.sun.messaging.jms.ra.DirectSession;
import jakarta.jms.JMSException;
import jakarta.jms.TextMessage;

public class DirectTextPacket
extends DirectPacket
implements TextMessage {
    private String text = null;
    private static final transient String _className = "com.sun.messaging.jms.ra.DirectTextPacket";

    public DirectTextPacket(DirectSession ds, String txt) throws JMSException {
        super(ds);
        if (_logFINE) {
            Object[] params = new Object[3];
            params[0] = ds;
            params[2] = txt;
            _loggerOC.entering(_className, "constructor()", params);
        }
        this.text = txt;
    }

    public DirectTextPacket(JMSPacket jmsPacket, long consumerId, DirectSession ds) throws JMSException {
        super(jmsPacket, consumerId, ds);
        this._getMessageBodyFromPacket();
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this.text = null;
    }

    public String getText() throws JMSException {
        if (_logFINE) {
            String methodName = "getText()";
            _loggerJM.fine("MQJMSRA_DM1101: " + methodName + ":");
        }
        return this.text;
    }

    public void setText(String string) throws JMSException {
        String methodName = "setText()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + methodName + ":" + string);
        }
        this.checkForReadOnlyMessageBody(methodName);
        this.text = string;
    }

    @Override
    protected void _setDefaultValues() throws JMSException {
        super._setDefaultValues();
        this.pkt.setPacketType(1);
    }

    @Override
    protected void _setBodyToPacket() throws JMSException {
        if (this.text != null) {
            try {
                super._setMessageBodyOfPacket(this.text.getBytes("UTF8"));
            }
            catch (Exception ex) {
                String errMsg = "MQJMSRA_DM4001: :ERROR setting TextMessage body=" + this.text + ":Exception=" + ex.getMessage();
                _loggerJM.severe(errMsg);
                JMSException jmse = new JMSException(errMsg);
                jmse.initCause((Throwable)ex);
                throw jmse;
            }
        }
    }

    @Override
    protected void _getMessageBodyFromPacket() throws JMSException {
        try {
            byte[] btext = this._getMessageBodyByteArray();
            if (btext != null) {
                this.text = new String(btext, "UTF8");
            }
        }
        catch (Exception e) {
            String errMsg = "MQJMSRA_DM4001: :Exception getting body for receieved TextMessage" + e.getMessage();
            _loggerJM.severe(errMsg);
            JMSException jmse = new JMSException(errMsg);
            jmse.initCause((Throwable)e);
            throw jmse;
        }
    }
}

