/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.logging;

import com.sun.messaging.jmq.jmsclient.ConnectionMetaDataImpl;
import com.sun.messaging.jmq.jmsclient.resources.ClientResources;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class ULFformatter
extends SimpleFormatter {
    public static final String FR_BEGIN = "[#|";
    public static final String FR_END = "|#]\n";
    public static final String FR_DELIMITER = "|";
    public static final String PRODUCT_NAME = ConnectionMetaDataImpl.JMSProviderName + " 6.0";
    public static final ClientResources resources = ClientResources.getResources();
    public static final String pattern = "yyyy-MM-dd'T'HH:mm:ss.SSS z";
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS z", Locale.getDefault());

    @Override
    public synchronized String format(LogRecord record) {
        String str = this.doFormat(record);
        if (str == null) {
            str = super.format(record);
        }
        return str;
    }

    private String doFormat(LogRecord record) {
        StringBuilder sb = new StringBuilder(FR_BEGIN);
        String datestr = this.formatter.format(new Date(record.getMillis()));
        sb.append(datestr).append(FR_DELIMITER);
        sb.append(record.getLevel().getName()).append(FR_DELIMITER);
        sb.append(PRODUCT_NAME).append(FR_DELIMITER);
        sb.append(record.getSourceClassName()).append(FR_DELIMITER);
        Object[] params = record.getParameters();
        int length = 0;
        if (params != null) {
            length = params.length;
        }
        String key = record.getMessage();
        Object msg = null;
        try {
            switch (length) {
                case 0: {
                    msg = resources.getKString(key);
                    break;
                }
                case 1: {
                    msg = resources.getKString(key, params[0]);
                    break;
                }
                case 2: {
                    msg = resources.getKString(key, params[0], params[1]);
                    break;
                }
                default: {
                    msg = resources.getKString(key, params);
                    break;
                }
            }
        }
        catch (Exception e) {
            msg = key;
        }
        Throwable throwable = record.getThrown();
        if (throwable != null) {
            msg = (String)msg + "\n" + ULFformatter.getThrowableMessage(throwable);
        }
        sb.append((String)msg);
        sb.append(FR_END);
        return sb.toString();
    }

    private static String getThrowableMessage(Throwable throwable) {
        String msg = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(baos);
            throwable.printStackTrace(pw);
            pw.flush();
            baos.flush();
            baos.close();
            msg = baos.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return msg;
    }
}

