/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.lists;

import com.sun.messaging.jmq.util.lists.SetEntry;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedSet;

public class FifoSet<E>
extends AbstractSet<E>
implements SortedSet<E> {
    protected SetEntry<E> head = null;
    protected SetEntry<E> tail = null;
    protected Map<Object, SetEntry<E>> lookup = null;
    protected FifoSet<E> parent = null;
    protected SetEntry<E> start = null;
    protected SetEntry<E> end = null;
    protected Object lock = null;

    protected void setLock(Object lock) {
        this.lock = lock;
    }

    @Override
    public String toString() {
        return this.getClass().toString();
    }

    @Override
    public boolean isEmpty() {
        return this.lookup.isEmpty();
    }

    @Override
    public int size() {
        if (this.parent == null) {
            return this.lookup.size();
        }
        if (this.start == null && this.end == null) {
            return 0;
        }
        int cnt = 0;
        Iterator<E> itr = this.iterator();
        while (itr.hasNext()) {
            itr.next();
            ++cnt;
        }
        return cnt;
    }

    @Override
    public boolean contains(Object o) {
        assert (this.lock == null || Thread.holdsLock(this.lock));
        SetEntry<E> se = this.lookup.get(o);
        boolean has = se != null && se.isValid();
        return has;
    }

    public FifoSet() {
        this.lookup = new HashMap<Object, SetEntry<E>>();
        this.head = null;
        this.tail = null;
        this.start = null;
        this.end = null;
        this.parent = null;
    }

    private FifoSet(FifoSet<E> parent, SetEntry<E> start, SetEntry<E> end) {
        this.parent = parent;
        this.lookup = parent.lookup;
        this.start = start;
        this.end = end;
    }

    protected boolean cleanupEntry(SetEntry<E> e) {
        assert (!this.lookup.isEmpty() || this.head == null && this.tail == null);
        assert (this.head != null && this.tail != null || this.head == null && this.tail == null) : "values: " + this.head + "," + this.tail;
        if (e == null) {
            return false;
        }
        boolean retval = e.isValid();
        this.lookup.remove(e.getData());
        e.remove();
        SetEntry<E> oldhead = this.head;
        SetEntry<E> oldtail = this.tail;
        if (this.head == e) {
            this.head = e.getNext();
        }
        if (this.tail == e) {
            this.tail = e.getPrevious();
        }
        assert (this.head != null && this.tail != null || this.head == null && this.tail == null) : "values: \n\thead: " + this.head + "\n\ttail: " + this.tail + "\n\toldhead: " + oldhead + "\n\toldtail: " + oldtail + "\n\tentry removed:" + e + "\n\n";
        return retval;
    }

    @Override
    public Iterator<E> iterator() {
        assert (this.lock == null || Thread.holdsLock(this.lock)) : " lock is " + this.lock + ":" + Thread.holdsLock(this.lock);
        SetEntry<E> beginEntry = this.parent != null ? (this.start == null ? this.parent.head : this.start) : this.head;
        return new SetIterator(beginEntry, this.end);
    }

    @Override
    public Comparator<E> comparator() {
        return null;
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        assert (this.lock == null || Thread.holdsLock(this.lock));
        if (this.parent != null) {
            boolean foundFrom = fromElement == null;
            boolean foundTo = toElement == null;
            for (E o : this) {
                if (!foundFrom && (o == fromElement || o.equals(fromElement))) {
                    foundFrom = true;
                }
                if (!foundTo && (o == toElement || o.equals(toElement))) {
                    foundTo = true;
                }
                if (!foundTo || !foundFrom) continue;
                break;
            }
            if (!foundFrom || !foundTo) {
                throw new IllegalArgumentException("Elements are not in subset");
            }
        }
        SetEntry<E> st = null;
        if (fromElement != null) {
            st = this.lookup.get(fromElement);
        }
        SetEntry<E> end = null;
        if (toElement != null) {
            end = this.lookup.get(toElement);
        }
        return new FifoSet<E>(this, st, end);
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        return this.subSet(null, toElement);
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        return this.subSet(fromElement, null);
    }

    @Override
    public void clear() {
        assert (this.lock == null || Thread.holdsLock(this.lock));
        Iterator<E> itr = this.iterator();
        while (itr.hasNext()) {
            itr.next();
            itr.remove();
        }
        if (this.parent == null) {
            super.clear();
            this.lookup.clear();
        }
        this.head = null;
        this.tail = null;
        this.start = null;
        this.end = null;
    }

    @Override
    public E first() {
        E o;
        assert (this.lock == null || Thread.holdsLock(this.lock));
        SetEntry<E> beginEntry = this.parent != null ? (this.start == null ? this.parent.head : this.start) : this.head;
        E e = o = beginEntry == null ? null : (E)beginEntry.getData();
        if (beginEntry != null && this.lookup.get(o) == null || beginEntry == null && !this.lookup.isEmpty()) assert (false) : "List corrupted: \n\t beginEntry: " + (beginEntry == null ? "null" : beginEntry.toString()) + "\n\t parent : " + this.parent + "\n\t head " + this.head + "\n\t start " + this.start + "\n\t lookup " + this.lookup.toString();
        return o;
    }

    @Override
    public E last() {
        assert (this.lock == null || Thread.holdsLock(this.lock));
        if (this.parent != null) {
            if (this.end != null) {
                return this.end.getPrevious().getData();
            }
            return this.parent.last();
        }
        return this.tail == null ? null : (E)this.tail.getData();
    }

    @Override
    public boolean add(E o) {
        assert (this.lock == null || Thread.holdsLock(this.lock));
        if (this.parent != null) {
            if (this.end != null) {
                throw new IllegalArgumentException("Object added is past end of subset");
            }
            return this.parent.add(o);
        }
        if (this.lookup.get(o) != null) {
            this.remove(o);
        }
        SetEntry<E> e = new SetEntry<E>(o);
        this.lookup.put(o, e);
        if (this.tail != null) {
            this.tail.insertEntryAfter(e);
        }
        this.tail = e;
        if (this.head == null) {
            this.head = this.tail;
        }
        return true;
    }

    @Override
    public boolean remove(Object o) {
        assert (this.lock == null || Thread.holdsLock(this.lock)) : this.lock + " : " + this;
        if (this.parent != null) {
            Iterator<E> itr = this.iterator();
            while (itr.hasNext()) {
                if (itr.next() != o) continue;
                itr.remove();
                return true;
            }
            return false;
        }
        SetEntry<E> e = this.lookup.get(o);
        if (e == null) {
            return false;
        }
        return this.cleanupEntry(e);
    }

    public void sort(Comparator<SetEntry<E>> c) {
        if (this.head == null) {
            return;
        }
        this.head = this.head.sort(c);
        if (this.start != null) {
            this.start = this.head;
        }
        SetEntry<E> e = this.head;
        while (e.next != null) {
            e = e.next;
        }
        this.tail = e;
        if (this.end != null) {
            this.end = this.tail;
        }
    }

    class SetIterator
    implements Iterator<E> {
        SetEntry<E> last_entry = null;
        SetEntry<E> first_entry = null;
        boolean initialPass = true;
        SetEntry<E> current = null;

        public SetIterator(SetEntry<E> initialEntry, SetEntry<E> finalEntry) {
            assert (FifoSet.this.lock == null || Thread.holdsLock(FifoSet.this.lock)) : " lock is " + this$0.lock + ":" + Thread.holdsLock(this$0.lock);
            this.first_entry = initialEntry;
            this.last_entry = finalEntry;
            this.current = null;
            this.initialPass = true;
        }

        @Override
        public boolean hasNext() {
            assert (FifoSet.this.lock == null || Thread.holdsLock(FifoSet.this.lock));
            if (this.current == null && !this.initialPass) {
                return false;
            }
            SetEntry nextEntry = null;
            for (nextEntry = this.initialPass ? this.first_entry : this.current.getNext(); nextEntry != null && !nextEntry.isValid() && nextEntry != this.last_entry; nextEntry = nextEntry.getNext()) {
            }
            return nextEntry != null && nextEntry != this.last_entry && nextEntry.isValid();
        }

        @Override
        public E next() {
            assert (FifoSet.this.lock == null || Thread.holdsLock(FifoSet.this.lock));
            if (this.current == null && this.initialPass) {
                this.current = this.first_entry;
                this.initialPass = false;
            } else {
                this.current = this.current.getNext();
            }
            if (this.current == null) {
                throw new NoSuchElementException("set empty");
            }
            while (this.current != null && !this.current.isValid() && this.current != this.last_entry) {
                this.current = this.current.getNext();
            }
            if (this.current == null || !this.current.isValid() || this.current == this.last_entry) {
                throw new NoSuchElementException("set empty");
            }
            return this.current.getData();
        }

        @Override
        public void remove() {
            if (this.current != null) {
                FifoSet.this.cleanupEntry(this.current);
            }
        }
    }
}

