/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.util.stringifier;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import org.glassfish.admin.amx.util.StringUtil;
import org.glassfish.admin.amx.util.stringifier.Stringifier;

public final class X509CertificateStringifier
implements Stringifier {
    public static final X509CertificateStringifier DEFAULT = new X509CertificateStringifier();

    private static byte[] getFingerprint(byte[] signature, String alg) {
        byte[] result = null;
        try {
            MessageDigest md = MessageDigest.getInstance(alg);
            result = md.digest(signature);
        }
        catch (NoSuchAlgorithmException e) {
            result = signature;
            e.printStackTrace();
        }
        return result;
    }

    public static String stringify(X509Certificate cert) {
        StringBuffer buf = new StringBuffer();
        String NL = "\n";
        buf.append("Issuer: " + cert.getIssuerDN().getName() + "\n");
        buf.append("Issued to: " + cert.getSubjectX500Principal().getName() + "\n");
        buf.append("Version: " + cert.getVersion() + "\n");
        buf.append("Not valid before: " + cert.getNotBefore() + "\n");
        buf.append("Not valid after: " + cert.getNotAfter() + "\n");
        buf.append("Serial number: " + cert.getSerialNumber() + "\n");
        buf.append("Signature algorithm: " + cert.getSigAlgName() + "\n");
        buf.append("Signature algorithm OID: " + cert.getSigAlgOID() + "\n");
        buf.append("Signature fingerprint (MD5): ");
        byte[] fingerprint = X509CertificateStringifier.getFingerprint(cert.getSignature(), "MD5");
        buf.append(StringUtil.toHexString(fingerprint, ":") + "\n");
        buf.append("Signature fingerprint (SHA1): ");
        fingerprint = X509CertificateStringifier.getFingerprint(cert.getSignature(), "SHA1");
        buf.append(StringUtil.toHexString(fingerprint, ":") + "\n");
        return buf.toString();
    }

    @Override
    public String stringify(Object object) {
        return X509CertificateStringifier.stringify((X509Certificate)object);
    }
}

