/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.concurrent;

import jakarta.enterprise.concurrent.ManagedThreadFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.enterprise.concurrent.AbstractManagedThread;
import org.glassfish.enterprise.concurrent.ContextServiceImpl;
import org.glassfish.enterprise.concurrent.internal.ManagedFutureTask;
import org.glassfish.enterprise.concurrent.internal.ThreadExpiredException;
import org.glassfish.enterprise.concurrent.spi.ContextHandle;
import org.glassfish.enterprise.concurrent.spi.ContextSetupProvider;

public class ManagedThreadFactoryImpl
implements ManagedThreadFactory {
    private List<AbstractManagedThread> threads;
    private boolean stopped = false;
    private Lock lock;
    private String name;
    private final ContextSetupProvider contextSetupProvider;
    private final ContextServiceImpl contextService;
    private int priority;
    private long hungTaskThreshold = 0L;
    private AtomicInteger threadIdSequence = new AtomicInteger();
    public static final String MANAGED_THREAD_FACTORY_STOPPED = "ManagedThreadFactory is stopped";

    public ManagedThreadFactoryImpl(String name) {
        this(name, null, 5);
    }

    public ManagedThreadFactoryImpl(String name, ContextServiceImpl contextService) {
        this(name, contextService, 5);
    }

    public ManagedThreadFactoryImpl(String name, ContextServiceImpl contextService, int priority) {
        this.name = name;
        this.contextService = contextService;
        this.contextSetupProvider = contextService != null ? contextService.getContextSetupProvider() : null;
        this.priority = priority;
        this.threads = new ArrayList<AbstractManagedThread>();
        this.lock = new ReentrantLock();
    }

    public String getName() {
        return this.name;
    }

    public long getHungTaskThreshold() {
        return this.hungTaskThreshold;
    }

    public void setHungTaskThreshold(long hungTaskThreshold) {
        this.hungTaskThreshold = hungTaskThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread newThread(Runnable r) {
        this.lock.lock();
        try {
            if (this.stopped) {
                throw new IllegalStateException(MANAGED_THREAD_FACTORY_STOPPED);
            }
            ContextHandle contextHandleForSetup = null;
            if (this.contextSetupProvider != null) {
                contextHandleForSetup = this.contextSetupProvider.saveContext(this.contextService);
            }
            AbstractManagedThread newThread = this.createThread(r, contextHandleForSetup);
            newThread.setPriority(this.priority);
            newThread.setDaemon(true);
            this.threads.add(newThread);
            AbstractManagedThread abstractManagedThread = newThread;
            return abstractManagedThread;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected AbstractManagedThread createThread(final Runnable r, final ContextHandle contextHandleForSetup) {
        if (System.getSecurityManager() == null) {
            return new ManagedThread(r, contextHandleForSetup);
        }
        return (ManagedThread)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new ManagedThread(r, contextHandleForSetup);
            }
        });
    }

    protected void removeThread(ManagedThread t) {
        this.lock.lock();
        try {
            this.threads.remove(t);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected Collection<AbstractManagedThread> getThreads() {
        ArrayList<AbstractManagedThread> result = null;
        this.lock.lock();
        try {
            if (!this.threads.isEmpty()) {
                result = new ArrayList<AbstractManagedThread>(this.threads);
            }
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    public void taskStarting(Thread t, ManagedFutureTask task) {
        if (t instanceof ManagedThread) {
            ManagedThread mt = (ManagedThread)t;
            mt.taskStartTime = System.currentTimeMillis();
            mt.task = task;
        }
    }

    public void taskDone(Thread t) {
        if (t instanceof ManagedThread) {
            ManagedThread mt = (ManagedThread)t;
            mt.taskStartTime = 0L;
            mt.task = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.lock.lock();
        try {
            this.stopped = true;
            for (AbstractManagedThread t : this.threads) {
                try {
                    t.shutdown();
                    t.interrupt();
                }
                catch (SecurityException securityException) {}
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public class ManagedThread
    extends AbstractManagedThread {
        final ContextHandle contextHandleForSetup;
        volatile ManagedFutureTask task;
        volatile long taskStartTime;

        public ManagedThread(Runnable target, ContextHandle contextHandleForSetup) {
            super(target);
            this.task = null;
            this.taskStartTime = 0L;
            this.setName(ManagedThreadFactoryImpl.this.name + "-Thread-" + ManagedThreadFactoryImpl.this.threadIdSequence.incrementAndGet());
            this.contextHandleForSetup = contextHandleForSetup;
        }

        /*
         * Loose catch block
         */
        @Override
        public void run() {
            block11: {
                ContextHandle handle = null;
                try {
                    if (this.contextHandleForSetup != null) {
                        handle = ManagedThreadFactoryImpl.this.contextSetupProvider.setup(this.contextHandleForSetup);
                    }
                    if (this.shutdown) {
                        this.interrupt();
                    }
                    super.run();
                    if (handle == null) break block11;
                }
                catch (ThreadExpiredException ex) {
                    Logger.getLogger("org.glassfish.enterprise.concurrent").log(Level.INFO, ex.toString());
                    if (handle != null) {
                        ManagedThreadFactoryImpl.this.contextSetupProvider.reset(handle);
                    }
                    ManagedThreadFactoryImpl.this.removeThread(this);
                }
                catch (Throwable t) {
                    Logger.getLogger("org.glassfish.enterprise.concurrent").log(Level.SEVERE, ManagedThreadFactoryImpl.this.name, t);
                    if (handle != null) {
                        ManagedThreadFactoryImpl.this.contextSetupProvider.reset(handle);
                    }
                    ManagedThreadFactoryImpl.this.removeThread(this);
                    {
                        catch (Throwable throwable) {
                            if (handle != null) {
                                ManagedThreadFactoryImpl.this.contextSetupProvider.reset(handle);
                            }
                            ManagedThreadFactoryImpl.this.removeThread(this);
                            throw throwable;
                        }
                    }
                }
                ManagedThreadFactoryImpl.this.contextSetupProvider.reset(handle);
            }
            ManagedThreadFactoryImpl.this.removeThread(this);
        }

        @Override
        boolean cancelTask() {
            if (this.task != null) {
                return this.task.cancel(true);
            }
            return false;
        }

        @Override
        public String getTaskIdentityName() {
            if (this.task != null) {
                return this.task.getTaskIdentityName();
            }
            return "null";
        }

        @Override
        public long getTaskRunTime(long now) {
            if (this.task != null && this.taskStartTime > 0L) {
                long taskRunTime = now - this.taskStartTime;
                return taskRunTime > 0L ? taskRunTime : 0L;
            }
            return 0L;
        }

        @Override
        public long getThreadStartTime() {
            return this.threadStartTime;
        }

        @Override
        boolean isTaskHung(long now) {
            if (ManagedThreadFactoryImpl.this.hungTaskThreshold > 0L) {
                return this.getTaskRunTime(now) - ManagedThreadFactoryImpl.this.hungTaskThreshold > 0L;
            }
            return false;
        }
    }
}

