/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.api.ManagedTaskListener;

import ee.jakarta.tck.concurrent.api.ManagedTaskListener.RunnableTaskWithException;
import ee.jakarta.tck.concurrent.api.ManagedTaskListener.RunnableTaskWithStatus;
import ee.jakarta.tck.concurrent.common.managedTaskListener.ListenerEvent;
import ee.jakarta.tck.concurrent.common.managedTaskListener.ManagedTaskListenerImpl;
import ee.jakarta.tck.concurrent.framework.ArquillianTests;
import ee.jakarta.tck.concurrent.framework.TestConstants;
import ee.jakarta.tck.concurrent.framework.TestLogger;
import ee.jakarta.tck.concurrent.framework.TestUtil;
import jakarta.enterprise.concurrent.ManagedExecutors;
import jakarta.enterprise.concurrent.ManagedTaskListener;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.Future;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class ManagedTaskListenerTests
extends ArquillianTests {
    private static final TestLogger log = TestLogger.get(ManagedTaskListenerTests.class);
    private ManagedTaskListenerImpl managedTaskListener = new ManagedTaskListenerImpl();

    @Deployment(name="ManagedTaskListenerTests")
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addPackages(true, new Package[]{ManagedTaskListenerTests.getFrameworkPackage(), ManagedTaskListenerTests.getCommonPackage(), ManagedTaskListenerTests.getCommonManagedTaskListener(), ManagedTaskListenerTests.class.getPackage()});
    }

    @AfterClass
    public void cleanup() {
        this.managedTaskListener.clearEvents();
    }

    @Test
    public void TaskAborted() throws InterruptedException {
        int blockTime = 3000;
        RunnableTaskWithStatus runnableTask = new RunnableTaskWithStatus(this.managedTaskListener, blockTime);
        Runnable taskWithListener = ManagedExecutors.managedTask((Runnable)runnableTask, (ManagedTaskListener)this.managedTaskListener);
        Future futureResult = TestUtil.getManagedExecutorService().submit(taskWithListener);
        TestUtil.sleep(Duration.ofMillis(1000L));
        futureResult.cancel(true);
        TestUtil.waitForListenerComplete(this.managedTaskListener, (long)blockTime + TestConstants.WaitTimeout.toMillis(), TestConstants.PollInterval.toMillis());
        List<ListenerEvent> events = this.managedTaskListener.events();
        this.assertTrue("Listener taskAborted failed", events.contains((Object)ListenerEvent.ABORTED));
        this.assertTrue("Listener taskAborted failed", futureResult.isCancelled());
    }

    @Test
    public void TaskDone() throws InterruptedException {
        int blockTime = 3000;
        RunnableTaskWithStatus taskToCancelled = new RunnableTaskWithStatus(this.managedTaskListener, 3000);
        Runnable taskToCancelledWithListener = ManagedExecutors.managedTask((Runnable)taskToCancelled, (ManagedTaskListener)this.managedTaskListener);
        Future futureResult = TestUtil.getManagedExecutorService().submit(taskToCancelledWithListener);
        TestUtil.sleep(Duration.ofMillis(1000L));
        futureResult.cancel(true);
        TestUtil.waitForListenerComplete(this.managedTaskListener, 3000L + TestConstants.WaitTimeout.toMillis(), TestConstants.PollInterval.toMillis());
        List<ListenerEvent> events = this.managedTaskListener.events();
        this.assertTrue("Listener taskDone failed in cancel case.", events.contains((Object)ListenerEvent.DONE));
        this.managedTaskListener.clearEvents();
        RunnableTaskWithStatus runTask = new RunnableTaskWithStatus(this.managedTaskListener);
        Runnable runtaskWithListener = ManagedExecutors.managedTask((Runnable)runTask, (ManagedTaskListener)this.managedTaskListener);
        TestUtil.getManagedExecutorService().submit(runtaskWithListener);
        TestUtil.waitForListenerComplete(this.managedTaskListener);
        List<ListenerEvent> runevents = this.managedTaskListener.events();
        this.assertTrue("Listener TaskDone failed", runevents.contains((Object)ListenerEvent.DONE));
        this.managedTaskListener.clearEvents();
        RunnableTaskWithException taskWithException = new RunnableTaskWithException(this.managedTaskListener);
        Runnable taskWithExceptionListener = ManagedExecutors.managedTask((Runnable)taskWithException, (ManagedTaskListener)this.managedTaskListener);
        TestUtil.getManagedExecutorService().submit(taskWithExceptionListener);
        TestUtil.waitForListenerComplete(this.managedTaskListener);
        List<ListenerEvent> runeventsWithException = this.managedTaskListener.events();
        log.fine("++ runeventsWithException : " + runeventsWithException);
        this.assertTrue("Listener TaskDone failed with exception task.", runeventsWithException.contains((Object)ListenerEvent.DONE));
    }

    @Test
    public void TaskStarting() {
        RunnableTaskWithStatus runnableTask = new RunnableTaskWithStatus(this.managedTaskListener);
        Runnable taskWithListener = ManagedExecutors.managedTask((Runnable)runnableTask, (ManagedTaskListener)this.managedTaskListener);
        TestUtil.getManagedExecutorService().submit(taskWithListener);
        TestUtil.waitForListenerComplete(this.managedTaskListener);
        List<ListenerEvent> events = this.managedTaskListener.events();
        int submitAt = events.indexOf((Object)ListenerEvent.SUBMITTED);
        int startAt = events.indexOf((Object)ListenerEvent.STARTING);
        int runAt = events.indexOf((Object)ListenerEvent.TASK_RUN);
        if ((submitAt != 0 || startAt != 1) && runAt == 2) {
            this.fail("Listener TaskStarting failed to run in expected order");
        }
    }

    @Test
    public void TaskSubmitted() {
        RunnableTaskWithStatus runnableTask = new RunnableTaskWithStatus(this.managedTaskListener);
        Runnable taskWithListener = ManagedExecutors.managedTask((Runnable)runnableTask, (ManagedTaskListener)this.managedTaskListener);
        TestUtil.getManagedExecutorService().submit(taskWithListener);
        TestUtil.waitForListenerComplete(this.managedTaskListener);
        List<ListenerEvent> events = this.managedTaskListener.events();
        int submitAt = events.indexOf((Object)ListenerEvent.SUBMITTED);
        this.assertEquals("Listener TaskSubmitted failed to run in expected order", 0, submitAt);
    }
}

